/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.command;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.MappingState;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.impl.state.VimStateMachineImplKt;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.key.KeyMappingLayer;
import com.maddyhome.idea.vim.key.MappingInfoLayer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010!\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/maddyhome/idea/vim/command/MappingProcessor;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "<init>", "()V", "log", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "consumeKey", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "isMappingApplicable", "commandBuilder", "Lcom/maddyhome/idea/vim/command/CommandBuilder;", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "isTypingZeroInCommandCount", "tryHandleUnfinishedMappingSequence", "mapping", "Lcom/maddyhome/idea/vim/key/KeyMappingLayer;", "onUnfinishedMappingSequenceTimeout", "", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "tryHandleCompletedMappingSequence", "executeMappingInfo", "mappingInfo", "Lcom/maddyhome/idea/vim/key/MappingInfoLayer;", "tryHandleAbandonedMappingSequence", "replayUnhandledKeys", "unhandledKeys", "", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMappingProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingProcessor.kt\ncom/maddyhome/idea/vim/command/MappingProcessor\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n27#2,4:303\n27#2,4:307\n27#2,4:311\n33#2,4:315\n38#2:324\n1869#3,2:319\n1878#3,3:321\n*S KotlinDebug\n*F\n+ 1 MappingProcessor.kt\ncom/maddyhome/idea/vim/command/MappingProcessor\n*L\n37#1:303,4\n54#1:307,4\n58#1:311,4\n67#1:315,4\n29#1:324\n282#1:319,2\n297#1:321,3\n*E\n"})
public final class MappingProcessor
implements KeyConsumer {
    @NotNull
    public static final MappingProcessor INSTANCE = new MappingProcessor();
    @NotNull
    private static final VimLogger log;

    private MappingProcessor() {
    }

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder) {
        VimLogger vimLogger;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        VimLogger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Entered MappingProcessor with key " + key);
        }
        if (!allowKeyMappings) {
            return false;
        }
        log.debug("Start processing key mappings.");
        KeyHandlerState keyState = keyProcessResultBuilder.getState();
        if (!this.isMappingApplicable(keyState.getCommandBuilder(), key, keyState)) {
            log.debug("Mapping not applicable. Finish key processing, returning false");
            return false;
        }
        MappingState mappingState = keyState.getMappingState();
        mappingState.stopMappingTimer();
        VimLogger $this$trace$iv2 = log;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTrace()) {
            vimLogger = $this$trace$iv2;
            boolean bl = false;
            vimLogger.trace("Add key to mapping state: " + key);
        }
        mappingState.addKey(key);
        MappingMode mappingMode = VimStateMachineImplKt.toMappingMode(editor.getMode());
        VimLogger $this$trace$iv3 = log;
        boolean $i$f$trace3 = false;
        if ($this$trace$iv3.isTrace()) {
            vimLogger = $this$trace$iv3;
            boolean bl = false;
            vimLogger.trace("Get keys for mapping mode. mode = " + mappingMode);
        }
        KeyMappingLayer mapping = VimInjectorKt.getInjector().getKeyGroup().getKeyMappingLayer(mappingMode);
        boolean mappingProcessed = this.tryHandleUnfinishedMappingSequence(editor, keyProcessResultBuilder, mapping) || this.tryHandleCompletedMappingSequence(keyProcessResultBuilder, mapping) || this.tryHandleAbandonedMappingSequence(keyProcessResultBuilder);
        VimLogger $this$debug$iv = log;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("Finish mapping processing. Return " + mappingProcessed);
        }
        return mappingProcessed;
    }

    private final boolean isMappingApplicable(CommandBuilder commandBuilder, KeyStroke key, KeyHandlerState keyState) {
        return !commandBuilder.isAwaitingCharOrDigraphArgument() && !commandBuilder.isBuildingMultiKeyCommand() && !commandBuilder.isRegisterPending() && !this.isTypingZeroInCommandCount(key, keyState);
    }

    private final boolean isTypingZeroInCommandCount(KeyStroke key, KeyHandlerState keyState) {
        return key.getKeyChar() == '0' && keyState.getCommandBuilder().hasCountCharacters();
    }

    private final boolean tryHandleUnfinishedMappingSequence(VimEditor editor, KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder, KeyMappingLayer mapping) {
        log.trace("Try processing unfinished mappings...");
        Iterable<KeyStroke> iterable = keyProcessResultBuilder.getState().getMappingState().getKeys();
        List list = iterable instanceof List ? (List)iterable : null;
        if (list == null) {
            list = CollectionsKt.toList(keyProcessResultBuilder.getState().getMappingState().getKeys());
        }
        if (!mapping.isPrefix(list)) {
            log.debug("There are no mappings that start with the current sequence. Mapping processor will not handle further.");
            return false;
        }
        if (VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getTimeout()) {
            log.trace("'timeout' is set. Scheduling the mapping timer");
            keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> MappingProcessor.tryHandleUnfinishedMappingSequence$lambda$5(editor, arg_0, arg_1, arg_2)));
        } else {
            log.trace("'timeout' is not set. Waiting for the next keystroke");
        }
        return true;
    }

    private final void onUnfinishedMappingSequenceTimeout(VimEditor editor, KeyHandlerState keyState, ExecutionContext context) {
        VimInjectorKt.getInjector().getApplication().invokeLater(editor, (Function0<Unit>)((Function0)() -> MappingProcessor.onUnfinishedMappingSequenceTimeout$lambda$6(keyState, editor, context)));
    }

    private final boolean tryHandleCompletedMappingSequence(KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder, KeyMappingLayer mapping) {
        MappingInfoLayer mappingInfo;
        log.trace("Try processing complete mapping sequence...");
        MappingState mappingState = keyProcessResultBuilder.getState().getMappingState();
        Iterable<KeyStroke> iterable = mappingState.getKeys();
        List list = iterable instanceof List ? (List)iterable : null;
        if (list == null) {
            list = CollectionsKt.toList(mappingState.getKeys());
        }
        if ((mappingInfo = mapping.getLayer(list)) == null) {
            log.trace("Cannot find any mapping info for the sequence. Mapping processor will not handle further.");
            return false;
        }
        keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> MappingProcessor.tryHandleCompletedMappingSequence$lambda$7(mappingInfo, arg_0, arg_1, arg_2)));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeMappingInfo(MappingInfoLayer mappingInfo, VimEditor editor, ExecutionContext context, KeyHandlerState keyState) {
        MappingState mappingState = keyState.getMappingState();
        try {
            mappingState.startMapExecution();
            mappingInfo.execute(editor, context, keyState);
        }
        catch (Exception e) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, e.getMessage());
            VimInjectorKt.getInjector().getMessages().indicateError();
            log.error(StringsKt.trimIndent((String)("\n                  Caught exception during " + mappingInfo.getPresentableString() + "\n                  " + e.getMessage() + "\n          ")), e);
        }
        catch (NotImplementedError e) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, e.getMessage());
            VimInjectorKt.getInjector().getMessages().indicateError();
            log.error(StringsKt.trimIndent((String)("\n                  Caught exception during " + mappingInfo.getPresentableString() + "\n                  " + e.getMessage() + "\n          ")), e);
        }
        finally {
            mappingState.stopMapExecution();
        }
    }

    private final boolean tryHandleAbandonedMappingSequence(KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder) {
        log.debug("Trying to process abandoned mapping sequence...");
        List<KeyStroke> unhandledKeyStrokes = keyProcessResultBuilder.getState().getMappingState().detachKeys();
        if (unhandledKeyStrokes.size() == 1) {
            log.trace("There is only one key in abandoned mapping sequence. Mapping processor will not handle further.");
            return false;
        }
        keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)(arg_0, arg_1, arg_2) -> MappingProcessor.tryHandleAbandonedMappingSequence$lambda$8(unhandledKeyStrokes, arg_0, arg_1, arg_2)));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void replayUnhandledKeys(List<? extends KeyStroke> unhandledKeys, VimEditor editor, ExecutionContext context, KeyHandlerState keyState) {
        log.trace("Replaying unhandled keys. Looking for mapping in subsequence");
        KeyMappingLayer mappingLayer = VimInjectorKt.getInjector().getKeyGroup().getKeyMappingLayer(VimStateMachineImplKt.toMappingMode(editor.getMode()));
        List subsequence = CollectionsKt.toMutableList((Collection)unhandledKeys);
        while (!((Collection)subsequence).isEmpty()) {
            MappingInfoLayer mappingInfo = mappingLayer.getLayer(subsequence);
            if (mappingInfo != null) {
                log.trace("Found mapping. Executing it and replaying the rest of the keys");
                this.executeMappingInfo(mappingInfo, editor, context, keyState);
                Iterable $this$forEach$iv = unhandledKeys.subList(subsequence.size(), unhandledKeys.size());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KeyStroke it = (KeyStroke)element$iv;
                    boolean bl = false;
                    KeyHandler.Companion.getInstance().handleKey(editor, it, context, true, keyState);
                }
                return;
            }
            subsequence.removeLast();
        }
        log.trace("Replaying unhandled keys. There is no mapping in subsequence. Replaying all keys");
        KeyHandler keyHandler = KeyHandler.Companion.getInstance();
        Iterable $this$forEachIndexed$iv = unhandledKeys;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KeyStroke keyStroke = (KeyStroke)item$iv;
            int index = n;
            boolean bl = false;
            keyHandler.handleKey(editor, (KeyStroke)it, context, index != 0, keyState);
        }
    }

    private static final void tryHandleUnfinishedMappingSequence$lambda$5$lambda$4(VimEditor $editor, KeyHandlerState $ks, ExecutionContext $c, ActionEvent it) {
        INSTANCE.onUnfinishedMappingSequenceTimeout($editor, $ks, $c);
    }

    private static final Unit tryHandleUnfinishedMappingSequence$lambda$5(VimEditor $editor, KeyHandlerState ks, VimEditor e, ExecutionContext c) {
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ks.getMappingState().startMappingTimer(arg_0 -> MappingProcessor.tryHandleUnfinishedMappingSequence$lambda$5$lambda$4($editor, ks, c, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit onUnfinishedMappingSequenceTimeout$lambda$6(KeyHandlerState $keyState, VimEditor $editor, ExecutionContext $context) {
        log.debug("Callback for 'timeout'. Replaying unhandled keys");
        List<KeyStroke> unhandledKeys = $keyState.getMappingState().detachKeys();
        if ($editor.isDisposed() || unhandledKeys.isEmpty()) {
            log.debug("Abandon mapping timer");
            return Unit.INSTANCE;
        }
        INSTANCE.replayUnhandledKeys(unhandledKeys, $editor, $context, $keyState);
        return Unit.INSTANCE;
    }

    private static final Unit tryHandleCompletedMappingSequence$lambda$7(MappingInfoLayer $mappingInfo, KeyHandlerState ks, VimEditor e, ExecutionContext c) {
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        log.trace("Executing mapping");
        MappingState mappingState = ks.getMappingState();
        mappingState.resetMappingSequence();
        INSTANCE.executeMappingInfo($mappingInfo, e, c, ks);
        log.trace("Completed mapping sequence processed. Returning true.");
        return Unit.INSTANCE;
    }

    private static final Unit tryHandleAbandonedMappingSequence$lambda$8(List $unhandledKeyStrokes, KeyHandlerState ks, VimEditor e, ExecutionContext c) {
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        log.trace("Replaying abandoned keys");
        INSTANCE.replayUnhandledKeys($unhandledKeyStrokes, e, c, ks);
        log.trace("Abandoned keys processed. Returning true.");
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$vimLogger = false;
        log = VimInjectorKt.getInjector().getLogger(MappingProcessor.class);
    }
}

