/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.ranges;

import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimSearchGroup;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.ranges.Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0014J\u0013\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/SearchAddress;", "Lcom/maddyhome/idea/vim/ex/ranges/Address;", "pattern", "", "offset", "", "move", "", "<init>", "(Ljava/lang/String;IZ)V", "patterns", "", "directions", "Lcom/maddyhome/idea/vim/common/Direction;", "calculateLine1", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "getSearchOffset", "line", "direction", "applyOffset", "equals", "other", "", "hashCode", "toString", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nAddress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Address.kt\ncom/maddyhome/idea/vim/ex/ranges/SearchAddress\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,309:1\n33#2,4:310\n38#2:314\n*S KotlinDebug\n*F\n+ 1 Address.kt\ncom/maddyhome/idea/vim/ex/ranges/SearchAddress\n*L\n211#1:310,4\n204#1:314\n*E\n"})
final class SearchAddress
extends Address {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> patterns;
    @NotNull
    private final List<Direction> directions;
    @NotNull
    private static final VimLogger logger;

    /*
     * Enabled aggressive block sorting
     */
    public SearchAddress(@NotNull String pattern, int offset, boolean move) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        super(offset, move, null);
        this.patterns = new ArrayList();
        this.directions = new ArrayList();
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("pattern=" + pattern);
        }
        StringTokenizer tok = new StringTokenizer(pattern, "\u0000");
        block10: while (tok.hasMoreTokens()) {
            String string;
            boolean bl;
            String pat = tok.nextToken();
            String string2 = pat;
            if (string2 != null) {
                int n = -1;
                switch (string2.hashCode()) {
                    case 2899: {
                        if (!string2.equals("\\/")) break;
                        n = 1;
                        break;
                    }
                    case 2915: {
                        if (!string2.equals("\\?")) break;
                        n = 2;
                        break;
                    }
                    case 2890: {
                        if (!string2.equals("\\&")) break;
                        n = 3;
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        this.patterns.add(VimInjectorKt.getInjector().getSearchGroup().getLastSearchPattern());
                        bl = this.directions.add(Direction.FORWARDS);
                        continue block10;
                    }
                    case 2: {
                        this.patterns.add(VimInjectorKt.getInjector().getSearchGroup().getLastSearchPattern());
                        bl = this.directions.add(Direction.BACKWARDS);
                        continue block10;
                    }
                    case 3: {
                        this.patterns.add(VimInjectorKt.getInjector().getSearchGroup().getLastSubstitutePattern());
                        bl = this.directions.add(Direction.FORWARDS);
                        continue block10;
                    }
                }
            }
            boolean bl2 = pat.charAt(0) == '/' ? this.directions.add(Direction.FORWARDS) : this.directions.add(Direction.BACKWARDS);
            String string3 = pat;
            Intrinsics.checkNotNull((Object)string3);
            if (StringsKt.last((CharSequence)string3) == pat.charAt(0)) {
                string3 = pat;
                Intrinsics.checkNotNull((Object)string3);
                var8_11 = 1;
                int n = pat.length() - 1;
                String string4 = string3.substring(var8_11, n);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            } else {
                string3 = pat;
                Intrinsics.checkNotNull((Object)string3);
                var8_11 = 1;
                String string5 = string3.substring(var8_11);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            }
            pat = string;
            bl = this.patterns.add(pat);
        }
        return;
    }

    @Override
    protected int calculateLine1(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int line0 = caret.getBufferPosition().getLine();
        int searchOffset = 0;
        int n = ((Collection)this.patterns).size();
        for (int i = 0; i < n; ++i) {
            String pattern = this.patterns.get(i);
            Direction direction = this.directions.get(i);
            int patternOffset = i == this.patterns.size() - 1 ? this.getOffset() : 0;
            searchOffset = this.getSearchOffset(editor, line0, direction);
            VimSearchGroup vimSearchGroup = VimInjectorKt.getInjector().getSearchGroup();
            String string = pattern;
            Intrinsics.checkNotNull((Object)string);
            searchOffset = vimSearchGroup.processSearchRange(editor, string, patternOffset, searchOffset, direction);
            if (searchOffset == -1) {
                if (VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getWrapscan()) {
                    Object[] objectArray = new Object[]{pattern};
                    throw ExExceptionsKt.exExceptionMessage("E486", objectArray);
                }
                Object[] objectArray = new Object[]{pattern};
                throw ExExceptionsKt.exExceptionMessage("E385", objectArray);
            }
            line0 = editor.offsetToBufferPosition(searchOffset).getLine();
        }
        return line0 + 1;
    }

    private final int getSearchOffset(VimEditor editor, int line, Direction direction) {
        return direction == Direction.FORWARDS ? VimInjectorKt.getInjector().getMotion().moveCaretToLineEnd(editor, line, true) : VimInjectorKt.getInjector().getMotion().moveCaretToLineStart(editor, line);
    }

    @Override
    protected int applyOffset(int line) {
        return line != -1 ? RangesKt.coerceAtLeast((int)(line + this.getOffset()), (int)0) : line;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!super.equals(other)) return false;
        SearchAddress searchAddress = other instanceof SearchAddress ? (SearchAddress)other : null;
        if (!Intrinsics.areEqual(searchAddress != null ? searchAddress.patterns : null, this.patterns)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * ((Object)this.patterns).hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return "SearchAddress[patterns=" + this.patterns + ", " + super.toString() + "]";
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(SearchAddress.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/SearchAddress$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

