/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.key.KeyMappingEntry;
import com.maddyhome.idea.vim.key.KeyMappingLayer;
import com.maddyhome.idea.vim.key.KeyStrokeTrie;
import com.maddyhome.idea.vim.key.MappingInfo;
import com.maddyhome.idea.vim.key.MappingInfoLayer;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.key.ToActionMappingInfo;
import com.maddyhome.idea.vim.key.ToExpressionMappingInfo;
import com.maddyhome.idea.vim.key.ToHandlerMappingInfo;
import com.maddyhome.idea.vim.key.ToKeysMappingInfo;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0086\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001H\u0087\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u0015\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0013H\u0097\u0002J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ:\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J@\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010\"\u001a\u00020#JB\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010'\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#J\u001e\u0010(\u001a\u00020\u001c2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010)\u001a\u00020\u000bH\u0002J\u0014\u0010*\u001a\u00020\u001c2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010,\u001a\u00020\u001cJ\u0016\u0010-\u001a\u00020#2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u0014\u0010.\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J0\u0010/\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u000b000\u00022\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/maddyhome/idea/vim/key/KeyMapping;", "", "", "Ljavax/swing/KeyStroke;", "Lcom/maddyhome/idea/vim/key/KeyMappingLayer;", "mode", "Lcom/maddyhome/idea/vim/command/MappingMode;", "<init>", "(Lcom/maddyhome/idea/vim/command/MappingMode;)V", "keysTrie", "Lcom/maddyhome/idea/vim/key/KeyStrokeTrie;", "Lcom/maddyhome/idea/vim/key/MappingInfo;", "get", "keys", "getLayer", "Lcom/maddyhome/idea/vim/key/MappingInfoLayer;", "getActionNameFromActionMapping", "", "iterator", "", "getAll", "Lkotlin/sequences/Sequence;", "Lcom/maddyhome/idea/vim/key/KeyMappingEntry;", "prefix", "getAllByOwner", "owner", "Lcom/maddyhome/idea/vim/key/MappingOwner;", "put", "", "fromKeys", "originalModes", "", "extensionHandler", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "recursive", "", "toKeys", "toExpression", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "originalString", "add", "mappingInfo", "removeKeyMapping", "removeKeyMappingsByOwner", "clear", "isPrefix", "hasmapto", "getMapTo", "Lkotlin/Pair;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nKeyMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyMapping.kt\ncom/maddyhome/idea/vim/key/KeyMapping\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,201:1\n1#2:202\n57#3,2:203\n19#3:205\n59#3,2:206\n61#3:212\n37#4:208\n36#4,3:209\n1869#5,2:213\n1255#6,2:215\n*S KotlinDebug\n*F\n+ 1 KeyMapping.kt\ncom/maddyhome/idea/vim/key/KeyMapping\n*L\n55#1:203,2\n55#1:205\n55#1:206,2\n55#1:212\n55#1:208\n55#1:209,3\n155#1:213,2\n186#1:215,2\n*E\n"})
public final class KeyMapping
implements Iterable<List<? extends KeyStroke>>,
KeyMappingLayer,
KMappedMarker {
    @NotNull
    private final MappingMode mode;
    @NotNull
    private final KeyStrokeTrie<MappingInfo> keysTrie;

    public KeyMapping(@NotNull MappingMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.mode = mode;
        this.keysTrie = new KeyStrokeTrie(this.mode.name());
    }

    @Nullable
    public final MappingInfo get(@NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        MappingInfo mappingInfo = this.keysTrie.getData(keys);
        if (mappingInfo != null) {
            MappingInfo it = mappingInfo;
            boolean bl = false;
            return it;
        }
        String string = this.getActionNameFromActionMapping(keys);
        if (string != null) {
            EnumSet<Enum> enumSet;
            String it = string;
            boolean bl = false;
            MappingOwner mappingOwner = MappingOwner.IdeaVim.System.INSTANCE;
            MappingMode[] mappingModeArray = new MappingMode[]{this.mode};
            Object[] value$iv = mappingModeArray;
            boolean $i$f$enumSetOf = false;
            switch (value$iv.length) {
                case 0: {
                    boolean $i$f$noneOfEnum = false;
                    EnumSet<MappingMode> enumSet2 = EnumSet.noneOf(MappingMode.class);
                    enumSet = enumSet2;
                    Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
                    break;
                }
                case 1: {
                    EnumSet<Enum> enumSet3 = EnumSet.of(value$iv[0]);
                    enumSet = enumSet3;
                    Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
                    break;
                }
                default: {
                    Collection $this$toTypedArray$iv$iv = ArraysKt.slice((Object[])value$iv, (IntRange)new IntRange(1, ArraysKt.getLastIndex((Object[])value$iv)));
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                    Enum[] enumArray = thisCollection$iv$iv.toArray(new MappingMode[0]);
                    EnumSet<Enum[]> enumSet4 = EnumSet.of(value$iv[0], Arrays.copyOf(enumArray, enumArray.length));
                    enumSet = enumSet4;
                    Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
                }
            }
            return new ToActionMappingInfo(it, keys, false, mappingOwner, (Set<? extends MappingMode>)enumSet);
        }
        return null;
    }

    @Override
    @Nullable
    public MappingInfoLayer getLayer(@NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        return this.get(keys);
    }

    @Deprecated(message="Use get(List<KeyStroke>) to maintain the same lookup key type and avoid unnecessary wrapping")
    @Nullable
    public final MappingInfo get(@NotNull Iterable<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        List list = keys instanceof List ? (List)keys : null;
        if (list == null) {
            list = CollectionsKt.toList(keys);
        }
        return this.get(list);
    }

    private final String getActionNameFromActionMapping(List<? extends KeyStroke> keys) {
        if (keys.size() > 3 && keys.get(0).getKeyCode() == VimInjectorKt.getInjector().getParser().getActionKeyStroke().getKeyCode() && keys.get(1).getKeyChar() == '(' && ((KeyStroke)CollectionsKt.last(keys)).getKeyChar() == ')') {
            StringBuilder stringBuilder;
            StringBuilder $this$getActionNameFromActionMapping_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = keys.size() - 1;
            for (int i = 2; i < n; ++i) {
                $this$getActionNameFromActionMapping_u24lambda_u242.append(keys.get(i).getKeyChar());
            }
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    @Deprecated(message="Use getAll to return a sequence that does not allocate a list of for all entries and a list for the keystrokes of each entry", replaceWith=@ReplaceWith(expression="getAll()", imports={}))
    @NotNull
    public Iterator<List<KeyStroke>> iterator() {
        return SequencesKt.map((Sequence)KeyStrokeTrie.getEntries$default(this.keysTrie, null, 1, null), KeyMapping::iterator$lambda$3).iterator();
    }

    @NotNull
    public final Sequence<KeyMappingEntry> getAll(@NotNull List<? extends KeyStroke> prefix) {
        Intrinsics.checkNotNullParameter(prefix, (String)"prefix");
        return SequencesKt.map(this.keysTrie.getEntries(prefix), KeyMapping::getAll$lambda$4);
    }

    @NotNull
    public final Sequence<KeyMappingEntry> getAllByOwner(@NotNull MappingOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)KeyStrokeTrie.getEntries$default(this.keysTrie, null, 1, null), arg_0 -> KeyMapping.getAllByOwner$lambda$5(owner, arg_0)), KeyMapping::getAllByOwner$lambda$6);
    }

    public final void put(@NotNull List<? extends KeyStroke> fromKeys, @NotNull MappingOwner owner, @NotNull Set<? extends MappingMode> originalModes, @NotNull ExtensionHandler extensionHandler, boolean recursive) {
        Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(originalModes, (String)"originalModes");
        Intrinsics.checkNotNullParameter((Object)extensionHandler, (String)"extensionHandler");
        this.add(fromKeys, new ToHandlerMappingInfo(extensionHandler, fromKeys, recursive, owner, originalModes));
    }

    public final void put(@NotNull List<? extends KeyStroke> fromKeys, @NotNull List<? extends KeyStroke> toKeys, @NotNull MappingOwner owner, @NotNull Set<? extends MappingMode> originalModes, boolean recursive) {
        Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter(toKeys, (String)"toKeys");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(originalModes, (String)"originalModes");
        this.add(fromKeys, new ToKeysMappingInfo(toKeys, fromKeys, recursive, owner, originalModes));
    }

    public final void put(@NotNull List<? extends KeyStroke> fromKeys, @NotNull Expression toExpression, @NotNull MappingOwner owner, @NotNull Set<? extends MappingMode> originalModes, @NotNull String originalString, boolean recursive) {
        Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter((Object)toExpression, (String)"toExpression");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(originalModes, (String)"originalModes");
        Intrinsics.checkNotNullParameter((Object)originalString, (String)"originalString");
        this.add(fromKeys, new ToExpressionMappingInfo(toExpression, fromKeys, recursive, owner, originalModes, originalString));
    }

    private final void add(List<? extends KeyStroke> keys, MappingInfo mappingInfo) {
        this.keysTrie.add(keys, mappingInfo);
    }

    public final void removeKeyMapping(@NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.keysTrie.remove(keys);
    }

    public final void removeKeyMappingsByOwner(@NotNull MappingOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        List toRemove = SequencesKt.toList(this.getAllByOwner(owner));
        List keys = new ArrayList();
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyMappingEntry it = (KeyMappingEntry)element$iv;
            boolean bl = false;
            this.keysTrie.remove(it.collectPath(keys));
        }
    }

    public final void clear() {
        this.keysTrie.clear();
    }

    @Override
    public boolean isPrefix(@NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        if (keys.isEmpty()) {
            return false;
        }
        if (this.keysTrie.isPrefix(keys)) {
            return true;
        }
        return !(((KeyStroke)CollectionsKt.first(keys)).getKeyCode() != VimInjectorKt.getInjector().getParser().getActionKeyStroke().getKeyCode() || keys.size() >= 2 && keys.get(1).getKeyChar() != '(' || keys.size() >= 3 && Character.isWhitespace(keys.get(2).getKeyChar()) || ((KeyStroke)CollectionsKt.last(keys)).getKeyChar() == ')');
    }

    public final boolean hasmapto(@NotNull List<? extends KeyStroke> toKeys) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(toKeys, (String)"toKeys");
            Sequence $this$any$iv = KeyStrokeTrie.getEntries$default(this.keysTrie, null, 1, null);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KeyStrokeTrie.TrieNode it = (KeyStrokeTrie.TrieNode)element$iv;
                boolean bl2 = false;
                Object t = it.getData();
                ToKeysMappingInfo toKeysMappingInfo = t instanceof ToKeysMappingInfo ? (ToKeysMappingInfo)t : null;
                if (!Intrinsics.areEqual(toKeysMappingInfo != null ? toKeysMappingInfo.getToKeys() : null, toKeys)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Deprecated(message="Use different approach")
    @TestOnly
    @NotNull
    public final List<Pair<List<KeyStroke>, MappingInfo>> getMapTo(@NotNull List<? extends KeyStroke> toKeys) {
        Intrinsics.checkNotNullParameter(toKeys, (String)"toKeys");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)KeyStrokeTrie.getEntries$default(this.keysTrie, null, 1, null), arg_0 -> KeyMapping.getMapTo$lambda$9(toKeys, arg_0)), KeyMapping::getMapTo$lambda$10));
    }

    private static final List iterator$lambda$3(KeyStrokeTrie.TrieNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new KeyMappingEntry(it).getPath();
    }

    private static final KeyMappingEntry getAll$lambda$4(KeyStrokeTrie.TrieNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new KeyMappingEntry(it);
    }

    private static final boolean getAllByOwner$lambda$5(MappingOwner $owner, KeyStrokeTrie.TrieNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MappingInfo mappingInfo = (MappingInfo)it.getData();
        return Intrinsics.areEqual((Object)(mappingInfo != null ? mappingInfo.getOwner() : null), (Object)$owner);
    }

    private static final KeyMappingEntry getAllByOwner$lambda$6(KeyStrokeTrie.TrieNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new KeyMappingEntry(it);
    }

    private static final boolean getMapTo$lambda$9(List $toKeys, KeyStrokeTrie.TrieNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getData() == null) {
            return false;
        }
        MappingInfo mappingInfo = (MappingInfo)node.getData();
        new KeyMappingEntry(node).getPath();
        return mappingInfo instanceof ToKeysMappingInfo && Intrinsics.areEqual(((ToKeysMappingInfo)mappingInfo).getToKeys(), (Object)$toKeys);
    }

    private static final Pair getMapTo$lambda$10(KeyStrokeTrie.TrieNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<KeyStroke> list = new KeyMappingEntry(it).getPath();
        Object t = it.getData();
        Intrinsics.checkNotNull(t);
        return TuplesKt.to(list, t);
    }
}

