/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.key.MappingInfo;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cBA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/maddyhome/idea/vim/key/ToKeysMappingInfo;", "Lcom/maddyhome/idea/vim/key/MappingInfo;", "toKeys", "", "Ljavax/swing/KeyStroke;", "fromKeys", "isRecursive", "", "owner", "Lcom/maddyhome/idea/vim/key/MappingOwner;", "originalModes", "", "Lcom/maddyhome/idea/vim/command/MappingMode;", "<init>", "(Ljava/util/List;Ljava/util/List;ZLcom/maddyhome/idea/vim/key/MappingOwner;Ljava/util/Set;)V", "getToKeys", "()Ljava/util/List;", "getPresentableString", "", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "toString", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMappingInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingInfo.kt\ncom/maddyhome/idea/vim/key/ToKeysMappingInfo\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,282:1\n27#2,4:283\n38#2:287\n*S KotlinDebug\n*F\n+ 1 MappingInfo.kt\ncom/maddyhome/idea/vim/key/ToKeysMappingInfo\n*L\n98#1:283,4\n118#1:287\n*E\n"})
public final class ToKeysMappingInfo
extends MappingInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<KeyStroke> toKeys;
    @NotNull
    private static final VimLogger LOG;

    public ToKeysMappingInfo(@NotNull List<? extends KeyStroke> toKeys, @NotNull List<? extends KeyStroke> fromKeys, boolean isRecursive, @NotNull MappingOwner owner, @NotNull Set<? extends MappingMode> originalModes) {
        Intrinsics.checkNotNullParameter(toKeys, (String)"toKeys");
        Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(originalModes, (String)"originalModes");
        super(fromKeys, isRecursive, owner, originalModes, null);
        this.toKeys = toKeys;
    }

    @NotNull
    public final List<KeyStroke> getToKeys() {
        return this.toKeys;
    }

    @Override
    @NotNull
    public String getPresentableString() {
        return VimInjectorKt.getInjector().getParser().toKeyNotation(this.toKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull KeyHandlerState keyState) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
        LOG.debug("Executing 'ToKeys' mapping info...");
        boolean lhsIsPrefixOfRhs = KeyHandler.Companion.isPrefix$vim_engine(this.getFromKeys(), this.toKeys);
        KeyHandler keyHandler = KeyHandler.Companion.getInstance();
        VimLogger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Adding new keys to keyStack as toKeys of mapping. State before adding keys: " + keyHandler.getKeyStack().dump());
        }
        keyHandler.getKeyStack().addKeys(this.toKeys);
        try {
            boolean first = true;
            while (keyHandler.getKeyStack().hasStroke()) {
                KeyStroke keyStroke = keyHandler.getKeyStack().feedStroke();
                boolean allowKeyMappings = this.isRecursive() && (!first || !lhsIsPrefixOfRhs);
                keyHandler.handleKey(editor, keyStroke, context, allowKeyMappings, keyState);
                first = false;
            }
        }
        finally {
            keyHandler.getKeyStack().removeFirst();
        }
    }

    @NotNull
    public String toString() {
        return "Mapping[" + this.getFromKeys() + " -> " + this.toKeys + "]";
    }

    static {
        boolean $i$f$vimLogger = false;
        LOG = VimInjectorKt.getInjector().getLogger(ToKeysMappingInfo.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/key/ToKeysMappingInfo$Companion;", "", "<init>", "()V", "LOG", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

