/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.mode.Mode;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/DeleteCommandConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "<init>", "()V", "consumeKey", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "isDeleteCommandCountKey", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nDeleteCommandConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteCommandConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/DeleteCommandConsumer\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,57:1\n27#2,4:58\n38#2:62\n*S KotlinDebug\n*F\n+ 1 DeleteCommandConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/DeleteCommandConsumer\n*L\n32#1:58,4\n23#1:62\n*E\n"})
public final class DeleteCommandConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Entered DeleteCommandConsumer");
        }
        if (!this.isDeleteCommandCountKey(key, keyProcessResultBuilder.getState(), editor.getMode())) {
            return false;
        }
        keyProcessResultBuilder.getState().getCommandBuilder().deleteCountCharacter();
        return true;
    }

    private final boolean isDeleteCommandCountKey(KeyStroke key, KeyHandlerState keyState, Mode mode) {
        if (key.getKeyCode() != 127) {
            logger.debug("Not a delete key");
            return false;
        }
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        if ((mode instanceof Mode.NORMAL || mode instanceof Mode.VISUAL || mode instanceof Mode.OP_PENDING) && commandBuilder.isExpectingCount() && commandBuilder.hasCountCharacters()) {
            logger.debug("Deleting a count character");
            return true;
        }
        logger.debug("Not a delete key");
        return false;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(DeleteCommandConsumer.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/DeleteCommandConsumer$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

