/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.options.helpers;

import com.maddyhome.idea.vim.api.Options;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.options.OptionAccessScope;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0007J\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0005J \u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00122\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/maddyhome/idea/vim/options/helpers/KeywordOptionHelper;", "", "<init>", "()V", "allLettersRegex", "", "validationPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isValueInvalid", "", "value", "isKeyword", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "c", "", "toRegex", "", "parseValues", "content", "valuesToValidatedAndReversedSpecs", "Lcom/maddyhome/idea/vim/options/helpers/KeywordOptionHelper$KeywordSpec;", "values", "KeywordSpec", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nKeywordOptionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeywordOptionHelper.kt\ncom/maddyhome/idea/vim/options/helpers/KeywordOptionHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1563#2:199\n1634#2,3:200\n*S KotlinDebug\n*F\n+ 1 KeywordOptionHelper.kt\ncom/maddyhome/idea/vim/options/helpers/KeywordOptionHelper\n*L\n56#1:199\n56#1:200,3\n*E\n"})
public final class KeywordOptionHelper {
    @NotNull
    public static final KeywordOptionHelper INSTANCE = new KeywordOptionHelper();
    @NotNull
    private static final String allLettersRegex = "\\p{L}";
    private static final Pattern validationPattern = Pattern.compile("(\\^?(([^0-9^]|[0-9]{1,3})-([^0-9]|[0-9]{1,3})|([^0-9^]|[0-9]{1,3})),)*\\^?(([^0-9^]|[0-9]{1,3})-([^0-9]|[0-9]{1,3})|([^0-9]|[0-9]{1,3})),?$");

    private KeywordOptionHelper() {
    }

    public final boolean isValueInvalid(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        List<String> values = this.parseValues(value);
        List<KeywordSpec> specs = this.valuesToValidatedAndReversedSpecs(values);
        return values == null || specs == null;
    }

    public final boolean isKeyword(@NotNull VimEditor editor, char c) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (c >= '\u0100') {
            return true;
        }
        List specs = (List)VimInjectorKt.getInjector().getOptionGroup().getParsedEffectiveOptionValue(Options.INSTANCE.getIskeyword(), editor, KeywordOptionHelper::isKeyword$lambda$0);
        for (KeywordSpec spec : specs) {
            if (!spec.contains(c)) continue;
            return !spec.negate();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Only maintained for compatibility. Does not handle local-to-buffer iskeyword option")
    @NotNull
    public final List<String> toRegex() {
        void $this$mapTo$iv$iv;
        String isKeyword = ((VimString)VimInjectorKt.getInjector().getOptionGroup().getOptionValue(Options.INSTANCE.getIskeyword(), new OptionAccessScope.GLOBAL(VimInjectorKt.getInjector().getFallbackWindow()))).getValue();
        List list = this.valuesToValidatedAndReversedSpecs(this.parseValues(isKeyword));
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List specs = list;
        Iterable $this$map$iv = specs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void it;
            KeywordSpec keywordSpec = (KeywordSpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            it.initializeValues();
            if (it.isAllLetters()) {
                object = allLettersRegex;
            } else if (it.isRange()) {
                Integer n = it.getRangeLow();
                Intrinsics.checkNotNull((Object)n);
                char c = (char)n.intValue();
                Integer n2 = it.getRangeHigh();
                Intrinsics.checkNotNull((Object)n2);
                object = "[" + c + "-" + (char)n2.intValue() + "]";
            } else {
                Integer n = it.getRangeLow();
                Intrinsics.checkNotNull((Object)n);
                object = String.valueOf((char)n.intValue());
            }
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final List<String> parseValues(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (!validationPattern.matcher(content).matches()) {
            return null;
        }
        int index = 0;
        boolean firstCharNumOfPart = true;
        boolean inRange = false;
        List vals = new ArrayList();
        StringBuilder option = new StringBuilder();
        while (index <= content.length()) {
            char curChar = '\u0000';
            if (index < content.length()) {
                curChar = content.charAt(index);
            }
            if (curChar == ',' && !firstCharNumOfPart && !inRange || ++index == content.length() + 1) {
                String part;
                Intrinsics.checkNotNullExpressionValue((Object)option.toString(), (String)"toString(...)");
                vals.add(part);
                option = new StringBuilder();
                inRange = false;
                firstCharNumOfPart = true;
                continue;
            }
            option.append(curChar);
            if (curChar == '^' && option.length() == 1) {
                firstCharNumOfPart = true;
                continue;
            }
            if (curChar == '-' && !firstCharNumOfPart) {
                inRange = true;
                continue;
            }
            firstCharNumOfPart = false;
            inRange = false;
        }
        return vals;
    }

    private final List<KeywordSpec> valuesToValidatedAndReversedSpecs(List<String> values) {
        List specs = new ArrayList();
        if (values != null) {
            for (String value : values) {
                KeywordSpec spec = new KeywordSpec(value);
                if (!spec.isValid()) {
                    return null;
                }
                specs.add(spec);
            }
            CollectionsKt.reverse((List)specs);
        }
        return specs;
    }

    private static final List isKeyword$lambda$0(VimString optionValue) {
        Intrinsics.checkNotNullParameter((Object)optionValue, (String)"optionValue");
        List<KeywordSpec> list = INSTANCE.valuesToValidatedAndReversedSpecs(INSTANCE.parseValues(optionValue.asString()));
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0013\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\u0006\u0010\u0006\u001a\u00020\u0007J\u0011\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u000fH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b \u0010\t\u00a8\u0006#"}, d2={"Lcom/maddyhome/idea/vim/options/helpers/KeywordOptionHelper$KeywordSpec;", "", "part", "", "<init>", "(Ljava/lang/String;)V", "negate", "", "isRange", "()Z", "setRange", "(Z)V", "isAllLetters", "setAllLetters", "rangeLow", "", "getRangeLow", "()Ljava/lang/Integer;", "setRangeLow", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "rangeHigh", "getRangeHigh", "setRangeHigh", "initialized", "initializeValues", "", "toUnicode", "str", "equals", "other", "hashCode", "isValid", "contains", "code", "vim-engine"})
    @SourceDebugExtension(value={"SMAP\nKeywordOptionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeywordOptionHelper.kt\ncom/maddyhome/idea/vim/options/helpers/KeywordOptionHelper$KeywordSpec\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,198:1\n37#2:199\n36#2,3:200\n*S KotlinDebug\n*F\n+ 1 KeywordOptionHelper.kt\ncom/maddyhome/idea/vim/options/helpers/KeywordOptionHelper$KeywordSpec\n*L\n142#1:199\n142#1:200,3\n*E\n"})
    private static final class KeywordSpec {
        @NotNull
        private final String part;
        private boolean negate;
        private boolean isRange;
        private boolean isAllLetters;
        @Nullable
        private Integer rangeLow;
        @Nullable
        private Integer rangeHigh;
        private boolean initialized;

        public KeywordSpec(@NotNull String part) {
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            this.part = part;
        }

        public final boolean isRange() {
            return this.isRange;
        }

        public final void setRange(boolean bl) {
            this.isRange = bl;
        }

        public final boolean isAllLetters() {
            return this.isAllLetters;
        }

        public final void setAllLetters(boolean bl) {
            this.isAllLetters = bl;
        }

        @Nullable
        public final Integer getRangeLow() {
            return this.rangeLow;
        }

        public final void setRangeLow(@Nullable Integer n) {
            this.rangeLow = n;
        }

        @Nullable
        public final Integer getRangeHigh() {
            return this.rangeHigh;
        }

        public final void setRangeHigh(@Nullable Integer n) {
            this.rangeHigh = n;
        }

        public final void initializeValues() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            String part = this.part;
            CharSequence charSequence = part;
            this.negate = new Regex("^\\^.+").matches(charSequence);
            if (this.negate) {
                String string = part.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                part = string;
            }
            CharSequence charSequence2 = part;
            Regex regex = new Regex("(?<=.)-(?=.+)");
            int n = 0;
            Collection $this$toTypedArray$iv = regex.split(charSequence2, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] keywords = thisCollection$iv.toArray(new String[0]);
            if (keywords.length > 1 || Intrinsics.areEqual((Object)keywords[0], (Object)"@")) {
                this.isRange = true;
                if (keywords.length > 1) {
                    this.rangeLow = this.toUnicode(keywords[0]);
                    this.rangeHigh = this.toUnicode(keywords[1]);
                } else {
                    this.isAllLetters = true;
                }
            } else {
                int keyword = this.toUnicode(keywords[0]);
                this.rangeLow = keyword;
                this.rangeHigh = keyword;
            }
        }

        private final int toUnicode(String str) {
            Integer n = StringsKt.toIntOrNull((String)str);
            return n != null ? n : (int)str.charAt(0);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            KeywordSpec that = (KeywordSpec)other;
            return Intrinsics.areEqual((Object)this.part, (Object)that.part);
        }

        public int hashCode() {
            return this.part.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isValid() {
            this.initializeValues();
            if (!this.isRange) return true;
            if (this.isAllLetters) return true;
            Integer n = this.rangeLow;
            Intrinsics.checkNotNull((Object)n);
            int n2 = n;
            Integer n3 = this.rangeHigh;
            Intrinsics.checkNotNull((Object)n3);
            if (n2 > n3) return false;
            return true;
        }

        public final boolean negate() {
            this.initializeValues();
            return this.negate;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean contains(int code) {
            this.initializeValues();
            if (this.isAllLetters) {
                return Character.isLetter(code);
            }
            if (this.isRange) {
                Integer n = this.rangeLow;
                Intrinsics.checkNotNull((Object)n);
                if (code < n) return false;
                Integer n2 = this.rangeHigh;
                Intrinsics.checkNotNull((Object)n2);
                if (code > n2) return false;
                return true;
            }
            Integer n = this.rangeLow;
            if (n == null) return false;
            if (code != n) return false;
            return true;
        }
    }
}

