/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.regexp;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.LineDeleteShift;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimCaretListener;
import com.maddyhome.idea.vim.api.VimDocument;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimEditorBase;
import com.maddyhome.idea.vim.api.VimFoldRegion;
import com.maddyhome.idea.vim.api.VimIndentConfig;
import com.maddyhome.idea.vim.api.VimScrollingModel;
import com.maddyhome.idea.vim.api.VimSelectionModel;
import com.maddyhome.idea.vim.api.VimVirtualFile;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.common.LiveRange;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.common.VimEditorReplaceMask;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.regexp.VimRegexErrors;
import com.maddyhome.idea.vim.regexp.VimRegexException;
import com.maddyhome.idea.vim.regexp.VimRegexOptions;
import com.maddyhome.idea.vim.regexp.engine.VimRegexEngine;
import com.maddyhome.idea.vim.regexp.engine.nfa.NFA;
import com.maddyhome.idea.vim.regexp.engine.nfa.matcher.DotMatcher;
import com.maddyhome.idea.vim.regexp.match.VimMatchGroup;
import com.maddyhome.idea.vim.regexp.match.VimMatchResult;
import com.maddyhome.idea.vim.regexp.parser.CaseSensitivitySettings;
import com.maddyhome.idea.vim.regexp.parser.VimRegexParser;
import com.maddyhome.idea.vim.regexp.parser.VimRegexParserResult;
import com.maddyhome.idea.vim.regexp.parser.visitors.PatternVisitor;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001:\u00029:B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J%\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00032\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J/\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0019J(\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J/\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u001bJ0\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\u00182\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J8\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J?\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\"J0\u0010#\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00182\b\b\u0002\u0010$\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J7\u0010#\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00182\b\b\u0002\u0010$\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b%JX\u0010&\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u0003\u0018\u00010'2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00182\b\b\u0002\u0010$\u001a\u00020\u00182\b\b\u0002\u0010*\u001a\u00020\f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J*\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020!2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\b\b\u0002\u0010-\u001a\u00020\fH\u0002J&\u0010.\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J-\u0010.\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b0J\u001e\u00101\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J%\u00101\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00032\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b2J\u001e\u00103\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u001e\u00103\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00032\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J&\u00104\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J-\u00104\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00182\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b5J(\u00106\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010/\u001a\u00020\u00182\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J(\u00107\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010/\u001a\u00020\u00182\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0016\u00108\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/maddyhome/idea/vim/regexp/VimRegex;", "", "pattern", "", "<init>", "(Ljava/lang/String;)V", "caseSensitivitySettings", "Lcom/maddyhome/idea/vim/regexp/parser/CaseSensitivitySettings;", "nfa", "Lcom/maddyhome/idea/vim/regexp/engine/nfa/NFA;", "nonExactNFA", "hasUpperCase", "", "containsMatchIn", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "options", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/regexp/VimRegexOptions;", "text", "containsMatchIn$vim_engine", "findNext", "Lcom/maddyhome/idea/vim/regexp/match/VimMatchResult;", "startIndex", "", "findNext$vim_engine", "findPrevious", "findPrevious$vim_engine", "findLastMatchInLine", "line", "maxIndex", "findAll", "", "Lcom/maddyhome/idea/vim/regexp/match/VimMatchResult$Success;", "findAll$vim_engine", "findInLine", "column", "findInLine$vim_engine", "substitute", "Lkotlin/Pair;", "substituteString", "lastSubstituteString", "takeLiterally", "buildSubstituteString", "matchResult", "magic", "matchAt", "index", "matchAt$vim_engine", "matchEntire", "matchEntire$vim_engine", "matches", "matchesAt", "matchesAt$vim_engine", "simulateNFA", "simulateNonExactNFA", "shouldIgnoreCase", "SubstituteCase", "VimEditorWrapper", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimRegex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimRegex.kt\ncom/maddyhome/idea/vim/regexp/VimRegex\n+ 2 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,790:1\n19#2:791\n19#2:792\n19#2:793\n19#2:794\n19#2:795\n19#2:796\n19#2:797\n19#2:798\n19#2:799\n19#2:800\n19#2:801\n19#2:802\n19#2:803\n19#2:804\n19#2:805\n19#2:806\n19#2:807\n19#2:808\n19#2:809\n1179#3,2:810\n*S KotlinDebug\n*F\n+ 1 VimRegex.kt\ncom/maddyhome/idea/vim/regexp/VimRegex\n*L\n104#1:791\n119#1:792\n137#1:793\n180#1:794\n198#1:795\n219#1:796\n275#1:797\n309#1:798\n325#1:799\n334#1:800\n359#1:801\n454#1:802\n462#1:803\n476#1:804\n490#1:805\n504#1:806\n515#1:807\n531#1:808\n542#1:809\n393#1:810,2\n*E\n"})
public final class VimRegex {
    @NotNull
    private final CaseSensitivitySettings caseSensitivitySettings;
    @NotNull
    private final NFA nfa;
    @NotNull
    private final NFA nonExactNFA;
    private final boolean hasUpperCase;

    public VimRegex(@NotNull String pattern) {
        VimRegexParserResult parseResult;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        VimRegexParserResult vimRegexParserResult = parseResult = VimRegexParser.INSTANCE.parse(pattern);
        if (vimRegexParserResult instanceof VimRegexParserResult.Failure) {
            throw new VimRegexException(((VimRegexParserResult.Failure)parseResult).getErrorCode().toString());
        }
        if (!(vimRegexParserResult instanceof VimRegexParserResult.Success)) {
            throw new NoWhenBranchMatchedException();
        }
        Object object = PatternVisitor.INSTANCE.visit(((VimRegexParserResult.Success)parseResult).getTree());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"visit(...)");
        this.nfa = (NFA)object;
        this.hasUpperCase = PatternVisitor.INSTANCE.getHasUpperCase$vim_engine();
        this.nonExactNFA = NFA.Companion.fromMatcher$vim_engine(new DotMatcher(false)).closure$vim_engine(false).concatenate$vim_engine(this.nfa);
        this.caseSensitivitySettings = ((VimRegexParserResult.Success)parseResult).getCaseSensitivitySettings();
    }

    public final boolean containsMatchIn(@NotNull VimEditor editor, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int n = editor.lineCount();
        for (int line = 0; line < n; ++line) {
            VimMatchResult result = this.simulateNonExactNFA(editor, editor.getLineStartOffset(line), options);
            if (!(result instanceof VimMatchResult.Success)) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean containsMatchIn$default(VimRegex vimRegex, VimEditor vimEditor, EnumSet enumSet, int n, Object object) {
        if ((n & 2) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.containsMatchIn(vimEditor, enumSet);
    }

    public final boolean containsMatchIn$vim_engine(@NotNull String text, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.containsMatchIn(new VimEditorWrapper(text), options);
    }

    public static /* synthetic */ boolean containsMatchIn$vim_engine$default(VimRegex vimRegex, String string, EnumSet enumSet, int n, Object object) {
        if ((n & 2) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.containsMatchIn$vim_engine(string, enumSet);
    }

    @NotNull
    public final VimMatchResult findNext(@NotNull VimEditor editor, int startIndex, @NotNull EnumSet<VimRegexOptions> options) {
        int lineStartIndex;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int newStartIndex = startIndex + 1 == editor.getLineEndOffset(editor.offsetToBufferPosition(startIndex).getLine()) ? startIndex + 1 : startIndex;
        int index = lineStartIndex = editor.getLineStartOffset(editor.offsetToBufferPosition(newStartIndex).getLine());
        while (index <= editor.text().length()) {
            int n;
            VimMatchResult result = this.simulateNonExactNFA(editor, index, options);
            VimMatchResult vimMatchResult = result;
            if (vimMatchResult instanceof VimMatchResult.Success) {
                if (((VimMatchResult.Success)result).getRange().getStartOffset() > newStartIndex) {
                    return result;
                }
                if (((VimMatchResult.Success)result).getRange().getStartOffset() == startIndex && options.contains((Object)VimRegexOptions.CAN_MATCH_START_LOCATION)) {
                    return result;
                }
                n = ((VimMatchResult.Success)result).getRange().getEndOffset() + (((VimMatchResult.Success)result).getRange().getStartOffset() == ((VimMatchResult.Success)result).getRange().getEndOffset() ? 1 : 0);
            } else if (vimMatchResult instanceof VimMatchResult.Failure) {
                int nextLine = editor.offsetToBufferPosition(index).getLine() + 1;
                if (nextLine >= editor.lineCount()) break;
                n = editor.getLineStartOffset(nextLine);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            index = n;
        }
        return new VimMatchResult.Failure(VimRegexErrors.E486);
    }

    public static /* synthetic */ VimMatchResult findNext$default(VimRegex vimRegex, VimEditor vimEditor, int n, EnumSet enumSet, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.findNext(vimEditor, n, enumSet);
    }

    @NotNull
    public final VimMatchResult findNext$vim_engine(@NotNull String text, int startIndex, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.findNext(new VimEditorWrapper(text), startIndex, options);
    }

    public static /* synthetic */ VimMatchResult findNext$vim_engine$default(VimRegex vimRegex, String string, int n, EnumSet enumSet, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.findNext$vim_engine(string, n, enumSet);
    }

    @NotNull
    public final VimMatchResult findPrevious(@NotNull VimEditor editor, int startIndex, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int startLine = editor.offsetToBufferPosition(startIndex).getLine();
        VimMatchResult result = this.findLastMatchInLine(editor, startLine, startIndex - 1, options);
        if (result instanceof VimMatchResult.Success && ((VimMatchResult.Success)result).getRange().getStartOffset() < startIndex) {
            return result;
        }
        for (int currentLine = startLine - 1; -1 < currentLine; --currentLine) {
            VimMatchResult previous = VimRegex.findLastMatchInLine$default(this, editor, currentLine, 0, options, 4, null);
            if (!(previous instanceof VimMatchResult.Success)) continue;
            return previous;
        }
        return new VimMatchResult.Failure(VimRegexErrors.E486);
    }

    public static /* synthetic */ VimMatchResult findPrevious$default(VimRegex vimRegex, VimEditor vimEditor, int n, EnumSet enumSet, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.findPrevious(vimEditor, n, enumSet);
    }

    @NotNull
    public final VimMatchResult findPrevious$vim_engine(@NotNull String text, int startIndex, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.findPrevious(new VimEditorWrapper(text), startIndex, options);
    }

    public static /* synthetic */ VimMatchResult findPrevious$vim_engine$default(VimRegex vimRegex, String string, int n, EnumSet enumSet, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.findPrevious$vim_engine(string, n, enumSet);
    }

    private final VimMatchResult findLastMatchInLine(VimEditor editor, int line, int maxIndex, EnumSet<VimRegexOptions> options) {
        VimMatchResult result;
        VimMatchResult vimMatchResult;
        int index = editor.getLineStartOffset(line);
        VimMatchResult prevResult = new VimMatchResult.Failure(VimRegexErrors.E486);
        boolean returnEndPosition = options.contains((Object)VimRegexOptions.WANT_END_POSITION);
        while (index <= maxIndex && !((vimMatchResult = (result = this.simulateNonExactNFA(editor, index, options))) instanceof VimMatchResult.Failure)) {
            if (vimMatchResult instanceof VimMatchResult.Success) {
                if (!returnEndPosition && ((VimMatchResult.Success)result).getRange().getStartOffset() > maxIndex || returnEndPosition && ((VimMatchResult.Success)result).getRange().getEndOffset() > maxIndex) break;
                prevResult = result;
                index = ((VimMatchResult.Success)result).getRange().getStartOffset() == ((VimMatchResult.Success)result).getRange().getEndOffset() ? ((VimMatchResult.Success)result).getRange().getEndOffset() + 1 : ((VimMatchResult.Success)result).getRange().getEndOffset();
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return prevResult;
    }

    static /* synthetic */ VimMatchResult findLastMatchInLine$default(VimRegex vimRegex, VimEditor vimEditor, int n, int n2, EnumSet enumSet, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = vimEditor.getLineEndOffset(n);
        }
        return vimRegex.findLastMatchInLine(vimEditor, n, n2, enumSet);
    }

    @NotNull
    public final List<VimMatchResult.Success> findAll(@NotNull VimEditor editor, int startIndex, int maxIndex, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int index = startIndex;
        List foundMatches = CollectionsKt.toMutableList((Collection)CollectionsKt.emptyList());
        while (index < maxIndex) {
            VimMatchResult result = this.simulateNonExactNFA(editor, index, options);
            VimMatchResult vimMatchResult = result;
            if (vimMatchResult instanceof VimMatchResult.Success) {
                foundMatches.add(result);
                index = ((VimMatchResult.Success)result).getRange().getStartOffset() == ((VimMatchResult.Success)result).getRange().getEndOffset() ? ((VimMatchResult.Success)result).getRange().getEndOffset() + 1 : ((VimMatchResult.Success)result).getRange().getEndOffset();
                continue;
            }
            if (vimMatchResult instanceof VimMatchResult.Failure) {
                int nextLine = editor.offsetToBufferPosition(index).getLine() + 1;
                if (nextLine >= editor.lineCount()) break;
                index = editor.getLineStartOffset(nextLine);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return foundMatches;
    }

    public static /* synthetic */ List findAll$default(VimRegex vimRegex, VimEditor vimEditor, int n, int n2, EnumSet enumSet, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = vimEditor.text().length();
        }
        if ((n3 & 8) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.findAll(vimEditor, n, n2, enumSet);
    }

    @NotNull
    public final List<VimMatchResult.Success> findAll$vim_engine(@NotNull String text, int startIndex, int maxIndex, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.findAll(new VimEditorWrapper(text), startIndex, maxIndex, options);
    }

    public static /* synthetic */ List findAll$vim_engine$default(VimRegex vimRegex, String string, int n, int n2, EnumSet enumSet, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        if ((n3 & 8) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.findAll$vim_engine(string, n, n2, enumSet);
    }

    @NotNull
    public final VimMatchResult findInLine(@NotNull VimEditor editor, int line, int column, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.simulateNonExactNFA(editor, editor.getLineStartOffset(line) + column, options);
    }

    public static /* synthetic */ VimMatchResult findInLine$default(VimRegex vimRegex, VimEditor vimEditor, int n, int n2, EnumSet enumSet, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.findInLine(vimEditor, n, n2, enumSet);
    }

    @NotNull
    public final VimMatchResult findInLine$vim_engine(@NotNull String text, int line, int column, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.findInLine(new VimEditorWrapper(text), line, column, options);
    }

    public static /* synthetic */ VimMatchResult findInLine$vim_engine$default(VimRegex vimRegex, String string, int n, int n2, EnumSet enumSet, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.findInLine$vim_engine(string, n, n2, enumSet);
    }

    @Nullable
    public final Pair<VimMatchResult.Success, String> substitute(@NotNull VimEditor editor, @NotNull String substituteString, @NotNull String lastSubstituteString, int line, int column, boolean takeLiterally, @NotNull EnumSet<VimRegexOptions> options) {
        Pair pair;
        VimMatchResult match;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)substituteString, (String)"substituteString");
        Intrinsics.checkNotNullParameter((Object)lastSubstituteString, (String)"lastSubstituteString");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        VimMatchResult vimMatchResult = match = this.findInLine(editor, line, column, options);
        if (vimMatchResult instanceof VimMatchResult.Failure) {
            pair = null;
        } else if (vimMatchResult instanceof VimMatchResult.Success) {
            pair = new Pair((Object)match, (Object)(takeLiterally ? substituteString : VimRegex.buildSubstituteString$default(this, (VimMatchResult.Success)match, substituteString, lastSubstituteString, false, 8, null)));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    public static /* synthetic */ Pair substitute$default(VimRegex vimRegex, VimEditor vimEditor, String string, String string2, int n, int n2, boolean bl, EnumSet enumSet, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x20) != 0) {
            bl = false;
        }
        if ((n3 & 0x40) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.substitute(vimEditor, string, string2, n, n2, bl, enumSet);
    }

    private final String buildSubstituteString(VimMatchResult.Success matchResult, String substituteString, String lastSubstituteString, boolean magic) {
        StringBuilder result = new StringBuilder();
        Ref.ObjectRef caseSettings = new Ref.ObjectRef();
        caseSettings.element = SubstituteCase.DEFAULT;
        for (int index = 0; index < substituteString.length(); ++index) {
            if (substituteString.charAt(index) == '\\') {
                if (++index >= substituteString.length()) {
                    VimRegex.buildSubstituteString$append((Ref.ObjectRef<SubstituteCase>)caseSettings, result, '\\');
                    break;
                }
                char c = substituteString.charAt(index);
                if (c == '&') {
                    VimRegex.buildSubstituteString$append$1((Ref.ObjectRef<SubstituteCase>)caseSettings, result, magic ? "&" : matchResult.getValue());
                    continue;
                }
                if (c == '~') {
                    VimRegex.buildSubstituteString$append$1((Ref.ObjectRef<SubstituteCase>)caseSettings, result, magic ? "~" : this.buildSubstituteString(matchResult, lastSubstituteString, "", false));
                    continue;
                }
                if (c == '0') {
                    VimRegex.buildSubstituteString$append$1((Ref.ObjectRef<SubstituteCase>)caseSettings, result, matchResult.getValue());
                    continue;
                }
                boolean bl = '1' <= c ? c < ':' : false;
                if (bl) {
                    Object object = matchResult.getGroups().get(CharsKt.digitToInt((char)substituteString.charAt(index)));
                    if (object == null || (object = ((VimMatchGroup)object).getValue()) == null) {
                        object = "";
                    }
                    VimRegex.buildSubstituteString$append$1((Ref.ObjectRef<SubstituteCase>)caseSettings, result, (String)object);
                    continue;
                }
                if (c == 'r') {
                    VimRegex.buildSubstituteString$append((Ref.ObjectRef<SubstituteCase>)caseSettings, result, '\n');
                    continue;
                }
                if (c == 'n') {
                    VimRegex.buildSubstituteString$append((Ref.ObjectRef<SubstituteCase>)caseSettings, result, '\u0000');
                    continue;
                }
                if (c == 'b') {
                    VimRegex.buildSubstituteString$append((Ref.ObjectRef<SubstituteCase>)caseSettings, result, '\b');
                    continue;
                }
                if (c == 't') {
                    VimRegex.buildSubstituteString$append((Ref.ObjectRef<SubstituteCase>)caseSettings, result, '\t');
                    continue;
                }
                if (c == '\\') {
                    VimRegex.buildSubstituteString$append((Ref.ObjectRef<SubstituteCase>)caseSettings, result, '\\');
                    continue;
                }
                if (c == 'u') {
                    caseSettings.element = SubstituteCase.UPPER;
                    continue;
                }
                if (c == 'U') {
                    caseSettings.element = SubstituteCase.UPPER_PERSISTENT;
                    continue;
                }
                if (c == 'l') {
                    caseSettings.element = SubstituteCase.LOWER;
                    continue;
                }
                if (c == 'L') {
                    caseSettings.element = SubstituteCase.LOWER_PERSISTENT;
                    continue;
                }
                if (c == 'e') {
                    caseSettings.element = SubstituteCase.DEFAULT;
                    continue;
                }
                if (c == 'E') {
                    caseSettings.element = SubstituteCase.DEFAULT;
                    continue;
                }
                VimRegex.buildSubstituteString$append((Ref.ObjectRef<SubstituteCase>)caseSettings, result, substituteString.charAt(index));
                continue;
            }
            if (substituteString.charAt(index) == '&' && magic) {
                VimRegex.buildSubstituteString$append$1((Ref.ObjectRef<SubstituteCase>)caseSettings, result, matchResult.getValue());
                continue;
            }
            if (substituteString.charAt(index) == '~' && magic) {
                VimRegex.buildSubstituteString$append$1((Ref.ObjectRef<SubstituteCase>)caseSettings, result, this.buildSubstituteString(matchResult, lastSubstituteString, "", true));
                continue;
            }
            VimRegex.buildSubstituteString$append((Ref.ObjectRef<SubstituteCase>)caseSettings, result, substituteString.charAt(index));
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String buildSubstituteString$default(VimRegex vimRegex, VimMatchResult.Success success, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return vimRegex.buildSubstituteString(success, string, string2, bl);
    }

    @NotNull
    public final VimMatchResult matchAt(@NotNull VimEditor editor, int index, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.simulateNFA(editor, index, options);
    }

    public static /* synthetic */ VimMatchResult matchAt$default(VimRegex vimRegex, VimEditor vimEditor, int n, EnumSet enumSet, int n2, Object object) {
        if ((n2 & 4) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.matchAt(vimEditor, n, enumSet);
    }

    @NotNull
    public final VimMatchResult matchAt$vim_engine(@NotNull String text, int index, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.matchAt(new VimEditorWrapper(text), index, options);
    }

    public static /* synthetic */ VimMatchResult matchAt$vim_engine$default(VimRegex vimRegex, String string, int n, EnumSet enumSet, int n2, Object object) {
        if ((n2 & 4) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.matchAt$vim_engine(string, n, enumSet);
    }

    @NotNull
    public final VimMatchResult matchEntire(@NotNull VimEditor editor, @NotNull EnumSet<VimRegexOptions> options) {
        VimMatchResult vimMatchResult;
        VimMatchResult result;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        VimMatchResult vimMatchResult2 = result = VimRegex.simulateNFA$default(this, editor, 0, options, 2, null);
        if (vimMatchResult2 instanceof VimMatchResult.Failure) {
            vimMatchResult = result;
        } else if (vimMatchResult2 instanceof VimMatchResult.Success) {
            vimMatchResult = ((VimMatchResult.Success)result).getRange().getEndOffset() == editor.text().length() ? result : (VimMatchResult)new VimMatchResult.Failure(VimRegexErrors.E486);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return vimMatchResult;
    }

    public static /* synthetic */ VimMatchResult matchEntire$default(VimRegex vimRegex, VimEditor vimEditor, EnumSet enumSet, int n, Object object) {
        if ((n & 2) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.matchEntire(vimEditor, enumSet);
    }

    @NotNull
    public final VimMatchResult matchEntire$vim_engine(@NotNull String text, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.matchEntire(new VimEditorWrapper(text), options);
    }

    public static /* synthetic */ VimMatchResult matchEntire$vim_engine$default(VimRegex vimRegex, String string, EnumSet enumSet, int n, Object object) {
        if ((n & 2) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.matchEntire$vim_engine(string, enumSet);
    }

    public final boolean matches(@NotNull VimEditor editor, @NotNull EnumSet<VimRegexOptions> options) {
        boolean bl;
        VimMatchResult result;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        VimMatchResult vimMatchResult = result = VimRegex.simulateNFA$default(this, editor, 0, options, 2, null);
        if (vimMatchResult instanceof VimMatchResult.Failure) {
            bl = false;
        } else if (vimMatchResult instanceof VimMatchResult.Success) {
            bl = ((VimMatchResult.Success)result).getRange().getEndOffset() == editor.text().length();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static /* synthetic */ boolean matches$default(VimRegex vimRegex, VimEditor vimEditor, EnumSet enumSet, int n, Object object) {
        if ((n & 2) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.matches(vimEditor, enumSet);
    }

    public final boolean matches(@NotNull String text, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.matches(new VimEditorWrapper(text), options);
    }

    public static /* synthetic */ boolean matches$default(VimRegex vimRegex, String string, EnumSet enumSet, int n, Object object) {
        if ((n & 2) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.matches(string, enumSet);
    }

    public final boolean matchesAt(@NotNull VimEditor editor, int index, @NotNull EnumSet<VimRegexOptions> options) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        VimMatchResult vimMatchResult = this.simulateNFA(editor, index, options);
        if (vimMatchResult instanceof VimMatchResult.Success) {
            bl = true;
        } else if (vimMatchResult instanceof VimMatchResult.Failure) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static /* synthetic */ boolean matchesAt$default(VimRegex vimRegex, VimEditor vimEditor, int n, EnumSet enumSet, int n2, Object object) {
        if ((n2 & 4) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.matchesAt(vimEditor, n, enumSet);
    }

    public final boolean matchesAt$vim_engine(@NotNull String text, int index, @NotNull EnumSet<VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.matchesAt(new VimEditorWrapper(text), index, options);
    }

    public static /* synthetic */ boolean matchesAt$vim_engine$default(VimRegex vimRegex, String string, int n, EnumSet enumSet, int n2, Object object) {
        if ((n2 & 4) != 0) {
            boolean $i$f$noneOfEnum = false;
            EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        return vimRegex.matchesAt$vim_engine(string, n, enumSet);
    }

    private final VimMatchResult simulateNFA(VimEditor editor, int index, EnumSet<VimRegexOptions> options) {
        return VimRegexEngine.INSTANCE.simulate$vim_engine(this.nfa, editor, index, this.shouldIgnoreCase(options));
    }

    static /* synthetic */ VimMatchResult simulateNFA$default(VimRegex vimRegex, VimEditor vimEditor, int n, EnumSet enumSet, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return vimRegex.simulateNFA(vimEditor, n, enumSet);
    }

    private final VimMatchResult simulateNonExactNFA(VimEditor editor, int index, EnumSet<VimRegexOptions> options) {
        return VimRegexEngine.INSTANCE.simulate$vim_engine(this.nonExactNFA, editor, index, this.shouldIgnoreCase(options));
    }

    static /* synthetic */ VimMatchResult simulateNonExactNFA$default(VimRegex vimRegex, VimEditor vimEditor, int n, EnumSet enumSet, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return vimRegex.simulateNonExactNFA(vimEditor, n, enumSet);
    }

    private final boolean shouldIgnoreCase(EnumSet<VimRegexOptions> options) {
        return switch (WhenMappings.$EnumSwitchMapping$1[this.caseSensitivitySettings.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            case 3 -> {
                if (!(!options.contains((Object)VimRegexOptions.IGNORE_CASE) || options.contains((Object)VimRegexOptions.SMART_CASE) && this.hasUpperCase)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void buildSubstituteString$append(Ref.ObjectRef<SubstituteCase> caseSettings, StringBuilder result, char c) {
        Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[((SubstituteCase)((Object)caseSettings.element)).ordinal()]) {
            case 1 -> new Pair((Object)Character.valueOf(c), caseSettings.element);
            case 2 -> new Pair((Object)Character.valueOf(Character.toUpperCase(c)), (Object)SubstituteCase.DEFAULT);
            case 3 -> new Pair((Object)Character.valueOf(Character.toUpperCase(c)), caseSettings.element);
            case 4 -> new Pair((Object)Character.valueOf(Character.toLowerCase(c)), (Object)SubstituteCase.DEFAULT);
            case 5 -> new Pair((Object)Character.valueOf(Character.toLowerCase(c)), caseSettings.element);
            default -> throw new NoWhenBranchMatchedException();
        };
        char transformedChar = ((Character)pair.component1()).charValue();
        SubstituteCase newCaseSettings = (SubstituteCase)((Object)pair.component2());
        caseSettings.element = newCaseSettings;
        result.append(transformedChar);
    }

    private static final void buildSubstituteString$append$1(Ref.ObjectRef<SubstituteCase> caseSettings, StringBuilder result, String value) {
        CharSequence $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            VimRegex.buildSubstituteString$append(caseSettings, result, it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/regexp/VimRegex$SubstituteCase;", "", "<init>", "(Ljava/lang/String;I)V", "DEFAULT", "UPPER", "UPPER_PERSISTENT", "LOWER", "LOWER_PERSISTENT", "vim-engine"})
    private static final class SubstituteCase
    extends Enum<SubstituteCase> {
        public static final /* enum */ SubstituteCase DEFAULT = new SubstituteCase();
        public static final /* enum */ SubstituteCase UPPER = new SubstituteCase();
        public static final /* enum */ SubstituteCase UPPER_PERSISTENT = new SubstituteCase();
        public static final /* enum */ SubstituteCase LOWER = new SubstituteCase();
        public static final /* enum */ SubstituteCase LOWER_PERSISTENT = new SubstituteCase();
        private static final /* synthetic */ SubstituteCase[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SubstituteCase[] values() {
            return (SubstituteCase[])$VALUES.clone();
        }

        public static SubstituteCase valueOf(String value) {
            return Enum.valueOf(SubstituteCase.class, value);
        }

        @NotNull
        public static EnumEntries<SubstituteCase> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = substituteCaseArray = new SubstituteCase[]{SubstituteCase.DEFAULT, SubstituteCase.UPPER, SubstituteCase.UPPER_PERSISTENT, SubstituteCase.LOWER, SubstituteCase.LOWER_PERSISTENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010\u0002\u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0%2\u0006\u0010&\u001a\u00020#H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\u001c\u0010+\u001a\u00020\u00072\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00070-H\u0016J$\u0010.\u001a\u00020\u00072\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00070-2\u0006\u0010/\u001a\u00020\fH\u0016J\b\u00100\u001a\u00020\fH\u0016J\b\u00101\u001a\u00020)H\u0016J\b\u00102\u001a\u00020)H\u0016J\b\u00103\u001a\u00020\fH\u0016J\b\u00104\u001a\u00020\fH\u0016J\b\u00105\u001a\u00020\fH\u0016JF\u00106\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0%\u0012\u0004\u0012\u000207\u0018\u00010%2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0%2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u000207H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020#H\u0016J\u0010\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020=H\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010>\u001a\u00020#H\u0016J\u0010\u0010C\u001a\u00020#2\u0006\u0010@\u001a\u00020BH\u0016J\u0010\u0010D\u001a\u00020=2\u0006\u0010@\u001a\u00020BH\u0016J\u0010\u0010E\u001a\u00020B2\u0006\u0010@\u001a\u00020=H\u0016J\n\u0010F\u001a\u0004\u0018\u00010GH\u0016J\u0010\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\u00072\u0006\u0010P\u001a\u00020)H\u0016J\b\u0010Q\u001a\u00020\u0007H\u0016J\u0018\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020=2\u0006\u0010T\u001a\u00020=H\u0016J\u0010\u0010U\u001a\u00020#2\u0006\u0010&\u001a\u00020#H\u0016J\u0010\u0010V\u001a\u00020#2\u0006\u0010&\u001a\u00020#H\u0016J\u0010\u0010W\u001a\u00020\u00072\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020\u00072\u0006\u0010X\u001a\u00020YH\u0016J\b\u0010[\u001a\u00020\fH\u0016J\b\u0010\\\u001a\u00020\u0007H\u0016J\n\u0010]\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010^\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010b\u001a\u00020\u00072\u0006\u0010c\u001a\u00020dH\u0016J\u0010\u0010e\u001a\u00020\u00072\u0006\u0010f\u001a\u00020\fH\u0016J\b\u0010m\u001a\u00020\fH\u0016J\b\u0010n\u001a\u00020\u0007H\u0016J\b\u0010o\u001a\u00020\u0007H\u0016J\b\u0010p\u001a\u00020\fH\u0016J\u0010\u0010q\u001a\u00020#2\u0006\u0010&\u001a\u00020#H\u0016J\u0018\u0010r\u001a\u00020s2\u0006\u0010S\u001a\u00020#2\u0006\u0010T\u001a\u00020#H\u0016J\u0010\u0010|\u001a\u00020\u00032\u0006\u0010}\u001a\u00020#H\u0016J\u0012\u0010~\u001a\u0004\u0018\u00010\u007f2\u0006\u0010>\u001a\u00020#H\u0016J'\u0010\u0080\u0001\u001a\u0005\u0018\u0001H\u0081\u0001\"\n\b\u0000\u0010\u0081\u0001*\u00030\u0082\u00012\u0007\u0010P\u001a\u0003H\u0081\u0001H\u0016\u00a2\u0006\u0003\u0010\u0083\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010_\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010aR\u001c\u0010g\u001a\u0004\u0018\u00010hX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR\u001a\u0010t\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bu\u0010\u000f\"\u0004\bv\u0010wR\u0014\u0010x\u001a\u00020y8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bz\u0010{\u00a8\u0006\u0084\u0001"}, d2={"Lcom/maddyhome/idea/vim/regexp/VimRegex$VimEditorWrapper;", "Lcom/maddyhome/idea/vim/api/VimEditorBase;", "text", "", "<init>", "(Ljava/lang/String;)V", "updateMode", "", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "updateIsReplaceCharacter", "isReplaceCharacter", "", "lfMakesNewLine", "getLfMakesNewLine", "()Z", "vimChangeActionSwitchMode", "getVimChangeActionSwitchMode", "()Lcom/maddyhome/idea/vim/state/mode/Mode;", "setVimChangeActionSwitchMode", "(Lcom/maddyhome/idea/vim/state/mode/Mode;)V", "indentConfig", "Lcom/maddyhome/idea/vim/api/VimIndentConfig;", "getIndentConfig", "()Lcom/maddyhome/idea/vim/api/VimIndentConfig;", "replaceMask", "Lcom/maddyhome/idea/vim/common/VimEditorReplaceMask;", "getReplaceMask", "()Lcom/maddyhome/idea/vim/common/VimEditorReplaceMask;", "setReplaceMask", "(Lcom/maddyhome/idea/vim/common/VimEditorReplaceMask;)V", "fileSize", "", "", "nativeLineCount", "", "getLineRange", "Lkotlin/Pair;", "line", "carets", "", "Lcom/maddyhome/idea/vim/api/VimCaret;", "nativeCarets", "forEachCaret", "action", "Lkotlin/Function1;", "forEachNativeCaret", "reverse", "isInForEachCaretScope", "primaryCaret", "currentCaret", "isWritable", "isDocumentWritable", "isOneLineMode", "search", "Lcom/maddyhome/idea/vim/api/LineDeleteShift;", "pair", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "shiftType", "offsetToBufferPosition", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "offset", "bufferPositionToOffset", "position", "offsetToVisualPosition", "Lcom/maddyhome/idea/vim/api/VimVisualPosition;", "visualPositionToOffset", "visualPositionToBufferPosition", "bufferPositionToVisualPosition", "getVirtualFile", "Lcom/maddyhome/idea/vim/api/VimVirtualFile;", "deleteString", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "getSelectionModel", "Lcom/maddyhome/idea/vim/api/VimSelectionModel;", "getScrollingModel", "Lcom/maddyhome/idea/vim/api/VimScrollingModel;", "removeCaret", "caret", "removeSecondaryCarets", "vimSetSystemBlockSelectionSilently", "start", "end", "getLineStartOffset", "getLineEndOffset", "addCaretListener", "listener", "Lcom/maddyhome/idea/vim/api/VimCaretListener;", "removeCaretListener", "isDisposed", "removeSelection", "getPath", "extractProtocol", "projectId", "getProjectId", "()Ljava/lang/String;", "exitInsertMode", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "exitSelectModeNative", "adjustCaret", "vimLastSelectionType", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "getVimLastSelectionType", "()Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "setVimLastSelectionType", "(Lcom/maddyhome/idea/vim/state/mode/SelectionType;)V", "isTemplateActive", "startGuardedBlockChecking", "stopGuardedBlockChecking", "hasUnsavedChanges", "getLastVisualLineColumnNumber", "createLiveMarker", "Lcom/maddyhome/idea/vim/common/LiveRange;", "insertMode", "getInsertMode", "setInsertMode", "(Z)V", "document", "Lcom/maddyhome/idea/vim/api/VimDocument;", "getDocument", "()Lcom/maddyhome/idea/vim/api/VimDocument;", "createIndentBySize", "size", "getFoldRegionAtOffset", "Lcom/maddyhome/idea/vim/api/VimFoldRegion;", "findLastVersionOfCaret", "T", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "(Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;)Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "vim-engine"})
    @SourceDebugExtension(value={"SMAP\nVimRegex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimRegex.kt\ncom/maddyhome/idea/vim/regexp/VimRegex$VimEditorWrapper\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,790:1\n1104#2,3:791\n*S KotlinDebug\n*F\n+ 1 VimRegex.kt\ncom/maddyhome/idea/vim/regexp/VimRegex$VimEditorWrapper\n*L\n613#1:791,3\n*E\n"})
    private static final class VimEditorWrapper
    extends VimEditorBase {
        @NotNull
        private final String text;
        private final boolean lfMakesNewLine;
        @Nullable
        private Mode vimChangeActionSwitchMode;
        @Nullable
        private VimEditorReplaceMask replaceMask;
        @NotNull
        private final String projectId;
        @Nullable
        private SelectionType vimLastSelectionType;
        private boolean insertMode;

        public VimEditorWrapper(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
            this.lfMakesNewLine = true;
            this.projectId = "no project, I am just a piece of text wrapped into an Enditor for Regexp to work";
        }

        @Override
        protected void updateMode(@NotNull Mode mode) {
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        protected void updateIsReplaceCharacter(boolean isReplaceCharacter) {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public boolean getLfMakesNewLine() {
            return this.lfMakesNewLine;
        }

        @Override
        @Nullable
        public Mode getVimChangeActionSwitchMode() {
            return this.vimChangeActionSwitchMode;
        }

        @Override
        public void setVimChangeActionSwitchMode(@Nullable Mode mode) {
            this.vimChangeActionSwitchMode = mode;
        }

        @Override
        @NotNull
        public VimIndentConfig getIndentConfig() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @Nullable
        public VimEditorReplaceMask getReplaceMask() {
            return this.replaceMask;
        }

        @Override
        public void setReplaceMask(@Nullable VimEditorReplaceMask vimEditorReplaceMask) {
            this.replaceMask = vimEditorReplaceMask;
        }

        @Override
        public long fileSize() {
            return this.text.length();
        }

        @Override
        @NotNull
        public CharSequence text() {
            return this.text;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int nativeLineCount() {
            void var3_3;
            CharSequence $this$count$iv = this.text;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            return (int)(var3_3 + true);
        }

        @Override
        @NotNull
        public Pair<Integer, Integer> getLineRange(int line) {
            return TuplesKt.to((Object)this.getLineStartOffset(line), (Object)this.getLineEndOffset(line));
        }

        @Override
        @NotNull
        public List<VimCaret> carets() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public List<VimCaret> nativeCarets() {
            return CollectionsKt.emptyList();
        }

        @Override
        public void forEachCaret(@NotNull Function1<? super VimCaret, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
        }

        @Override
        public void forEachNativeCaret(@NotNull Function1<? super VimCaret, Unit> action, boolean reverse) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
        }

        @Override
        public boolean isInForEachCaretScope() {
            return false;
        }

        @Override
        @NotNull
        public VimCaret primaryCaret() {
            throw new ExException("No caret present");
        }

        @Override
        @NotNull
        public VimCaret currentCaret() {
            throw new ExException("No caret present");
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isDocumentWritable() {
            return false;
        }

        @Override
        public boolean isOneLineMode() {
            return false;
        }

        @Override
        @Nullable
        public Pair<Pair<Integer, Integer>, LineDeleteShift> search(@NotNull Pair<Integer, Integer> pair, @NotNull VimEditor editor, @NotNull LineDeleteShift shiftType) {
            Intrinsics.checkNotNullParameter(pair, (String)"pair");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)((Object)shiftType), (String)"shiftType");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public BufferPosition offsetToBufferPosition(int offset) {
            if (offset < 0 || offset > this.text.length()) {
                return new BufferPosition(-1, -1, false, 4, null);
            }
            int line = 0;
            int lastLineStart = 0;
            for (int i = 0; i < offset; ++i) {
                if (this.text.charAt(i) != '\n') continue;
                ++line;
                lastLineStart = i + 1;
            }
            int column = offset - lastLineStart;
            return new BufferPosition(line, column, false, 4, null);
        }

        @Override
        public int bufferPositionToOffset(@NotNull BufferPosition position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            List lines = StringsKt.lines((CharSequence)this.text);
            int offset = 0;
            int n = position.getLine();
            for (int i = 0; i < n; ++i) {
                offset += ((String)lines.get(i)).length() + 1;
            }
            return offset += position.getColumn();
        }

        @Override
        @NotNull
        public VimVisualPosition offsetToVisualPosition(int offset) {
            return this.bufferPositionToVisualPosition(this.offsetToBufferPosition(offset));
        }

        @Override
        public int visualPositionToOffset(@NotNull VimVisualPosition position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return this.bufferPositionToOffset(this.visualPositionToBufferPosition(position));
        }

        @Override
        @NotNull
        public BufferPosition visualPositionToBufferPosition(@NotNull VimVisualPosition position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return new BufferPosition(position.getLine(), position.getColumn(), position.getLeansRight());
        }

        @Override
        @NotNull
        public VimVisualPosition bufferPositionToVisualPosition(@NotNull BufferPosition position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return new VimVisualPosition(position.getLine(), position.getColumn(), position.getLeansForward());
        }

        @Override
        @Nullable
        public VimVirtualFile getVirtualFile() {
            return null;
        }

        @Override
        public void deleteString(@NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        }

        @Override
        @NotNull
        public VimSelectionModel getSelectionModel() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public VimScrollingModel getScrollingModel() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void removeCaret(@NotNull VimCaret caret) {
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        }

        @Override
        public void removeSecondaryCarets() {
        }

        @Override
        public void vimSetSystemBlockSelectionSilently(@NotNull BufferPosition start, @NotNull BufferPosition end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        }

        @Override
        public int getLineStartOffset(int line) {
            if (line < 0) {
                return -1;
            }
            int currentLine = 0;
            int n = ((CharSequence)this.text).length();
            for (int index = 0; index < n; ++index) {
                if (currentLine == line) {
                    return index;
                }
                if (this.text.charAt(index) != '\n') continue;
                ++currentLine;
            }
            return line == 0 ? 0 : -1;
        }

        @Override
        public int getLineEndOffset(int line) {
            if (line < 0) {
                return -1;
            }
            int currentLine = 0;
            int n = ((CharSequence)this.text).length();
            for (int index = 0; index < n; ++index) {
                if (this.text.charAt(index) != '\n') continue;
                if (currentLine == line) {
                    return index - 1;
                }
                ++currentLine;
            }
            return line == currentLine ? this.text.length() - 1 : -1;
        }

        @Override
        public void addCaretListener(@NotNull VimCaretListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        }

        @Override
        public void removeCaretListener(@NotNull VimCaretListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        }

        @Override
        public boolean isDisposed() {
            return false;
        }

        @Override
        public void removeSelection() {
        }

        @Override
        @Nullable
        public String getPath() {
            return null;
        }

        @Override
        @Nullable
        public String extractProtocol() {
            return null;
        }

        @Override
        @NotNull
        public String getProjectId() {
            return this.projectId;
        }

        @Override
        public void exitInsertMode(@NotNull ExecutionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        }

        @Override
        public void exitSelectModeNative(boolean adjustCaret) {
        }

        @Override
        @Nullable
        public SelectionType getVimLastSelectionType() {
            return this.vimLastSelectionType;
        }

        @Override
        public void setVimLastSelectionType(@Nullable SelectionType selectionType) {
            this.vimLastSelectionType = selectionType;
        }

        @Override
        public boolean isTemplateActive() {
            return false;
        }

        @Override
        public void startGuardedBlockChecking() {
        }

        @Override
        public void stopGuardedBlockChecking() {
        }

        @Override
        public boolean hasUnsavedChanges() {
            return false;
        }

        @Override
        public int getLastVisualLineColumnNumber(int line) {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public LiveRange createLiveMarker(int start, int end) {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public boolean getInsertMode() {
            return this.insertMode;
        }

        @Override
        public void setInsertMode(boolean bl) {
            this.insertMode = bl;
        }

        @Override
        @NotNull
        public VimDocument getDocument() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public String createIndentBySize(int size) {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @Nullable
        public VimFoldRegion getFoldRegionAtOffset(int offset) {
            return null;
        }

        @Override
        @Nullable
        public <T extends ImmutableVimCaret> T findLastVersionOfCaret(@NotNull T caret) {
            Intrinsics.checkNotNullParameter(caret, (String)"caret");
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SubstituteCase.values().length];
            try {
                nArray[SubstituteCase.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubstituteCase.UPPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubstituteCase.UPPER_PERSISTENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubstituteCase.LOWER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubstituteCase.LOWER_PERSISTENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CaseSensitivitySettings.values().length];
            try {
                nArray[CaseSensitivitySettings.NO_IGNORE_CASE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaseSensitivitySettings.IGNORE_CASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaseSensitivitySettings.DEFAULT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

