/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimMessages;
import com.maddyhome.idea.vim.api.VimRangeMarker;
import com.maddyhome.idea.vim.api.VimSearchGroup;
import com.maddyhome.idea.vim.api.VimSearchGroupBase;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.regexp.VimRegex;
import com.maddyhome.idea.vim.regexp.VimRegexException;
import com.maddyhome.idea.vim.regexp.VimRegexOptions;
import com.maddyhome.idea.vim.regexp.match.VimMatchResult;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import com.maddyhome.idea.vim.vimscript.model.commands.PrintCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 :2\u00020\u0001:\u0001:B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0007H\u0002J\u0014\u0010#\u001a\u00020$*\u00020%2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JD\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020$0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0)2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002J*\u0010.\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020$2\b\u0010,\u001a\u0004\u0018\u00010\u0007H\u0002J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0005H\u00c6\u0003J\t\u00102\u001a\u00020\u0007H\u00c6\u0003J\t\u00103\u001a\u00020\tH\u00c6\u0003J1\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u00105\u001a\u00020\t2\b\u00106\u001a\u0004\u0018\u000107H\u00d6\u0003J\t\u00108\u001a\u00020$H\u00d6\u0001J\t\u00109\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006;"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/GlobalCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "modifier", "Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "argument", "", "invert", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;Ljava/lang/String;Z)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getModifier", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "getArgument", "()Ljava/lang/String;", "getInvert", "()Z", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "processGlobalCommand", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "getOriginalCommandString", "getLine", "", "Lcom/maddyhome/idea/vim/regexp/match/VimMatchResult$Success;", "globalExe", "", "lines", "", "marks", "Lcom/maddyhome/idea/vim/api/VimRangeMarker;", "cmd", "originalCommandString", "globalExecuteOne", "lineStartOffset", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "toString", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nGlobalCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/GlobalCommand\n+ 2 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n57#2,2:232\n19#2:234\n59#2,2:235\n61#2:241\n37#3:237\n36#3,3:238\n1563#4:242\n1634#4,3:243\n1563#4:246\n1634#4,3:247\n*S KotlinDebug\n*F\n+ 1 GlobalCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/GlobalCommand\n*L\n82#1:232,2\n82#1:234\n82#1:235,2\n82#1:241\n82#1:237\n82#1:238,3\n108#1:242\n108#1:243,3\n114#1:246\n114#1:247,3\n*E\n"})
public final class GlobalCommand
extends Command.SingleExecution {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range range;
    @NotNull
    private final CommandModifier modifier;
    @NotNull
    private final String argument;
    private final boolean invert;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;
    private static boolean globalBusy;
    private static boolean gotInt;

    public GlobalCommand(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument, boolean invert) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, modifier, argument);
        this.range = range;
        this.modifier = modifier;
        this.argument = argument;
        this.invert = invert;
        this.setDefaultRange("%");
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.SELF_SYNCHRONIZED, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final CommandModifier getModifier() {
        return this.modifier;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    public final boolean getInvert() {
        return this.invert;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        ExecutionResult result = ExecutionResult.Success.INSTANCE;
        editor.removeSecondaryCarets();
        VimCaret caret = editor.currentCaret();
        LineRange lineRange = this.getLineRange(editor, caret);
        if (!this.processGlobalCommand(editor, context, lineRange)) {
            result = ExecutionResult.Error.INSTANCE;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean processGlobalCommand(VimEditor editor, ExecutionContext context, LineRange range) {
        Object[] objectArray;
        EnumSet<Object> enumSet;
        void value$iv;
        VimRegex vimRegex;
        VimMessages messages = VimInjectorKt.getInjector().getMessages();
        if (globalBusy && (range.startLine != 0 || range.endLine != editor.lineCount() - 1)) {
            messages.showStatusBarMessage(null, messages.message("E147", new Object[0]));
            messages.indicateError();
            return false;
        }
        VimSearchGroup vimSearchGroup = VimInjectorKt.getInjector().getSearchGroup();
        Intrinsics.checkNotNull((Object)vimSearchGroup, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.VimSearchGroupBase");
        VimSearchGroupBase search = (VimSearchGroupBase)vimSearchGroup;
        VimSearchGroupBase.GlobalCommandArguments globalCommandArguments = search.parseGlobalCommand(this.argument);
        if (globalCommandArguments == null) {
            return false;
        }
        VimSearchGroupBase.GlobalCommandArguments globalCommandArguments2 = globalCommandArguments;
        try {
            vimRegex = search.prepareRegex(globalCommandArguments2.getPattern(), globalCommandArguments2.getWhichPattern(), 2);
        }
        catch (VimRegexException e) {
            messages.showStatusBarMessage(editor, e.getMessage());
            return false;
        }
        VimRegex regex = vimRegex;
        Enum[] e = new VimRegexOptions[0];
        boolean $i$f$enumSetOf = false;
        switch (((void)value$iv).length) {
            case 0: {
                boolean $i$f$noneOfEnum = false;
                EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
                enumSet = enumSet2;
                Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
                break;
            }
            case 1: {
                EnumSet<void> enumSet3 = EnumSet.of(value$iv[0]);
                enumSet = enumSet3;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
                break;
            }
            default: {
                Collection $this$toTypedArray$iv$iv = ArraysKt.slice((Object[])value$iv, (IntRange)new IntRange(1, ArraysKt.getLastIndex((Object[])value$iv)));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                objectArray = thisCollection$iv$iv.toArray(new VimRegexOptions[0]);
                EnumSet<Enum[]> enumSet4 = EnumSet.of(value$iv[0], Arrays.copyOf(objectArray, objectArray.length));
                enumSet = enumSet4;
                Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
            }
        }
        EnumSet<Object> options = enumSet;
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSmartcase()) {
            options.add((Object)VimRegexOptions.SMART_CASE);
        }
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getIgnorecase()) {
            options.add((Object)VimRegexOptions.IGNORE_CASE);
        }
        if (globalBusy) {
            VimMatchResult match = regex.findInLine(editor, editor.currentCaret().getLine(), 0, options);
            if (match instanceof VimMatchResult.Success == !this.invert) {
                this.globalExecuteOne(editor, context, editor.getLineStartOffset(editor.currentCaret().getLine()), globalCommandArguments2.getCommand());
            }
        } else {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            int line1 = range.startLine;
            int line2 = range.endLine;
            if (line1 < 0 || line2 < 0) {
                return false;
            }
            List<VimMatchResult.Success> matches = regex.findAll(editor, editor.getLineStartOffset(line1), editor.getLineEndOffset(line2), options);
            Iterable $this$map$iv = matches;
            boolean $i$f$map = false;
            objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                VimMatchResult.Success success = (VimMatchResult.Success)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.getLine((VimMatchResult.Success)it, editor));
            }
            Set matchesLines = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            List linesForGlobalCommand = this.invert ? CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)SetsKt.minus((Set)CollectionsKt.toSet((Iterable)((Iterable)new IntRange(line1, line2))), (Iterable)matchesLines))) : CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)matchesLines));
            Iterable $this$map$iv2 = linesForGlobalCommand;
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(VimInjectorKt.getInjector().getEngineEditorHelper().createRangeMarker(editor, editor.getLineStartOffset((int)it), editor.getLineStartOffset((int)it)));
            }
            List marks = (List)destination$iv$iv2;
            if (gotInt) {
                messages.showStatusBarMessage(null, messages.message("e_interr", new Object[0]));
            } else if (marks.isEmpty()) {
                if (this.invert) {
                    objectArray = new Object[]{globalCommandArguments2.getPattern().toString()};
                    messages.showStatusBarMessage(null, messages.message("global.command.not.found.v", objectArray));
                } else {
                    objectArray = new Object[]{globalCommandArguments2.getPattern().toString()};
                    messages.showStatusBarMessage(null, messages.message("global.command.not.found.g", objectArray));
                }
            } else {
                this.globalExe(editor, context, linesForGlobalCommand, marks, globalCommandArguments2.getCommand(), this.getOriginalCommandString());
            }
        }
        VimInjectorKt.getInjector().getSearchGroup().updateSearchHighlightsAfterGlobalCommand();
        return true;
    }

    private final String getOriginalCommandString() {
        return (this.invert ? "v" : "g") + this.argument;
    }

    private final int getLine(VimMatchResult.Success $this$getLine, VimEditor editor) {
        return editor.offsetToBufferPosition($this$getLine.getRange().getStartOffset()).getLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void globalExe(VimEditor editor, ExecutionContext context, List<Integer> lines, List<? extends VimRangeMarker> marks, String cmd, String originalCommandString) {
        block8: {
            globalBusy = true;
            try {
                if (((CharSequence)cmd).length() == 0 || cmd.length() == 1 && cmd.charAt(0) == '\n') {
                    VimInjectorKt.getInjector().getOutputPanel().output(editor, context, originalCommandString + "\n" + PrintCommand.Companion.getText(editor, lines));
                    break block8;
                }
                for (VimRangeMarker vimRangeMarker : marks) {
                    if (!gotInt && globalBusy) {
                        int startOffset = vimRangeMarker.getStartOffset();
                        boolean isValid = vimRangeMarker.isValid();
                        vimRangeMarker.dispose();
                        if (!isValid) continue;
                        editor.currentCaret().moveToOffset(startOffset);
                        VimInjectorKt.getInjector().getVimscriptExecutor().execute(cmd, editor, context, true, true, this.getVimContext());
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                globalBusy = false;
            }
        }
    }

    private final void globalExecuteOne(VimEditor editor, ExecutionContext context, int lineStartOffset, String cmd) {
        editor.currentCaret().moveToOffset(lineStartOffset);
        CharSequence charSequence = cmd;
        ExecutionResult executionResult = charSequence == null || charSequence.length() == 0 || cmd.length() == 1 && cmd.charAt(0) == '\n' ? VimInjectorKt.getInjector().getVimscriptExecutor().execute("p", editor, context, true, true, this.getVimContext()) : VimInjectorKt.getInjector().getVimscriptExecutor().execute(cmd, editor, context, true, true, this.getVimContext());
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final CommandModifier component2() {
        return this.modifier;
    }

    @NotNull
    public final String component3() {
        return this.argument;
    }

    public final boolean component4() {
        return this.invert;
    }

    @NotNull
    public final GlobalCommand copy(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument, boolean invert) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new GlobalCommand(range, modifier, argument, invert);
    }

    public static /* synthetic */ GlobalCommand copy$default(GlobalCommand globalCommand, Range range, CommandModifier commandModifier, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            range = globalCommand.range;
        }
        if ((n & 2) != 0) {
            commandModifier = globalCommand.modifier;
        }
        if ((n & 4) != 0) {
            string = globalCommand.argument;
        }
        if ((n & 8) != 0) {
            bl = globalCommand.invert;
        }
        return globalCommand.copy(range, commandModifier, string, bl);
    }

    @NotNull
    public String toString() {
        return "GlobalCommand(range=" + this.range + ", modifier=" + this.modifier + ", argument=" + this.argument + ", invert=" + this.invert + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.modifier.hashCode();
        result = result * 31 + this.argument.hashCode();
        result = result * 31 + Boolean.hashCode(this.invert);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlobalCommand)) {
            return false;
        }
        GlobalCommand globalCommand = (GlobalCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)globalCommand.range)) {
            return false;
        }
        if (this.modifier != globalCommand.modifier) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.argument, (Object)globalCommand.argument)) {
            return false;
        }
        return this.invert == globalCommand.invert;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/GlobalCommand$Companion;", "", "<init>", "()V", "globalBusy", "", "gotInt", "getGotInt", "()Z", "setGotInt", "(Z)V", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getGotInt() {
            return gotInt;
        }

        public final void setGotInt(boolean bl) {
            gotInt = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

