/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/GoToLineCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ForEachCaret;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "vim-engine"})
public final class GoToLineCommand
extends Command.ForEachCaret {
    @NotNull
    private final Range range;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public GoToLineCommand(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(range, CommandModifier.NONE, null, 4, null);
        this.range = range;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_REQUIRED, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int line1 = Integer.min(this.getLineRange(editor, caret).getEndLine1(), editor.lineCount());
        if (line1 >= 0) {
            int offset = VimInjectorKt.getInjector().getMotion().moveCaretToLineWithStartOfLineOption(editor, RangesKt.coerceAtLeast((int)(line1 - 1), (int)0), caret);
            caret.moveToOffset(offset);
            return ExecutionResult.Success.INSTANCE;
        }
        caret.moveToOffset(0);
        return ExecutionResult.Error.INSTANCE;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final GoToLineCommand copy(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new GoToLineCommand(range);
    }

    public static /* synthetic */ GoToLineCommand copy$default(GoToLineCommand goToLineCommand, Range range, int n, Object object) {
        if ((n & 1) != 0) {
            range = goToLineCommand.range;
        }
        return goToLineCommand.copy(range);
    }

    @NotNull
    public String toString() {
        return "GoToLineCommand(range=" + this.range + ")";
    }

    public int hashCode() {
        return this.range.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GoToLineCommand)) {
            return false;
        }
        GoToLineCommand goToLineCommand = (GoToLineCommand)other;
        return Intrinsics.areEqual((Object)this.range, (Object)goToLineCommand.range);
    }
}

