/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.options.OptionAccessScope;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.Script;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimBlob;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDictionary;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFuncref;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.EnvVariableExpression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.OneElementSublistExpression;
import com.maddyhome.idea.vim.vimscript.model.expressions.OptionExpression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Register;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.expressions.SublistExpression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Variable;
import com.maddyhome.idea.vim.vimscript.model.expressions.operators.AssignmentOperator;
import com.maddyhome.idea.vim.vimscript.model.functions.DefinedFunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionDeclaration;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionFlag;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 42\u00020\u0001:\u00014B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010&\u001a\u00020\nH\u0002J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0007H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\nH\u00c6\u0003J;\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010-\u001a\u00020\n2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\t\u00102\u001a\u000203H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00065"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/LetCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "variable", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "operator", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/AssignmentOperator;", "expression", "isSyntaxSupported", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/AssignmentOperator;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Z)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getVariable", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "getOperator", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/AssignmentOperator;", "getExpression", "()Z", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "isInsideFunction", "vimLContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "isReadOnlyVariable", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Variable;", "isInsideDictionaryFunction", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nLetCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LetCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/LetCommand\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,294:1\n38#2:295\n*S KotlinDebug\n*F\n+ 1 LetCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/LetCommand\n*L\n56#1:295\n*E\n"})
public final class LetCommand
extends Command.SingleExecution {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Range range;
    @NotNull
    private final Expression variable;
    @NotNull
    private final AssignmentOperator operator;
    @NotNull
    private final Expression expression;
    private final boolean isSyntaxSupported;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;
    @NotNull
    private static final VimLogger logger;

    public LetCommand(@NotNull Range range, @NotNull Expression variable, @NotNull AssignmentOperator operator, @NotNull Expression expression, boolean isSyntaxSupported) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super(range, CommandModifier.NONE, null, 4, null);
        this.range = range;
        this.variable = variable;
        this.operator = operator;
        this.expression = expression;
        this.isSyntaxSupported = isSyntaxSupported;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_FORBIDDEN, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final Expression getVariable() {
        return this.variable;
    }

    @NotNull
    public final AssignmentOperator getOperator() {
        return this.operator;
    }

    @NotNull
    public final Expression getExpression() {
        return this.expression;
    }

    public final boolean isSyntaxSupported() {
        return this.isSyntaxSupported;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) throws ExException {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        if (!this.isSyntaxSupported) {
            return ExecutionResult.Error.INSTANCE;
        }
        Expression expression = this.variable;
        if (expression instanceof Variable) {
            VimDataType leftValue;
            if (((Variable)this.variable).getScope() == Scope.SCRIPT_VARIABLE && !(this.getVimContext().getFirstParentContext() instanceof Script) || !this.isInsideFunction(this.getVimContext()) && (((Variable)this.variable).getScope() == Scope.FUNCTION_VARIABLE || ((Variable)this.variable).getScope() == Scope.LOCAL_VARIABLE)) {
                throw new ExException("E461: Illegal variable name: " + ((Variable)this.variable).toString(editor, context, this.getVimContext()));
            }
            if (this.isReadOnlyVariable((Variable)this.variable, editor, context)) {
                throw new ExException("E46: Cannot change read-only variable \"" + ((Variable)this.variable).toString(editor, context, this.getVimContext()) + "\"");
            }
            VimDataType vimDataType = leftValue = VimInjectorKt.getInjector().getVariableService().getNullableVariableValue((Variable)this.variable, editor, context, this.getVimContext());
            boolean bl = vimDataType != null ? vimDataType.isLocked() : false;
            if (bl) {
                Object object = leftValue.getLockOwner();
                Variable variable = object instanceof Variable ? (Variable)object : null;
                if (Intrinsics.areEqual((Object)(variable != null ? variable.getName() : null), (Object)((Variable)this.variable).getName())) {
                    throw new ExException("E741: Value is locked: " + ((Variable)this.variable).toString(editor, context, this.getVimContext()));
                }
            }
            VimDataType rightValue = this.expression.evaluate(editor, context, this.getVimContext());
            VimInjectorKt.getInjector().getVariableService().storeVariable((Variable)this.variable, this.operator.getNewValue(leftValue, rightValue), editor, context, this);
            return ExecutionResult.Success.INSTANCE;
        }
        if (expression instanceof OneElementSublistExpression) {
            VimDataType containerValue = ((OneElementSublistExpression)this.variable).getExpression().evaluate(editor, context, this.getVimContext());
            if (containerValue instanceof VimDictionary) {
                VimDataType valueToStore;
                VimString dictKey = new VimString(((OneElementSublistExpression)this.variable).getIndex().evaluate(editor, context, this).asString());
                if (this.operator != AssignmentOperator.ASSIGNMENT && !((VimDictionary)containerValue).getDictionary().containsKey(dictKey)) {
                    throw new ExException("E716: Key not present in Dictionary: " + dictKey);
                }
                VimDataType expressionValue = this.expression.evaluate(editor, context, this);
                if (((Map)((VimDictionary)containerValue).getDictionary()).containsKey(dictKey)) {
                    VimDataType vimDataType = ((VimDictionary)containerValue).getDictionary().get(dictKey);
                    Intrinsics.checkNotNull((Object)vimDataType);
                    if (vimDataType.isLocked()) {
                        throw new ExException("E741: Value is locked: " + this.variable.getOriginalString());
                    }
                    VimDataType vimDataType2 = ((VimDictionary)containerValue).getDictionary().get(dictKey);
                    Intrinsics.checkNotNull((Object)vimDataType2);
                    v5 = this.operator.getNewValue(vimDataType2, expressionValue);
                } else {
                    if (containerValue.isLocked()) {
                        throw new ExException("E741: Value is locked: " + this.variable.getOriginalString());
                    }
                    v5 = valueToStore = expressionValue;
                }
                if (valueToStore instanceof VimFuncref && !((VimFuncref)valueToStore).isSelfFixed() && ((VimFuncref)valueToStore).getHandler() instanceof DefinedFunctionHandler && ((DefinedFunctionHandler)((VimFuncref)valueToStore).getHandler()).getFunction().getFlags().contains((Object)FunctionFlag.DICT)) {
                    valueToStore = VimFuncref.copy$default((VimFuncref)valueToStore, null, null, null, null, 15, null);
                    ((VimFuncref)valueToStore).setDictionary((VimDictionary)containerValue);
                }
                ((Map)((VimDictionary)containerValue).getDictionary()).put(dictKey, valueToStore);
                return ExecutionResult.Success.INSTANCE;
            }
            if (containerValue instanceof VimList) {
                int index = Integer.parseInt(((OneElementSublistExpression)this.variable).getIndex().evaluate(editor, context, this).asString());
                if (index > ((VimList)containerValue).getValues().size() - 1) {
                    throw new ExException("E684: list index out of range: " + index);
                }
                if (((VimList)containerValue).getValues().get(index).isLocked()) {
                    throw new ExException("E741: Value is locked: " + this.variable.getOriginalString());
                }
                ((VimList)containerValue).getValues().set(index, this.operator.getNewValue(((VimList)containerValue).getValues().get(index), this.expression.evaluate(editor, context, this.getVimContext())));
                return ExecutionResult.Success.INSTANCE;
            }
            if (!(containerValue instanceof VimBlob)) throw new ExException("E689: Can only index a List, Dictionary or Blob");
            throw new NotImplementedError(null, 1, null);
        }
        if (expression instanceof SublistExpression) {
            if (!(((SublistExpression)this.variable).getExpression() instanceof Variable)) return ExecutionResult.Success.INSTANCE;
            VimDataType variableValue = VimInjectorKt.getInjector().getVariableService().getNonNullVariableValue((Variable)((SublistExpression)this.variable).getExpression(), editor, context, this);
            if (!(variableValue instanceof VimList)) throw new ExException("wrong variable type");
            Object object = ((SublistExpression)this.variable).getFrom();
            if (object == null || (object = ((Expression)object).evaluate(editor, context, this)) == null || (object = ((VimDataType)object).toString()) == null) {
                object = "0";
            }
            int from = Integer.parseInt((String)object);
            Object object2 = ((SublistExpression)this.variable).getTo();
            if (object2 == null || (object2 = ((Expression)object2).evaluate(editor, context, this)) == null || (object2 = ((VimDataType)object2).toString()) == null) {
                object2 = String.valueOf(((VimList)variableValue).getValues().size() - 1);
            }
            int to = Integer.parseInt((String)object2);
            VimDataType expressionValue = this.expression.evaluate(editor, context, this);
            if (!(expressionValue instanceof VimList) && !(expressionValue instanceof VimBlob)) {
                throw new ExException("E709: [:] requires a List or Blob value");
            }
            if (expressionValue instanceof VimList) {
                if (((VimList)expressionValue).getValues().size() < to - from + 1) {
                    throw new ExException("E711: List value does not have enough items");
                }
                if (((SublistExpression)this.variable).getTo() != null && ((VimList)expressionValue).getValues().size() > to - from + 1) {
                    throw new ExException("E710: List value has more items than targets");
                }
                int newListSize = ((VimList)expressionValue).getValues().size() - (to - from + 1) + ((VimList)variableValue).getValues().size();
                if (newListSize > ((VimList)variableValue).getValues().size()) {
                    for (i = from; i < ((VimList)variableValue).getValues().size(); ++i) {
                        ((VimList)variableValue).getValues().set(i, ((VimList)expressionValue).getValues().get(i - from));
                    }
                    while (i < newListSize) {
                        ((VimList)variableValue).getValues().add(((VimList)expressionValue).getValues().get(i - from));
                        ++i;
                    }
                    return ExecutionResult.Success.INSTANCE;
                } else {
                    while (i <= to) {
                        ((VimList)variableValue).getValues().set(i, ((VimList)expressionValue).getValues().get(i - from));
                        ++i;
                    }
                }
                return ExecutionResult.Success.INSTANCE;
            }
            if (!(expressionValue instanceof VimBlob)) return ExecutionResult.Success.INSTANCE;
            throw new NotImplementedError(null, 1, null);
        }
        if (expression instanceof OptionExpression) {
            VimDataType optionValue = ((OptionExpression)this.variable).evaluate(editor, context, this.getVimContext());
            if (this.operator != AssignmentOperator.ASSIGNMENT && this.operator != AssignmentOperator.CONCATENATION && this.operator != AssignmentOperator.ADDITION && this.operator != AssignmentOperator.SUBTRACTION) throw new NotImplementedError(null, 1, null);
            Option<VimDataType> option = VimInjectorKt.getInjector().getOptionGroup().getOption(((OptionExpression)this.variable).getOptionName());
            if (option == null) {
                Object[] objectArray = new Object[]{this.variable.getOriginalString()};
                throw ExExceptionsKt.exExceptionMessage("E518", objectArray);
            }
            Option<VimDataType> option2 = option;
            VimDataType newValue = this.operator.getNewValue(optionValue, this.expression.evaluate(editor, context, this));
            Scope scope = ((OptionExpression)this.variable).getScope();
            switch (scope == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scope.ordinal()]) {
                case 1: {
                    VimInjectorKt.getInjector().getOptionGroup().setOptionValue(option2, new OptionAccessScope.GLOBAL(editor), newValue);
                    return ExecutionResult.Success.INSTANCE;
                }
                case 2: {
                    VimInjectorKt.getInjector().getOptionGroup().setOptionValue(option2, new OptionAccessScope.LOCAL(editor), newValue);
                    return ExecutionResult.Success.INSTANCE;
                }
                case -1: {
                    VimInjectorKt.getInjector().getOptionGroup().setOptionValue(option2, new OptionAccessScope.EFFECTIVE(editor), newValue);
                    return ExecutionResult.Success.INSTANCE;
                }
                default: {
                    throw new ExException("Invalid option scope");
                }
            }
        }
        if (expression instanceof EnvVariableExpression) {
            throw new NotImplementedError(null, 1, null);
        }
        if (!(expression instanceof Register)) throw new ExException("E121: Undefined variable");
        if (StringsKt.contains$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+*-_\"/", (char)((Register)this.variable).getChar(), (boolean)false, (int)2, null)) {
            boolean result = VimInjectorKt.getInjector().getRegisterGroup().storeText(editor, context, ((Register)this.variable).getChar(), this.expression.evaluate(editor, context, this.getVimContext()).asString());
            if (result) return ExecutionResult.Success.INSTANCE;
            logger.error(StringsKt.trimIndent((String)("\n              Error during `let " + this.variable.getOriginalString() + " " + this.operator.getValue() + " " + this.expression.getOriginalString() + "` command execution.\n              Could not set register value\n              ")));
            return ExecutionResult.Success.INSTANCE;
        } else {
            if (!StringsKt.contains$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+*-_\"/%:.#=", (char)((Register)this.variable).getChar(), (boolean)false, (int)2, null)) throw new ExException("E18: Unexpected characters in :let");
            throw new ExException("E354: Invalid register name: '" + ((Register)this.variable).getChar() + "'");
        }
    }

    private final boolean isInsideFunction(VimLContext vimLContext) {
        boolean isInsideFunction = false;
        VimLContext node = vimLContext;
        while (!node.isFirstParentContext()) {
            if (node instanceof FunctionDeclaration) {
                isInsideFunction = true;
            }
            node = node.getPreviousParentContext();
        }
        return isInsideFunction;
    }

    private final boolean isReadOnlyVariable(Variable variable, VimEditor editor, ExecutionContext context) {
        if (variable.getScope() == Scope.FUNCTION_VARIABLE) {
            return true;
        }
        return variable.getScope() == null && Intrinsics.areEqual((Object)variable.getName().evaluate(editor, context, this.getVimContext()).getValue(), (Object)"self") && this.isInsideDictionaryFunction();
    }

    private final boolean isInsideDictionaryFunction() {
        VimLContext node = this;
        while (!node.isFirstParentContext()) {
            if (node instanceof FunctionDeclaration && ((FunctionDeclaration)node).getFlags().contains((Object)FunctionFlag.DICT)) {
                return true;
            }
            node = node.getPreviousParentContext();
        }
        return false;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final Expression component2() {
        return this.variable;
    }

    @NotNull
    public final AssignmentOperator component3() {
        return this.operator;
    }

    @NotNull
    public final Expression component4() {
        return this.expression;
    }

    public final boolean component5() {
        return this.isSyntaxSupported;
    }

    @NotNull
    public final LetCommand copy(@NotNull Range range, @NotNull Expression variable, @NotNull AssignmentOperator operator, @NotNull Expression expression, boolean isSyntaxSupported) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return new LetCommand(range, variable, operator, expression, isSyntaxSupported);
    }

    public static /* synthetic */ LetCommand copy$default(LetCommand letCommand, Range range, Expression expression, AssignmentOperator assignmentOperator, Expression expression2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            range = letCommand.range;
        }
        if ((n & 2) != 0) {
            expression = letCommand.variable;
        }
        if ((n & 4) != 0) {
            assignmentOperator = letCommand.operator;
        }
        if ((n & 8) != 0) {
            expression2 = letCommand.expression;
        }
        if ((n & 0x10) != 0) {
            bl = letCommand.isSyntaxSupported;
        }
        return letCommand.copy(range, expression, assignmentOperator, expression2, bl);
    }

    @NotNull
    public String toString() {
        return "LetCommand(range=" + this.range + ", variable=" + this.variable + ", operator=" + this.operator + ", expression=" + this.expression + ", isSyntaxSupported=" + this.isSyntaxSupported + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.variable.hashCode();
        result = result * 31 + this.operator.hashCode();
        result = result * 31 + this.expression.hashCode();
        result = result * 31 + Boolean.hashCode(this.isSyntaxSupported);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LetCommand)) {
            return false;
        }
        LetCommand letCommand = (LetCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)letCommand.range)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variable, (Object)letCommand.variable)) {
            return false;
        }
        if (this.operator != letCommand.operator) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.expression, (Object)letCommand.expression)) {
            return false;
        }
        return this.isSyntaxSupported == letCommand.isSyntaxSupported;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(LetCommand.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/LetCommand$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scope.values().length];
            try {
                nArray[Scope.GLOBAL_VARIABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.LOCAL_VARIABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

