/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.expressions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.vimscript.model.Executable;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.commands.LetCommand;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFuncref;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.expressions.Variable;
import com.maddyhome.idea.vim.vimscript.model.expressions.operators.AssignmentOperator;
import com.maddyhome.idea.vim.vimscript.model.functions.DefinedFunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionDeclaration;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionFlag;
import com.maddyhome.idea.vim.vimscript.model.statements.ReturnStatement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0003H\u0002J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0001H\u00c6\u0003J#\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/expressions/LambdaExpression;", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "args", "", "", "expr", "<init>", "(Ljava/util/List;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;)V", "getArgs", "()Ljava/util/List;", "getExpr", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "evaluate", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimFuncref;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "getFunctionName", "buildBody", "Lcom/maddyhome/idea/vim/vimscript/model/Executable;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "vim-engine"})
public final class LambdaExpression
extends Expression {
    @NotNull
    private final List<String> args;
    @NotNull
    private final Expression expr;

    public LambdaExpression(@NotNull List<String> args, @NotNull Expression expr) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        this.args = args;
        this.expr = expr;
    }

    @NotNull
    public final List<String> getArgs() {
        return this.args;
    }

    @NotNull
    public final Expression getExpr() {
        return this.expr;
    }

    @Override
    @NotNull
    public VimFuncref evaluate(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        FunctionDeclaration function = new FunctionDeclaration(null, this.getFunctionName(), this.args, CollectionsKt.emptyList(), this.buildBody(), false, SetsKt.setOf((Object)((Object)FunctionFlag.CLOSURE)), true);
        function.setVimContext(vimContext);
        return new VimFuncref(new DefinedFunctionHandler(function), new VimList(new ArrayList()), null, VimFuncref.Type.LAMBDA);
    }

    private final String getFunctionName() {
        int n = VimFuncref.Companion.getLambdaCounter();
        VimFuncref.Companion.setLambdaCounter(n + 1);
        return "<lambda>" + n;
    }

    private final List<Executable> buildBody() {
        List body = new ArrayList();
        for (String argument : this.args) {
            body.add(new LetCommand(new Range(), new Variable(Scope.LOCAL_VARIABLE, argument), AssignmentOperator.ASSIGNMENT, new Variable(Scope.FUNCTION_VARIABLE, argument), true));
        }
        body.add(new ReturnStatement(this.expr));
        return body;
    }

    @NotNull
    public final List<String> component1() {
        return this.args;
    }

    @NotNull
    public final Expression component2() {
        return this.expr;
    }

    @NotNull
    public final LambdaExpression copy(@NotNull List<String> args, @NotNull Expression expr) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        return new LambdaExpression(args, expr);
    }

    public static /* synthetic */ LambdaExpression copy$default(LambdaExpression lambdaExpression, List list, Expression expression, int n, Object object) {
        if ((n & 1) != 0) {
            list = lambdaExpression.args;
        }
        if ((n & 2) != 0) {
            expression = lambdaExpression.expr;
        }
        return lambdaExpression.copy(list, expression);
    }

    @NotNull
    public String toString() {
        return "LambdaExpression(args=" + this.args + ", expr=" + this.expr + ")";
    }

    public int hashCode() {
        int result = ((Object)this.args).hashCode();
        result = result * 31 + this.expr.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LambdaExpression)) {
            return false;
        }
        LambdaExpression lambdaExpression = (LambdaExpression)other;
        if (!Intrinsics.areEqual(this.args, lambdaExpression.args)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expr, (Object)lambdaExpression.expr);
    }
}

