/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.expressions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDictionary;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.SimpleExpression;
import com.maddyhome.idea.vim.vimscript.model.expressions.SublistExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/expressions/OneElementSublistExpression;", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "index", "expression", "<init>", "(Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;)V", "getIndex", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "getExpression", "evaluate", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "vim-engine"})
public final class OneElementSublistExpression
extends Expression {
    @NotNull
    private final Expression index;
    @NotNull
    private final Expression expression;

    public OneElementSublistExpression(@NotNull Expression index, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.index = index;
        this.expression = expression;
    }

    @NotNull
    public final Expression getIndex() {
        return this.index;
    }

    @NotNull
    public final Expression getExpression() {
        return this.expression;
    }

    @Override
    @NotNull
    public VimDataType evaluate(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType expressionValue = this.expression.evaluate(editor, context, vimContext);
        if (expressionValue instanceof VimDictionary) {
            VimDataType vimDataType = ((VimDictionary)expressionValue).getDictionary().get(new VimString(this.index.evaluate(editor, context, vimContext).asString()));
            if (vimDataType == null) {
                throw new ExException("E716: Key not present in Dictionary: \"" + this.index.evaluate(editor, context, vimContext).asString() + "\"");
            }
            return vimDataType;
        }
        int indexValue = Integer.parseInt(this.index.evaluate(editor, context, vimContext).asString());
        if (expressionValue instanceof VimList && (indexValue >= ((VimList)expressionValue).getValues().size() || indexValue < 0)) {
            throw new ExException("E684: list index out of range: " + indexValue);
        }
        if (indexValue < 0) {
            return new VimString("");
        }
        return new SublistExpression(new SimpleExpression(indexValue), new SimpleExpression(indexValue), new SimpleExpression(expressionValue)).evaluate(editor, context, vimContext);
    }

    @NotNull
    public final Expression component1() {
        return this.index;
    }

    @NotNull
    public final Expression component2() {
        return this.expression;
    }

    @NotNull
    public final OneElementSublistExpression copy(@NotNull Expression index, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return new OneElementSublistExpression(index, expression);
    }

    public static /* synthetic */ OneElementSublistExpression copy$default(OneElementSublistExpression oneElementSublistExpression, Expression expression, Expression expression2, int n, Object object) {
        if ((n & 1) != 0) {
            expression = oneElementSublistExpression.index;
        }
        if ((n & 2) != 0) {
            expression2 = oneElementSublistExpression.expression;
        }
        return oneElementSublistExpression.copy(expression, expression2);
    }

    @NotNull
    public String toString() {
        return "OneElementSublistExpression(index=" + this.index + ", expression=" + this.expression + ")";
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = result * 31 + this.expression.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OneElementSublistExpression)) {
            return false;
        }
        OneElementSublistExpression oneElementSublistExpression = (OneElementSublistExpression)other;
        if (!Intrinsics.areEqual((Object)this.index, (Object)oneElementSublistExpression.index)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expression, (Object)oneElementSublistExpression.expression);
    }
}

