/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.statements;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimRegexpService;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.FinishException;
import com.maddyhome.idea.vim.vimscript.model.Executable;
import com.maddyhome.idea.vim.vimscript.model.ExecutableContext;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.Script;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.statements.CatchBlock;
import com.maddyhome.idea.vim.vimscript.model.statements.FinallyBlock;
import com.maddyhome.idea.vim.vimscript.model.statements.TryBlock;
import com.maddyhome.idea.vim.vimscript.parser.DeletionInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\bH\u00c6\u0003J/\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u000202H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00063"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/statements/TryStatement;", "Lcom/maddyhome/idea/vim/vimscript/model/Executable;", "tryBlock", "Lcom/maddyhome/idea/vim/vimscript/model/statements/TryBlock;", "catchBlocks", "", "Lcom/maddyhome/idea/vim/vimscript/model/statements/CatchBlock;", "finallyBlock", "Lcom/maddyhome/idea/vim/vimscript/model/statements/FinallyBlock;", "<init>", "(Lcom/maddyhome/idea/vim/vimscript/model/statements/TryBlock;Ljava/util/List;Lcom/maddyhome/idea/vim/vimscript/model/statements/FinallyBlock;)V", "getTryBlock", "()Lcom/maddyhome/idea/vim/vimscript/model/statements/TryBlock;", "getCatchBlocks", "()Ljava/util/List;", "getFinallyBlock", "()Lcom/maddyhome/idea/vim/vimscript/model/statements/FinallyBlock;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "getVimContext", "()Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "setVimContext", "(Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;)V", "rangeInScript", "Lcom/maddyhome/idea/vim/common/TextRange;", "getRangeInScript", "()Lcom/maddyhome/idea/vim/common/TextRange;", "setRangeInScript", "(Lcom/maddyhome/idea/vim/common/TextRange;)V", "execute", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "restoreOriginalRange", "", "deletionInfo", "Lcom/maddyhome/idea/vim/vimscript/parser/DeletionInfo;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nTryStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TryStatement.kt\ncom/maddyhome/idea/vim/vimscript/model/statements/TryStatement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1869#2,2:137\n*S KotlinDebug\n*F\n+ 1 TryStatement.kt\ncom/maddyhome/idea/vim/vimscript/model/statements/TryStatement\n*L\n74#1:137,2\n*E\n"})
public final class TryStatement
implements Executable {
    @NotNull
    private final TryBlock tryBlock;
    @NotNull
    private final List<CatchBlock> catchBlocks;
    @Nullable
    private final FinallyBlock finallyBlock;
    public VimLContext vimContext;
    public TextRange rangeInScript;

    public TryStatement(@NotNull TryBlock tryBlock, @NotNull List<CatchBlock> catchBlocks, @Nullable FinallyBlock finallyBlock) {
        Intrinsics.checkNotNullParameter((Object)tryBlock, (String)"tryBlock");
        Intrinsics.checkNotNullParameter(catchBlocks, (String)"catchBlocks");
        this.tryBlock = tryBlock;
        this.catchBlocks = catchBlocks;
        this.finallyBlock = finallyBlock;
    }

    @NotNull
    public final TryBlock getTryBlock() {
        return this.tryBlock;
    }

    @NotNull
    public final List<CatchBlock> getCatchBlocks() {
        return this.catchBlocks;
    }

    @Nullable
    public final FinallyBlock getFinallyBlock() {
        return this.finallyBlock;
    }

    @Override
    @NotNull
    public VimLContext getVimContext() {
        VimLContext vimLContext = this.vimContext;
        if (vimLContext != null) {
            return vimLContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"vimContext");
        return null;
    }

    @Override
    public void setVimContext(@NotNull VimLContext vimLContext) {
        Intrinsics.checkNotNullParameter((Object)vimLContext, (String)"<set-?>");
        this.vimContext = vimLContext;
    }

    @Override
    @NotNull
    public TextRange getRangeInScript() {
        TextRange textRange = this.rangeInScript;
        if (textRange != null) {
            return textRange;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rangeInScript");
        return null;
    }

    @Override
    public void setRangeInScript(@NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"<set-?>");
        this.rangeInScript = textRange;
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        ExecutionResult result;
        ExException uncaughtException;
        block8: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            uncaughtException = null;
            result = ExecutionResult.Success.INSTANCE;
            try {
                this.tryBlock.setVimContext(this);
                result = this.tryBlock.execute(editor, context);
                if (!(result instanceof ExecutionResult.Success)) {
                    return result;
                }
            }
            catch (ExException e) {
                if (e instanceof FinishException) {
                    if (this.finallyBlock != null) {
                        this.finallyBlock.setVimContext(this);
                        this.finallyBlock.execute(editor, context);
                    }
                    throw e;
                }
                boolean caught = false;
                for (CatchBlock catchBlock : this.catchBlocks) {
                    catchBlock.setVimContext(this);
                    if (!VimRegexpService.matches$default(VimInjectorKt.getInjector().getRegexpService(), catchBlock.getPattern(), e.getMessage(), false, 4, null)) continue;
                    caught = true;
                    result = catchBlock.execute(editor, context);
                    if (result instanceof ExecutionResult.Success) break;
                    return result;
                }
                if (caught) break block8;
                uncaughtException = e;
            }
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.setVimContext(this);
            result = this.finallyBlock.execute(editor, context);
        }
        if (uncaughtException != null) {
            throw uncaughtException;
        }
        return result;
    }

    @Override
    public void restoreOriginalRange(@NotNull DeletionInfo deletionInfo) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)deletionInfo, (String)"deletionInfo");
            Executable.super.restoreOriginalRange(deletionInfo);
            this.tryBlock.restoreOriginalRange(deletionInfo);
            Iterable $this$forEach$iv = this.catchBlocks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CatchBlock it = (CatchBlock)element$iv;
                boolean bl = false;
                it.restoreOriginalRange(deletionInfo);
            }
            FinallyBlock finallyBlock = this.finallyBlock;
            if (finallyBlock == null) break block1;
            finallyBlock.restoreOriginalRange(deletionInfo);
        }
    }

    @NotNull
    public final TryBlock component1() {
        return this.tryBlock;
    }

    @NotNull
    public final List<CatchBlock> component2() {
        return this.catchBlocks;
    }

    @Nullable
    public final FinallyBlock component3() {
        return this.finallyBlock;
    }

    @NotNull
    public final TryStatement copy(@NotNull TryBlock tryBlock, @NotNull List<CatchBlock> catchBlocks, @Nullable FinallyBlock finallyBlock) {
        Intrinsics.checkNotNullParameter((Object)tryBlock, (String)"tryBlock");
        Intrinsics.checkNotNullParameter(catchBlocks, (String)"catchBlocks");
        return new TryStatement(tryBlock, catchBlocks, finallyBlock);
    }

    public static /* synthetic */ TryStatement copy$default(TryStatement tryStatement, TryBlock tryBlock, List list, FinallyBlock finallyBlock, int n, Object object) {
        if ((n & 1) != 0) {
            tryBlock = tryStatement.tryBlock;
        }
        if ((n & 2) != 0) {
            list = tryStatement.catchBlocks;
        }
        if ((n & 4) != 0) {
            finallyBlock = tryStatement.finallyBlock;
        }
        return tryStatement.copy(tryBlock, list, finallyBlock);
    }

    @NotNull
    public String toString() {
        return "TryStatement(tryBlock=" + this.tryBlock + ", catchBlocks=" + this.catchBlocks + ", finallyBlock=" + this.finallyBlock + ")";
    }

    public int hashCode() {
        int result = this.tryBlock.hashCode();
        result = result * 31 + ((Object)this.catchBlocks).hashCode();
        result = result * 31 + (this.finallyBlock == null ? 0 : this.finallyBlock.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TryStatement)) {
            return false;
        }
        TryStatement tryStatement = (TryStatement)other;
        if (!Intrinsics.areEqual((Object)this.tryBlock, (Object)tryStatement.tryBlock)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.catchBlocks, tryStatement.catchBlocks)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.finallyBlock, (Object)tryStatement.finallyBlock);
    }

    @Override
    @NotNull
    public VimLContext getPreviousParentContext() {
        return Executable.super.getPreviousParentContext();
    }

    @Override
    public boolean isFirstParentContext() {
        return Executable.super.isFirstParentContext();
    }

    @Override
    @NotNull
    public VimLContext getFirstParentContext() {
        return Executable.super.getFirstParentContext();
    }

    @Override
    @NotNull
    public ExecutableContext getExecutableContext(@NotNull VimLContext executable) {
        return Executable.super.getExecutableContext(executable);
    }

    @Override
    @Nullable
    public Script getScript() {
        return Executable.super.getScript();
    }
}

