/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details.container;

import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerRootType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.ijent.OpenProjectKt;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.ui.components.DockerDisposablePanel;
import com.intellij.docker.utils.RemoteDockerRuntimeUtil;
import com.intellij.docker.view.details.container.DockerFileChooser;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.PopupHandler;
import com.intellij.util.Function;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerContainerBrowser
extends DockerDisposablePanel {
    private static final String TOOLBAR_PLACE = "DockerContainerBrowser#Toolbar";
    private static final String POPUP_PLACE = "DockerContainerBrowser#Popup";
    private static final Logger LOG = Logger.getInstance(DockerContainerBrowser.class);
    private final Project myProject;
    private final DockerApplicationRuntime myContainerRuntime;
    private final DockerFileChooser myFileChooser;
    private volatile boolean myIsDisposed;

    public DockerContainerBrowser(@NotNull Project project, @NotNull DockerApplicationRuntime containerRuntime) {
        if (project == null) {
            DockerContainerBrowser.$$$reportNull$$$0(0);
        }
        if (containerRuntime == null) {
            DockerContainerBrowser.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myIsDisposed = false;
        this.myProject = project;
        this.myContainerRuntime = containerRuntime;
        this.myFileChooser = new DockerFileChooser(this.myProject, this.myContainerRuntime, true, () -> this.init());
        this.add((Component)((Object)this.myFileChooser), "Center");
        Disposer.register((Disposable)containerRuntime, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myFileChooser);
    }

    private void init() {
        if (this.myIsDisposed) {
            return;
        }
        JTree tree = this.myFileChooser.getTree();
        DownloadAction downloadAction = new DownloadAction();
        ViewInEditorAction viewInEditorAction = new ViewInEditorAction();
        OpenProjectAction openProjectAction = new OpenProjectAction();
        DefaultActionGroup toolbarActions = new DefaultActionGroup(new AnAction[]{this.myFileChooser.createRefreshAction(), CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)new DefaultTreeExpander(tree), (JComponent)tree), new Separator(), downloadAction, viewInEditorAction});
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(TOOLBAR_PLACE, (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent((JComponent)tree);
        DefaultActionGroup popupActions = new DefaultActionGroup(new AnAction[]{downloadAction, viewInEditorAction, openProjectAction});
        PopupHandler.installPopupMenu((JComponent)tree, (ActionGroup)popupActions, (String)POPUP_PLACE);
        this.myFileChooser.addOkAction(this::viewInEditor);
        this.add((Component)toolbar.getComponent(), "East");
    }

    @Override
    public void dispose() {
        this.myIsDisposed = true;
    }

    private boolean hasSelectedFiles() {
        return this.myFileChooser.getSelectedFiles().length > 0;
    }

    private void download() {
        final List<String> selectedPaths = this.myFileChooser.getSelectedPaths();
        if (!selectedPaths.isEmpty()) {
            Task.Backgroundable downloadInBackground = new Task.Backgroundable(this.myProject, DockerBundle.message((String)"DockerContainerBrowser.downloadTask.title", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DockerContainerBrowser.this.download(selectedPaths);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/view/details/container/DockerContainerBrowser$1", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)downloadInBackground);
        }
    }

    private void download(@NotNull List<String> selectedPaths) {
        if (selectedPaths == null) {
            DockerContainerBrowser.$$$reportNull$$$0(2);
        }
        LinkedList<String> sourcePaths = new LinkedList<String>();
        for (String selectedPath : selectedPaths) {
            boolean addToSource = true;
            Iterator sourcePathsIterator = sourcePaths.iterator();
            while (sourcePathsIterator.hasNext()) {
                String sourcePath = (String)sourcePathsIterator.next();
                if (selectedPath.startsWith(sourcePath + "/")) {
                    addToSource = false;
                    break;
                }
                if (!sourcePath.startsWith(selectedPath + "/")) continue;
                sourcePathsIterator.remove();
            }
            if (!addToSource) continue;
            sourcePaths.add(selectedPath);
        }
        File targetDirectory = this.doDownload(sourcePaths);
        VirtualFile targetFile = DockerContainerBrowser.getTargetFile(LocalFileSystem.getInstance(), targetDirectory, selectedPaths.get(0));
        if (targetFile != null) {
            ApplicationManager.getApplication().invokeLater(() -> Objects.requireNonNull(ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Project")).activate(() -> {
                ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
                projectView.changeView("ProjectPane");
                projectView.select(null, targetFile, true);
            }));
        }
    }

    @NotNull
    private File doDownload(@NotNull List<String> sourcePaths) {
        if (sourcePaths == null) {
            DockerContainerBrowser.$$$reportNull$$$0(3);
        }
        File targetDirectory = new File(FileUtil.toSystemDependentName((String)(ScratchFileService.getInstance().getRootPath((RootType)DockerRootType.getInstance()) + "/" + this.myFileChooser.getSanitizedContainerName())));
        for (String sourcePath : sourcePaths) {
            this.download(sourcePath, targetDirectory);
        }
        VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
        File file = targetDirectory;
        if (file == null) {
            DockerContainerBrowser.$$$reportNull$$$0(4);
        }
        return file;
    }

    private void download(@NotNull String sourcePath, @NotNull File targetDirectory) {
        if (sourcePath == null) {
            DockerContainerBrowser.$$$reportNull$$$0(5);
        }
        if (targetDirectory == null) {
            DockerContainerBrowser.$$$reportNull$$$0(6);
        }
        try {
            RemoteDockerRuntimeUtil.download(this.myContainerRuntime.getAgentContainer(), sourcePath, targetDirectory, (Function<String, String>)((Function)DockerContainerBrowser::toRelativeLocalPath), null, null);
        }
        catch (ServerRuntimeException | IOException ex) {
            LOG.debug(ex);
        }
    }

    @NotNull
    private static String toRelativeLocalPath(@NotNull String remotePath) {
        if (remotePath == null) {
            DockerContainerBrowser.$$$reportNull$$$0(7);
        }
        String string = FileUtil.toSystemDependentName((String)remotePath.substring(1));
        if (string == null) {
            DockerContainerBrowser.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static VirtualFile getTargetFile(@NotNull LocalFileSystem localFileSystem, @NotNull File targetDirectory, @NotNull String sourcePath) {
        if (localFileSystem == null) {
            DockerContainerBrowser.$$$reportNull$$$0(9);
        }
        if (targetDirectory == null) {
            DockerContainerBrowser.$$$reportNull$$$0(10);
        }
        if (sourcePath == null) {
            DockerContainerBrowser.$$$reportNull$$$0(11);
        }
        return localFileSystem.refreshAndFindFileByIoFile(new File(targetDirectory, DockerContainerBrowser.toRelativeLocalPath(sourcePath)));
    }

    private boolean hasOnlyFilesSelected() {
        return DockerContainerBrowser.hasOnlyFilesSelected(this.myFileChooser.getSelectedFiles());
    }

    private static boolean hasOnlyFilesSelected(VirtualFile @NotNull [] selectedFiles) {
        if (selectedFiles == null) {
            DockerContainerBrowser.$$$reportNull$$$0(12);
        }
        if (selectedFiles.length <= 0) {
            return false;
        }
        for (VirtualFile selectedFile : selectedFiles) {
            if (!selectedFile.isDirectory()) continue;
            return false;
        }
        return true;
    }

    private void viewInEditor() {
        Object[] selectedFiles = this.myFileChooser.getSelectedFiles();
        if (DockerContainerBrowser.hasOnlyFilesSelected((VirtualFile[])selectedFiles)) {
            OpenSourceUtil.navigate((boolean)true, (boolean)true, (Iterable)ContainerUtil.map((Object[])selectedFiles, selectedFile -> new OpenFileDescriptor(this.myProject, selectedFile)));
        }
    }

    private VirtualDirectoryImpl getSelectedDirectory() {
        VirtualFile[] selectedFiles = this.myFileChooser.getSelectedFiles();
        if (selectedFiles.length == 1 && selectedFiles[0].isDirectory()) {
            return (VirtualDirectoryImpl)selectedFiles[0];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerRuntime";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedPaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePaths";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/view/details/container/DockerContainerBrowser";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileSystem";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/view/details/container/DockerContainerBrowser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doDownload";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toRelativeLocalPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doDownload";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toRelativeLocalPath";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTargetFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyFilesSelected";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8 -> new IllegalStateException(string);
        };
    }

    private class DownloadAction
    extends DumbAwareAction {
        DownloadAction() {
            super(DockerBundle.messagePointer((String)"DockerContainerBrowser.DownloadAction.text", (Object[])new Object[0]), DockerBundle.messagePointer((String)"DockerContainerBrowser.DownloadAction.description", (Object[])new Object[0]), AllIcons.Actions.Download);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DownloadAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(DockerContainerBrowser.this.hasSelectedFiles());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                DownloadAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DownloadAction.$$$reportNull$$$0(2);
            }
            DockerContainerBrowser.this.download();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/details/container/DockerContainerBrowser$DownloadAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/details/container/DockerContainerBrowser$DownloadAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class ViewInEditorAction
    extends DumbAwareAction {
        ViewInEditorAction() {
            super(DockerBundle.messagePointer((String)"DockerContainerBrowser.ViewInEditorAction.text", (Object[])new Object[0]), DockerBundle.messagePointer((String)"DockerContainerBrowser.ViewInEditorAction.description", (Object[])new Object[0]), AllIcons.Actions.Preview);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ViewInEditorAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(DockerContainerBrowser.this.hasOnlyFilesSelected());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ViewInEditorAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ViewInEditorAction.$$$reportNull$$$0(2);
            }
            DockerContainerBrowser.this.viewInEditor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/details/container/DockerContainerBrowser$ViewInEditorAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/details/container/DockerContainerBrowser$ViewInEditorAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class OpenProjectAction
    extends DumbAwareAction {
        OpenProjectAction() {
            super(DockerBundle.message((String)"group.Docker.RemoteServers.OpenProject.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualDirectoryImpl selectedDirectory;
            if (e == null) {
                OpenProjectAction.$$$reportNull$$$0(0);
            }
            if ((selectedDirectory = DockerContainerBrowser.this.getSelectedDirectory()) == null) {
                return;
            }
            String pathInsideContainer = DockerContainerBrowser.this.myFileChooser.getFileSystem().getPathInsideContainer((VirtualFile)selectedDirectory);
            OpenProjectKt.openProjectUnderModalProgress(DockerContainerBrowser.this.myContainerRuntime.getAgentContainer(), pathInsideContainer, DockerContainerBrowser.this.myContainerRuntime.getServer());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                OpenProjectAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenProjectAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setIcon(DockerIcons.Docker);
            e.getPresentation().setEnabledAndVisible(Registry.is((String)"open.docker.projects.using.eel") && DockerContainerBrowser.this.getSelectedDirectory() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/details/container/DockerContainerBrowser$OpenProjectAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/details/container/DockerContainerBrowser$OpenProjectAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

