/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.feautures;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0004\"\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"DEFAULT_FEATURE_PATH", "", "LEGACY_IDS", "", "[Ljava/lang/String;", "RENAMED_IDS", "", "migrateId", "originalId", "intellij.clouds.docker.agent"})
public final class DevcontainerFeatureRefMigrationKt {
    @NotNull
    private static final String DEFAULT_FEATURE_PATH = "ghcr.io/devcontainers/features";
    @NotNull
    private static final String[] LEGACY_IDS;
    @NotNull
    private static final Map<String, String> RENAMED_IDS;

    @NotNull
    public static final String migrateId(@NotNull String originalId) {
        Intrinsics.checkNotNullParameter((Object)originalId, (String)"originalId");
        if (Intrinsics.areEqual((Object)originalId, (Object)"cargo_binstall")) {
            return "ghcr.io/lee-orr/rusty-dev-containers/" + originalId;
        }
        if (ArraysKt.contains((Object[])LEGACY_IDS, (Object)originalId)) {
            return DEFAULT_FEATURE_PATH + "/" + originalId + ":1";
        }
        if (RENAMED_IDS.containsKey(originalId)) {
            return DEFAULT_FEATURE_PATH + "/" + RENAMED_IDS.get(originalId) + ":1";
        }
        return originalId;
    }

    static {
        String[] stringArray = new String[]{"aws-cli", "azure-cli", "desktop-lite", "docker-in-docker", "docker-from-docker", "dotnet", "git", "git-lfs", "github-cli", "java", "kubectl-helm-minikube", "node", "powershell", "python", "ruby", "rust", "sshd", "terraform"};
        LEGACY_IDS = stringArray;
        stringArray = new Pair[]{TuplesKt.to((Object)"golang", (Object)"go"), TuplesKt.to((Object)"common", (Object)"common-utils")};
        RENAMED_IDS = MapsKt.mapOf((Pair[])stringArray);
    }
}

