/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.pipe;

import com.github.dockerjava.api.async.ResultCallback;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class StreamCallbackBase<T>
implements ResultCallback<T> {
    private static final Logger myLogger = LoggerFactory.getLogger(StreamCallbackBase.class);
    private Closeable myChannelCloseable;
    private boolean myChannelCloseRequested;
    private final Object CLOSE_REQUEST_LOCK = new Object();

    StreamCallbackBase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(Closeable closeable) {
        boolean closeImmediately;
        Object object = this.CLOSE_REQUEST_LOCK;
        synchronized (object) {
            this.myChannelCloseable = closeable;
            closeImmediately = closeable != null && this.myChannelCloseRequested;
        }
        if (closeImmediately) {
            this.requestCloseChannel();
        }
    }

    public void onNext(T packet) {
        try {
            this.onNextWrite(packet);
        }
        catch (IOException e) {
            myLogger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public void onError(Throwable throwable) {
        Exception e = new Exception(throwable);
        myLogger.debug(e.getMessage(), (Throwable)e);
        this.requestCloseChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        Object object = this.CLOSE_REQUEST_LOCK;
        synchronized (object) {
            this.myChannelCloseable = null;
            this.myChannelCloseRequested = false;
        }
        this.requestCloseChannel();
    }

    public void close() throws IOException {
        this.requestCloseChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestCloseChannel() {
        Object object = this.CLOSE_REQUEST_LOCK;
        synchronized (object) {
            if (this.myChannelCloseable == null) {
                this.myChannelCloseRequested = true;
                return;
            }
            try {
                this.myChannelCloseable.close();
            }
            catch (IOException e) {
                myLogger.debug(e.getMessage(), (Throwable)e);
            }
            this.myChannelCloseable = null;
            this.myChannelCloseRequested = false;
        }
    }

    protected abstract void onNextWrite(T var1) throws IOException;
}

