/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.python;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.adelf.idea.dotenv.DotEnvSettings;
import ru.adelf.idea.dotenv.api.EnvironmentVariablesApi;
import ru.adelf.idea.dotenv.common.BaseEnvCompletionProvider;
import ru.adelf.idea.dotenv.python.PythonPsiHelper;

final class PythonEnvCompletionProvider
extends BaseEnvCompletionProvider
implements GotoDeclarationHandler {
    PythonEnvCompletionProvider() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters completionParameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet completionResultSet) {
                PsiElement psiElement;
                if (completionParameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processingContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (completionResultSet == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((psiElement = completionParameters.getOriginalPosition()) == null || !DotEnvSettings.getInstance().completionEnabled) {
                    return;
                }
                if (PythonEnvCompletionProvider.this.getStringLiteral(psiElement) == null) {
                    return;
                }
                PythonEnvCompletionProvider.this.fillCompletionResultSet(completionResultSet, psiElement.getProject());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "completionParameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processingContext";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "completionResultSet";
                        break;
                    }
                }
                objectArray[1] = "ru/adelf/idea/dotenv/python/PythonEnvCompletionProvider$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement psiElement, int i, Editor editor) {
        if (psiElement == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PyStringLiteralExpression stringLiteral = this.getStringLiteral(psiElement);
        if (stringLiteral == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        return EnvironmentVariablesApi.getKeyDeclarations(psiElement.getProject(), stringLiteral.getStringValue());
    }

    @Nullable
    private PyStringLiteralExpression getStringLiteral(@NotNull PsiElement psiElement) {
        PyExpression assignedValue;
        PsiElement parent;
        if (psiElement == null) {
            PythonEnvCompletionProvider.$$$reportNull$$$0(0);
        }
        if (!((parent = psiElement.getParent()) instanceof PyStringLiteralExpression)) {
            return null;
        }
        if (parent.getParent() == null) {
            return null;
        }
        PsiElement candidate = parent.getParent().getParent();
        if (candidate instanceof PyCallExpression) {
            PyCallExpression callExpression = (PyCallExpression)candidate;
            if (PythonPsiHelper.checkGetMethodCall(callExpression) && callExpression.getArgumentList() != null && callExpression.getArgumentList().getArguments().length > 0 && callExpression.getArgumentList().getArguments()[0].isEquivalentTo(parent)) {
                return (PyStringLiteralExpression)parent;
            }
            return null;
        }
        if (candidate instanceof PyAssignmentStatement && (assignedValue = ((PyAssignmentStatement)candidate).getAssignedValue()) instanceof PySubscriptionExpression) {
            if (PythonPsiHelper.checkIndexCall((PySubscriptionExpression)assignedValue)) {
                return (PyStringLiteralExpression)parent;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public String getActionText(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PythonEnvCompletionProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "ru/adelf/idea/dotenv/python/PythonEnvCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringLiteral";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

