/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import mobi.hsz.idea.gitignore.psi.IgnoreElementType;
import mobi.hsz.idea.gitignore.psi.IgnoreTokenType;
import mobi.hsz.idea.gitignore.psi.impl.IgnoreEntryDirectoryImpl;
import mobi.hsz.idea.gitignore.psi.impl.IgnoreEntryFileImpl;
import mobi.hsz.idea.gitignore.psi.impl.IgnoreEntryImpl;
import mobi.hsz.idea.gitignore.psi.impl.IgnoreNegationImpl;
import mobi.hsz.idea.gitignore.psi.impl.IgnoreSyntaxImpl;

public interface IgnoreTypes {
    public static final IElementType ENTRY = new IgnoreElementType("ENTRY");
    public static final IElementType ENTRY_DIRECTORY = new IgnoreElementType("ENTRY_DIRECTORY");
    public static final IElementType ENTRY_FILE = new IgnoreElementType("ENTRY_FILE");
    public static final IElementType NEGATION = new IgnoreElementType("NEGATION");
    public static final IElementType SYNTAX = new IgnoreElementType("SYNTAX");
    public static final IElementType BRACKET_LEFT = new IgnoreTokenType("BRACKET_LEFT");
    public static final IElementType BRACKET_RIGHT = new IgnoreTokenType("BRACKET_RIGHT");
    public static final IElementType COMMENT = new IgnoreTokenType("COMMENT");
    public static final IElementType CRLF = new IgnoreTokenType("CRLF");
    public static final IElementType HEADER = new IgnoreTokenType("HEADER");
    public static final IElementType SECTION = new IgnoreTokenType("SECTION");
    public static final IElementType SLASH = new IgnoreTokenType("/");
    public static final IElementType SYNTAX_KEY = new IgnoreTokenType("syntax:");
    public static final IElementType VALUE = new IgnoreTokenType("VALUE");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == ENTRY) {
                return new IgnoreEntryImpl(node);
            }
            if (type == ENTRY_DIRECTORY) {
                return new IgnoreEntryDirectoryImpl(node);
            }
            if (type == ENTRY_FILE) {
                return new IgnoreEntryFileImpl(node);
            }
            if (type == NEGATION) {
                return new IgnoreNegationImpl(node);
            }
            if (type == SYNTAX) {
                return new IgnoreSyntaxImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

