/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.ml.llm.chatInputLanguage.ChatInputLanguage;
import com.intellij.ml.llm.chatInputLanguage.ChatInputLexerAdapter;
import com.intellij.ml.llm.chatInputLanguage.parser.ChatInputParser;
import com.intellij.ml.llm.chatInputLanguage.psi.ChatInputFile;
import com.intellij.ml.llm.chatInputLanguage.psi.ChatInputTypes;
import com.intellij.ml.llm.chatInputLanguage.psi.impl.ChatInputCodeFence;
import com.intellij.ml.llm.chatInputLanguage.psi.impl.ChatInputReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/ChatInputParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "getWhitespaceTokens", "Lcom/intellij/psi/tree/TokenSet;", "getCommentTokens", "getStringLiteralElements", "createParser", "Lcom/intellij/lang/PsiParser;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "Constants", "intellij.ml.llm.chatInputLanguage"})
public final class ChatInputParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return (Lexer)new ChatInputLexerAdapter();
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new ChatInputParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return Constants.INSTANCE.getFileNodeType();
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        return (PsiFile)new ChatInputFile(viewProvider);
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ChatInputTypes.PLAINTEXT_SEGMENT)) {
            psiElement = (PsiElement)new ASTWrapperPsiElement(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ChatInputTypes.CODE_FENCE_ELEMENT)) {
            psiElement = (PsiElement)new ChatInputCodeFence(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ChatInputTypes.CODE_FENCE_CONTENTS_ELEMENT)) {
            psiElement = (PsiElement)new ASTWrapperPsiElement(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ChatInputTypes.REFERENCE_ELEMENT)) {
            psiElement = (PsiElement)new ChatInputReference(node);
        } else {
            throw new IllegalArgumentException("Not a Chat Input Language node: " + node + " (" + node.getElementType() + ", " + node.getElementType().getLanguage() + ")");
        }
        return psiElement;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/ChatInputParserDefinition$Constants;", "", "<init>", "()V", "fileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getFileNodeType", "()Lcom/intellij/psi/tree/IFileElementType;", "intellij.ml.llm.chatInputLanguage"})
    public static final class Constants {
        @NotNull
        public static final Constants INSTANCE = new Constants();
        @NotNull
        private static final IFileElementType fileNodeType = new IFileElementType((Language)ChatInputLanguage.INSTANCE);

        private Constants() {
        }

        @NotNull
        public final IFileElementType getFileNodeType() {
            return fileNodeType;
        }
    }
}

