/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context;

import com.intellij.ml.llm.context.TimeBucket;
import com.intellij.ml.llm.context.TimeValue;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\u001a+\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"MAX_ASTERISKS", "", "merge", "", "Lcom/intellij/ml/llm/context/TimeBucket;", "otherBuckets", "([Lcom/intellij/ml/llm/context/TimeBucket;[Lcom/intellij/ml/llm/context/TimeBucket;)[Lcom/intellij/ml/llm/context/TimeBucket;", "usBucket", "from", "to", "msBucket", "sBucket", "createBuckets", "()[Lcom/intellij/ml/llm/context/TimeBucket;", "intellij.ml.llm.context"})
@SourceDebugExtension(value={"SMAP\nContextRetrievalStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextRetrievalStatistics.kt\ncom/intellij/ml/llm/context/ContextRetrievalStatisticsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,520:1\n1563#2:521\n1634#2,3:522\n*S KotlinDebug\n*F\n+ 1 ContextRetrievalStatistics.kt\ncom/intellij/ml/llm/context/ContextRetrievalStatisticsKt\n*L\n468#1:521\n468#1:522,3\n*E\n"})
public final class ContextRetrievalStatisticsKt {
    private static final long MAX_ASTERISKS = 10L;

    /*
     * WARNING - void declaration
     */
    private static final TimeBucket[] merge(TimeBucket[] $this$merge, TimeBucket[] otherBuckets) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ArraysKt.zip((Object[])$this$merge, (Object[])otherBuckets);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            boolean bl;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            TimeBucket left = (TimeBucket)pair.component1();
            TimeBucket right = (TimeBucket)pair.component2();
            boolean bl3 = bl = Intrinsics.areEqual((Object)left.getFrom(), (Object)right.getFrom()) && Intrinsics.areEqual((Object)left.getTo(), (Object)right.getTo());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            collection.add(new TimeBucket(left.getFrom(), left.getTo(), new AtomicLong(left.getCounter() + right.getCounter())));
        }
        return (TimeBucket[])UtilKt.toArray((Collection)((List)destination$iv$iv), (Object[])new TimeBucket[0]);
    }

    private static final TimeBucket usBucket(long from, long to) {
        return new TimeBucket(new TimeValue(from, TimeUnit.MICROSECONDS), new TimeValue(to, TimeUnit.MICROSECONDS), null, 4, null);
    }

    private static final TimeBucket msBucket(long from, long to) {
        return new TimeBucket(new TimeValue(from, TimeUnit.MILLISECONDS), new TimeValue(to, TimeUnit.MILLISECONDS), null, 4, null);
    }

    private static final TimeBucket sBucket(long from, long to) {
        return new TimeBucket(new TimeValue(from, TimeUnit.SECONDS), new TimeValue(to, TimeUnit.SECONDS), null, 4, null);
    }

    private static final TimeBucket[] createBuckets() {
        TimeBucket[] timeBucketArray = new TimeBucket[]{ContextRetrievalStatisticsKt.usBucket(0L, 100L), ContextRetrievalStatisticsKt.usBucket(100L, 500L), ContextRetrievalStatisticsKt.usBucket(500L, 1000L), ContextRetrievalStatisticsKt.msBucket(1L, 100L), ContextRetrievalStatisticsKt.msBucket(100L, 500L), ContextRetrievalStatisticsKt.msBucket(500L, 1000L), ContextRetrievalStatisticsKt.sBucket(1L, 10L), ContextRetrievalStatisticsKt.sBucket(10L, 50L), ContextRetrievalStatisticsKt.sBucket(50L, Long.MAX_VALUE)};
        TimeBucket[] buckets = timeBucketArray;
        int n = buckets.length;
        for (int i = 1; i < n; ++i) {
            boolean bl;
            TimeBucket prev = buckets[i - 1];
            TimeBucket curr = buckets[i];
            boolean bl2 = bl = prev.getTo().getValue() <= prev.getTo().getUnit().convert(curr.getFrom().getValue(), curr.getFrom().getUnit());
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl3 = false;
            String string = "Time buckets should not overlap";
            throw new AssertionError((Object)string);
        }
        return buckets;
    }

    public static final /* synthetic */ TimeBucket[] access$createBuckets() {
        return ContextRetrievalStatisticsKt.createBuckets();
    }

    public static final /* synthetic */ TimeBucket[] access$merge(TimeBucket[] $receiver, TimeBucket[] otherBuckets) {
        return ContextRetrievalStatisticsKt.merge($receiver, otherBuckets);
    }
}

