/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.ide.entity;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.ml.llm.context.ContextEntity;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.context.ide.entity.SimpleContextEntitySource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/context/ide/entity/ContextEntityDiagnostic;", "Lcom/intellij/ml/llm/context/ContextEntity;", "source", "", "message", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/lang/annotation/HighlightSeverity;)V", "getSource", "()Ljava/lang/String;", "getMessage", "getSeverity", "()Lcom/intellij/lang/annotation/HighlightSeverity;", "id", "getId", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.context.ide"})
public final class ContextEntityDiagnostic
implements ContextEntity {
    @NotNull
    private final String source;
    @NotNull
    private final String message;
    @NotNull
    private final HighlightSeverity severity;

    public ContextEntityDiagnostic(@NotNull String source, @NotNull String message, @NotNull HighlightSeverity severity) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        this.source = source;
        this.message = message;
        this.severity = severity;
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final HighlightSeverity getSeverity() {
        return this.severity;
    }

    @Override
    @NotNull
    public String getId() {
        return this.message;
    }

    @Override
    @NotNull
    public ContextEntitySource getAttachedBy() {
        return new SimpleContextEntitySource(this.source);
    }

    @Override
    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return ContextEntityPrivacy.Unrelated.INSTANCE;
    }

    @NotNull
    public final String component1() {
        return this.source;
    }

    @NotNull
    public final String component2() {
        return this.message;
    }

    @NotNull
    public final HighlightSeverity component3() {
        return this.severity;
    }

    @NotNull
    public final ContextEntityDiagnostic copy(@NotNull String source, @NotNull String message, @NotNull HighlightSeverity severity) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        return new ContextEntityDiagnostic(source, message, severity);
    }

    public static /* synthetic */ ContextEntityDiagnostic copy$default(ContextEntityDiagnostic contextEntityDiagnostic, String string, String string2, HighlightSeverity highlightSeverity, int n, Object object) {
        if ((n & 1) != 0) {
            string = contextEntityDiagnostic.source;
        }
        if ((n & 2) != 0) {
            string2 = contextEntityDiagnostic.message;
        }
        if ((n & 4) != 0) {
            highlightSeverity = contextEntityDiagnostic.severity;
        }
        return contextEntityDiagnostic.copy(string, string2, highlightSeverity);
    }

    @NotNull
    public String toString() {
        return "ContextEntityDiagnostic(source=" + this.source + ", message=" + this.message + ", severity=" + this.severity + ")";
    }

    public int hashCode() {
        int result2 = this.source.hashCode();
        result2 = result2 * 31 + this.message.hashCode();
        result2 = result2 * 31 + this.severity.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContextEntityDiagnostic)) {
            return false;
        }
        ContextEntityDiagnostic contextEntityDiagnostic = (ContextEntityDiagnostic)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)contextEntityDiagnostic.source)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)contextEntityDiagnostic.message)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.severity, (Object)contextEntityDiagnostic.severity);
    }
}

