/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.agents.workspace;

import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.ds.agents.base.DataSpellAgentOneShotContext;
import com.intellij.ml.llm.ds.agents.base.DataSpellAgentOneShotWithHistorySupport;
import com.intellij.ml.llm.ds.agents.base.tools.DataSpellTool;
import com.intellij.ml.llm.ds.agents.workspace.WorkspaceAgentContext;
import com.intellij.ml.llm.ds.agents.workspace.models.DirectoryModel;
import com.intellij.ml.llm.ds.agents.workspace.models.WorkspaceModel;
import com.intellij.ml.llm.ds.agents.workspace.tools.AttachDirectoryTool;
import com.intellij.ml.llm.ds.agents.workspace.tools.CreateFileTool;
import com.intellij.ml.llm.ds.agents.workspace.tools.SelectAndAttachDirectoryTool;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u00140\u0005H\u0014R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/ds/agents/workspace/WorkspaceAgentSupport;", "Lcom/intellij/ml/llm/ds/agents/base/DataSpellAgentOneShotWithHistorySupport;", "Lcom/intellij/ml/llm/ds/agents/workspace/WorkspaceAgentContext;", "context", "history", "", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "<init>", "(Lcom/intellij/ml/llm/ds/agents/workspace/WorkspaceAgentContext;Ljava/util/List;)V", "model", "Lcom/intellij/ml/llm/ds/agents/workspace/models/WorkspaceModel;", "getModel", "()Lcom/intellij/ml/llm/ds/agents/workspace/models/WorkspaceModel;", "clientAgentName", "", "getClientAgentName", "()Ljava/lang/String;", "systemPrompt", "getSystemPrompt", "createTools", "Lcom/intellij/ml/llm/ds/agents/base/tools/DataSpellTool;", "Companion", "intellij.ml.llm.ds"})
public final class WorkspaceAgentSupport
extends DataSpellAgentOneShotWithHistorySupport<WorkspaceAgentContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String WORKSPACE_AGENT_NAME = "ai-agents_dataspell_workspace";

    public WorkspaceAgentSupport(@NotNull WorkspaceAgentContext context2, @NotNull List<? extends ChatMessage> history) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(history, (String)"history");
        super((DataSpellAgentOneShotContext)context2, history);
    }

    private final WorkspaceModel getModel() {
        return ((WorkspaceAgentContext)this.getContext()).getWorkspaceModel();
    }

    @Override
    @NotNull
    protected String getClientAgentName() {
        return WORKSPACE_AGENT_NAME;
    }

    @Override
    @NotNull
    protected String getSystemPrompt() {
        return StringsKt.trimIndent((String)("\n      You are an agent who applies file, directory, workspace operations.\n      \n      You will receive a user request and, using the tools, must perform actions that best fulfill the user's request.\n\n      Yes MUST operate with tools, not offer text solutions in the result.\n      You MUST perform the user's task with maximum accuracy, without generating unnecessary functions or recommendations.\n      \n      List of attached top-level directories in the workspace, \n      where each entry follows the format \"simple name: absolute path\" (e.g., notebooks : /home/user/project/notebooks):\n      " + CollectionsKt.joinToString$default((Iterable)this.getModel().getAttachedDirectories(), (CharSequence)"\n", null, null, (int)0, null, WorkspaceAgentSupport::_get_systemPrompt_$lambda$0, (int)30, null) + "}\n      \n      The user may refer to existing top-level directories using either absolute paths or simple names.\n      \n      Examples of popular files this agent can create include, but are not limited to:\n      1. Text file (.txt)\n      2. Jupyter Notebook (.ipynb)\n      3. Python Script (.py)\n      4. R Script (.R)\n      5. Quarto Document (.qmd)\n      6. Any file with an explicitly specified extension\n     \n      If you have not applied any actions, include an explanation in your response to the user, stating why you cannot generate a non-empty sequence of actions for their request.         \n    "));
    }

    @Override
    @NotNull
    protected List<DataSpellTool<WorkspaceAgentContext, ?>> createTools() {
        DataSpellTool[] dataSpellToolArray = new DataSpellTool[]{new CreateFileTool((WorkspaceAgentContext)this.getContext()), new AttachDirectoryTool((WorkspaceAgentContext)this.getContext()), new SelectAndAttachDirectoryTool((WorkspaceAgentContext)this.getContext())};
        return CollectionsKt.listOf((Object[])dataSpellToolArray);
    }

    private static final CharSequence _get_systemPrompt_$lambda$0(DirectoryModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "- " + it.getName() + " : " + it.getAbsolutePath();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/ds/agents/workspace/WorkspaceAgentSupport$Companion;", "", "<init>", "()V", "WORKSPACE_AGENT_NAME", "", "intellij.ml.llm.ds"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

