/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.common.chatEditMode;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.ml.llm.codeGeneration.multifile.core.change.processor.LlmDiffCustomApplierProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/jupyter/common/chatEditMode/JupyterLlmDiffCustomApplierProvider;", "Lcom/intellij/ml/llm/codeGeneration/multifile/core/change/processor/LlmDiffCustomApplierProvider;", "<init>", "()V", "modifyDiff", "", "language", "path", "diff", "cleanupJsonContent", "jsonContent", "fixEscapedTripleQuotes", "json", "fixUnescapedQuotes", "containsJupyterNotebookStructure", "", "content", "extractAndFixJupyterJson", "intellij.ml.llm.jupyter.common"})
public final class JupyterLlmDiffCustomApplierProvider
implements LlmDiffCustomApplierProvider {
    @Override
    @NotNull
    public String modifyDiff(@Nullable String language, @Nullable String path, @NotNull String diff2) {
        Intrinsics.checkNotNullParameter((Object)diff2, (String)"diff");
        String string = path;
        if (!(string != null ? StringsKt.endsWith$default((String)string, (String)".ipynb", (boolean)false, (int)2, null) : false) && !Intrinsics.areEqual((Object)language, (Object)"Jupyter")) {
            return diff2;
        }
        List lines2 = StringsKt.lines((CharSequence)diff2);
        if (lines2.size() < 2) {
            return diff2;
        }
        if (StringsKt.startsWith$default((String)((String)lines2.get(0)), (String)"#%%", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)((String)lines2.get(1)), (String)"{", (boolean)false, (int)2, null)) {
            String jsonContent = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)lines2, (int)1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            try {
                JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(jsonContent);
                Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                ObjectNode jsonNode2 = (ObjectNode)jsonNode;
                JupyterNotebookBase notebook = JupyterFileUtils.INSTANCE.initFromJson(jsonNode2);
                return ((Object)notebook.asSource()).toString();
            }
            catch (Exception e) {
                try {
                    ObjectNode cleanedJsonNode;
                    String cleanedJsonContent = this.cleanupJsonContent(jsonContent);
                    JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(cleanedJsonContent);
                    ObjectNode objectNode = cleanedJsonNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
                    if (cleanedJsonNode != null) {
                        JupyterNotebookBase notebook = JupyterFileUtils.INSTANCE.initFromJson(cleanedJsonNode);
                        return ((Object)notebook.asSource()).toString();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return diff2;
            }
        }
        if (this.containsJupyterNotebookStructure(diff2)) {
            try {
                ObjectNode jsonNode;
                String fixedJsonContent = this.extractAndFixJupyterJson(diff2);
                JsonNode e = JupyterJsonKt.getJackson().readTree(fixedJsonContent);
                ObjectNode objectNode = jsonNode = e instanceof ObjectNode ? (ObjectNode)e : null;
                if (jsonNode != null) {
                    JupyterNotebookBase notebook = JupyterFileUtils.INSTANCE.initFromJson(jsonNode);
                    return ((Object)notebook.asSource()).toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringsKt.startsWith$default((String)((String)lines2.get(0)), (String)"#%%", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)((String)lines2.get(1)), (String)"#%%", (boolean)false, (int)2, null)) {
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)lines2, (int)1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        return diff2;
    }

    private final String cleanupJsonContent(String jsonContent) {
        String cleaned = jsonContent;
        CharSequence charSequence = cleaned;
        Regex regex = new Regex("[\\p{Cntrl}&&[^\r\n\t]]");
        String string = "";
        cleaned = regex.replace(charSequence, string);
        cleaned = this.fixEscapedTripleQuotes(cleaned);
        cleaned = this.fixUnescapedQuotes(cleaned);
        charSequence = cleaned;
        regex = new Regex(",\\s*]");
        string = "]";
        cleaned = regex.replace(charSequence, string);
        charSequence = cleaned;
        regex = new Regex(",\\s*}");
        string = "}";
        cleaned = regex.replace(charSequence, string);
        return cleaned;
    }

    private final String fixEscapedTripleQuotes(String json) {
        String result2 = json;
        CharSequence charSequence = result2;
        Regex regex = new Regex("(\\s+)\\\\\"\\\\\"\\\\\"");
        String string = "$1\\\\\\\"\\\\\\\"\\\\\\\"";
        result2 = regex.replace(charSequence, string);
        charSequence = result2;
        regex = new Regex("\\\\\"(\\s*),");
        string = "\\\\\\\"$1,";
        result2 = regex.replace(charSequence, string);
        charSequence = result2;
        regex = new Regex("\\\\\"(\\s*)\n");
        string = "\\\\\\\"$1\n";
        result2 = regex.replace(charSequence, string);
        charSequence = result2;
        regex = new Regex("\n(\\s+)\",");
        string = "\n$1\\\",";
        result2 = regex.replace(charSequence, string);
        charSequence = result2;
        regex = new Regex("\\\\(\\s*)\n");
        string = "\\\\\\\\$1\n";
        result2 = regex.replace(charSequence, string);
        return result2;
    }

    private final String fixUnescapedQuotes(String json) {
        StringBuilder result2 = new StringBuilder();
        boolean inString = false;
        boolean escaped = false;
        int n = ((CharSequence)json).length();
        for (int i = 0; i < n; ++i) {
            char c = json.charAt(i);
            if (c == '\"' && !escaped) {
                boolean bl = inString = !inString;
            }
            escaped = c == '\\' ? !escaped : false;
            if (inString && c == '\"') {
                Character c2 = StringsKt.getOrNull((CharSequence)json, (int)(i - 1));
                char c3 = '\\';
                if (c2 == null || c2.charValue() != c3) {
                    Character c4 = StringsKt.getOrNull((CharSequence)json, (int)(i - 1));
                    c3 = '\"';
                    if (c4 == null || c4.charValue() != c3) continue;
                }
            }
            result2.append(c);
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean containsJupyterNotebookStructure(String content2) {
        return StringsKt.contains$default((CharSequence)content2, (CharSequence)"\"cells\"", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)content2, (CharSequence)"\"metadata\"", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)content2, (CharSequence)"\"nbformat\"", (boolean)false, (int)2, null) && (StringsKt.contains$default((CharSequence)content2, (CharSequence)"\"cell_type\"", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)content2, (CharSequence)"\"source\"", (boolean)false, (int)2, null));
    }

    private final String extractAndFixJupyterJson(String content2) {
        int startIndex = StringsKt.indexOf$default((CharSequence)content2, (String)"{", (int)0, (boolean)false, (int)6, null);
        int endIndex = StringsKt.lastIndexOf$default((CharSequence)content2, (String)"}", (int)0, (boolean)false, (int)6, null);
        if (startIndex == -1 || endIndex == -1 || endIndex <= startIndex) {
            throw new IllegalArgumentException("Cannot find valid JSON structure");
        }
        String string = content2.substring(startIndex, endIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String jsonContent = string;
        jsonContent = this.cleanupJsonContent(jsonContent);
        CharSequence charSequence = jsonContent;
        Regex regex = new Regex("f['\"]([^{]*?)\"([^\"]*?)\\[\"([^\"]*?)\"\\]([^'\"]*?)['\"]");
        String string2 = "\"$1\\\\\"$2[\\\\\\\"$3\\\\\\\"$4\\\\\"\"";
        jsonContent = regex.replace(charSequence, string2);
        charSequence = jsonContent;
        regex = new Regex("print\\(f['\"]([^{]*?)\"([^\"]*?)\\[\"([^\"]*?)\"\\]\\[([^\\]]*?)\\]\"([^'\"]*?)['\"]\\)");
        string2 = "print(\"$1\\\\\"$2[\\\\\\\"$3\\\\\"][\\$4]\\\\\"$5\")";
        jsonContent = regex.replace(charSequence, string2);
        charSequence = jsonContent;
        regex = new Regex("f['\"]([^{]*?)\"([^\"]*?)\"([^'\"]*?)['\"]");
        string2 = "\"$1\\\\\"$2\\\\\"$3\"";
        jsonContent = regex.replace(charSequence, string2);
        charSequence = jsonContent;
        regex = new Regex("f['\"]([^'\"]*?)\\{([^}]*?)\\}([^'\"]*?)['\"]");
        string2 = "\"$1$2$3\"";
        jsonContent = regex.replace(charSequence, string2);
        charSequence = jsonContent;
        regex = new Regex("\\}([^'\"]*?)\\{");
        string2 = "}$1";
        jsonContent = regex.replace(charSequence, string2);
        return jsonContent;
    }
}

