/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client;

import com.intellij.ml.llm.mcp.client.McpLogEntryKt;
import com.intellij.ml.llm.mcp.client.McpLogEntryType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/mcp/client/McpTeeInputStream;", "Ljava/io/InputStream;", "inputStream", "logWriter", "Ljava/io/BufferedWriter;", "logType", "Lcom/intellij/ml/llm/mcp/client/McpLogEntryType;", "closeLogWriter", "", "startMessage", "", "<init>", "(Ljava/io/InputStream;Ljava/io/BufferedWriter;Lcom/intellij/ml/llm/mcp/client/McpLogEntryType;ZLjava/lang/String;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "read", "", "b", "", "off", "len", "available", "close", "", "mark", "readlimit", "markSupported", "reset", "skip", "", "n", "intellij.ml.llm.mcp"})
public final class McpTeeInputStream
extends InputStream {
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final BufferedWriter logWriter;
    @NotNull
    private final McpLogEntryType logType;
    @NotNull
    private AtomicBoolean closed;

    public McpTeeInputStream(@NotNull InputStream inputStream, @NotNull BufferedWriter logWriter, @NotNull McpLogEntryType logType, boolean closeLogWriter, @Nullable String startMessage) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
        this.inputStream = inputStream;
        this.logWriter = logWriter;
        this.logType = logType;
        this.closed = new AtomicBoolean(!closeLogWriter);
        if (startMessage != null) {
            try {
                McpLogEntryKt.writeLogEntry(this.logWriter, startMessage, McpLogEntryType.INFO);
            }
            catch (IOException iOException) {
            }
        }
    }

    @Override
    public int read() throws IOException {
        int data = this.inputStream.read();
        if (data != -1) {
            McpLogEntryKt.writeLogEntry(this.logWriter, String.valueOf((char)data), this.logType);
        }
        return data;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int bytesRead = this.inputStream.read(b, off, len);
        if (bytesRead > 0) {
            McpLogEntryKt.writeLogEntry(this.logWriter, new String(b, off, bytesRead, Charsets.UTF_8), this.logType);
        }
        return bytesRead;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        if (this.closed.compareAndSet(false, true)) {
            try {
                McpLogEntryKt.writeLogEntry(this.logWriter, "Server stopped", McpLogEntryType.INFO);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logWriter.close();
        }
    }

    @Override
    public void mark(int readlimit) throws IOException {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }
}

