/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.listeners;

import com.intellij.ml.llm.nextEdits.listeners.CaretEventType;
import com.intellij.ml.llm.nextEdits.services.NextEditRequestService;
import com.intellij.ml.llm.nextEdits.session.NextEditSessionManager;
import com.intellij.ml.llm.nextEdits.settings.NextEditSettingsControllerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/nextEdits/listeners/NextEditCaretListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "<init>", "()V", "onCaretMovement", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "type", "Lcom/intellij/ml/llm/nextEdits/listeners/CaretEventType;", "caretAdded", "caretRemoved", "caretPositionChanged", "intellij.ml.llm.nextEdits"})
public final class NextEditCaretListener
implements CaretListener {
    private final void onCaretMovement(CaretEvent event, CaretEventType type2) {
        if (!NextEditSettingsControllerKt.getNextEditEnabled()) {
            return;
        }
        Editor editor2 = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        NextEditSessionManager nextEditSessionManager = NextEditSessionManager.Companion.getInstance(editor3);
        if (nextEditSessionManager != null) {
            nextEditSessionManager.onCaretEvent(type2);
        }
        Project project2 = editor3.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        NextEditRequestService.Companion.getInstance(project3).handleCaretEvent$intellij_ml_llm_nextEdits(event, type2);
    }

    public void caretAdded(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.onCaretMovement(event, CaretEventType.CARET_ADDED);
    }

    public void caretRemoved(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.onCaretMovement(event, CaretEventType.CARET_REMOVED);
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.onCaretMovement(event, CaretEventType.MOVEMENT);
    }
}

