/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.ui.display;

import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionEventsReporter;
import com.intellij.ml.llm.nextEdits.session.guarder.DocumentChangeGuardPurpose;
import com.intellij.ml.llm.nextEdits.session.guarder.Guarder;
import com.intellij.ml.llm.nextEdits.session.step.NextEditAdditionDiffModel;
import com.intellij.ml.llm.nextEdits.session.step.NextEditDeletionDiffModel;
import com.intellij.ml.llm.nextEdits.session.step.NextEditDiffModel;
import com.intellij.ml.llm.nextEdits.session.step.NextEditGeneralDiffModel;
import com.intellij.ml.llm.nextEdits.session.step.NextEditSessionStep;
import com.intellij.ml.llm.nextEdits.session.step.NextEditSimpleReplaceDiffModel;
import com.intellij.ml.llm.nextEdits.session.step.controller.NextEditActionControllerImpl;
import com.intellij.ml.llm.nextEdits.session.step.controller.NextEditDeletionDiffController;
import com.intellij.ml.llm.nextEdits.session.step.controller.NextEditDiffController;
import com.intellij.ml.llm.nextEdits.session.step.controller.NextEditGeneralDiffController;
import com.intellij.ml.llm.nextEdits.session.step.controller.NextEditSimpleReplaceDiffController;
import com.intellij.ml.llm.nextEdits.session.step.controller.NextEditStepController;
import com.intellij.ml.llm.nextEdits.session.step.controller.addition.NextEditAdditionDiffController;
import com.intellij.ml.llm.nextEdits.session.step.controller.addition.NextEditCompletionController;
import com.intellij.ml.llm.nextEdits.session.step.controller.addition.NextEditGreenAdditionDiffController;
import com.intellij.ml.llm.nextEdits.ui.NextEditMagicWand;
import com.intellij.ml.llm.nextEdits.ui.diff.NextEditJumpView;
import com.intellij.ml.llm.nextEdits.ui.display.NextEditBeforeDisplayInitializer;
import com.intellij.ml.llm.nextEdits.ui.display.NextEditDisplayIntrusionMode;
import com.intellij.ml.llm.nextEdits.ui.display.NextEditDisplayParameters;
import com.intellij.ml.llm.nextEdits.ui.display.NextEditDisplayState;
import com.intellij.ml.llm.nextEdits.ui.display.NextEditSuppressHighlightingOfElementUnderCaretInitializer;
import com.intellij.ml.llm.nextEdits.ui.display.NextEditUnfoldTextBeforeDisplay;
import com.intellij.ml.llm.nextEdits.ui.view.NextEditShortcutHintType;
import com.intellij.ml.llm.nextEdits.ui.view.NextEditStepDisplayer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0002:;B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020\bJ\u0006\u0010 \u001a\u00020\u0017J\b\u0010!\u001a\u00020\bH\u0002J \u0010\"\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010%\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010'\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u00102\u001a\u00020\u0017H\u0002J*\u00103\u001a\u0002H4\"\u0004\b\u0000\u001042\u0006\u00105\u001a\u0002H42\f\u00106\u001a\b\u0012\u0004\u0012\u0002H407H\u0082\b\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayManager;", "Lcom/intellij/openapi/Disposable;", "ignoreDocumentChangesGuarder", "Lcom/intellij/ml/llm/nextEdits/session/guarder/Guarder;", "Lcom/intellij/ml/llm/nextEdits/session/guarder/DocumentChangeGuardPurpose;", "onDisplayStateChanged", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayState;", "", "<init>", "(Lcom/intellij/ml/llm/nextEdits/session/guarder/Guarder;Lkotlin/jvm/functions/Function1;)V", "newState", "displayState", "getDisplayState", "()Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayState;", "setDisplayState", "(Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayState;)V", "phase", "Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayManager$Phase;", "beforeDisplayInitializers", "", "Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditBeforeDisplayInitializer;", "display", "", "displayParameters", "Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayParameters;", "intrusionMode", "Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayIntrusionMode;", "reporter", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionEventsReporter;", "undisplay", "suppress", "isDisplayInProgress", "doUndisplay", "displayJumpView", "stepController", "Lcom/intellij/ml/llm/nextEdits/session/step/controller/NextEditStepController;", "displayStepView", "tryDisplayNonIntrusiveDiffViewElseJumpView", "doDisplayStepView", "displayer", "Lcom/intellij/ml/llm/nextEdits/ui/view/NextEditStepDisplayer;", "getShortcutHintType", "Lcom/intellij/ml/llm/nextEdits/ui/view/NextEditShortcutHintType;", "controller", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "getStepController", "assertNoActiveRendering", "withUpdatingPhase", "T", "defaultValue", "action", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "dispose", "Phase", "Companion", "intellij.ml.llm.nextEdits"})
@SourceDebugExtension(value={"SMAP\nNextEditDisplayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditDisplayManager.kt\ncom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayManager\n+ 2 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,258:1\n222#1,10:259\n222#1,10:269\n222#1,10:279\n42#2:289\n14#3:290\n*S KotlinDebug\n*F\n+ 1 NextEditDisplayManager.kt\ncom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayManager\n*L\n62#1:259,10\n83#1:269,10\n87#1:279,10\n255#1:289\n255#1:290\n*E\n"})
public final class NextEditDisplayManager
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Guarder<DocumentChangeGuardPurpose> ignoreDocumentChangesGuarder;
    @NotNull
    private final Function1<NextEditDisplayState, Unit> onDisplayStateChanged;
    @NotNull
    private NextEditDisplayState displayState;
    @NotNull
    private Phase phase;
    @NotNull
    private final List<NextEditBeforeDisplayInitializer> beforeDisplayInitializers;
    @NotNull
    private static final MLCompletionLogger LOG;

    public NextEditDisplayManager(@NotNull Guarder<DocumentChangeGuardPurpose> ignoreDocumentChangesGuarder, @NotNull Function1<? super NextEditDisplayState, Unit> onDisplayStateChanged) {
        Intrinsics.checkNotNullParameter(ignoreDocumentChangesGuarder, (String)"ignoreDocumentChangesGuarder");
        Intrinsics.checkNotNullParameter(onDisplayStateChanged, (String)"onDisplayStateChanged");
        this.ignoreDocumentChangesGuarder = ignoreDocumentChangesGuarder;
        this.onDisplayStateChanged = onDisplayStateChanged;
        this.displayState = NextEditDisplayState.Empty.INSTANCE;
        this.phase = Phase.IDLE;
        Object[] objectArray = new NextEditBeforeDisplayInitializer[]{NextEditUnfoldTextBeforeDisplay.INSTANCE, NextEditSuppressHighlightingOfElementUnderCaretInitializer.INSTANCE};
        this.beforeDisplayInitializers = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final NextEditDisplayState getDisplayState() {
        return this.displayState;
    }

    private final void setDisplayState(NextEditDisplayState newState) {
        ThreadingAssertions.assertEventDispatchThread();
        if (!Intrinsics.areEqual((Object)newState, (Object)this.displayState)) {
            this.onDisplayStateChanged.invoke((Object)newState);
            this.displayState = newState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean display(@NotNull NextEditDisplayParameters displayParameters, @NotNull NextEditDisplayIntrusionMode intrusionMode, @NotNull NextEditSessionEventsReporter reporter) {
        boolean bl;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)displayParameters, (String)"displayParameters");
        Intrinsics.checkNotNullParameter((Object)((Object)intrusionMode), (String)"intrusionMode");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        NextEditDisplayManager nextEditDisplayManager = this;
        boolean defaultValue$iv = false;
        boolean $i$f$withUpdatingPhase = false;
        ThreadingAssertions.assertEventDispatchThread();
        if (!super.assertNoActiveRendering()) {
            bl = defaultValue$iv;
        } else {
            this_$iv.phase = Phase.UPDATING;
            try {
                boolean bl2 = false;
                this.doUndisplay();
                this.setDisplayState(switch (WhenMappings.$EnumSwitchMapping$0[intrusionMode.ordinal()]) {
                    case 1 -> this.displayStepView(displayParameters, reporter);
                    case 2 -> this.tryDisplayNonIntrusiveDiffViewElseJumpView(displayParameters, reporter);
                    case 3 -> {
                        NextEditStepController stepController = this.getStepController(displayParameters);
                        yield this.displayJumpView(displayParameters, stepController, reporter);
                    }
                    default -> throw new NoWhenBranchMatchedException();
                });
                boolean bl3 = !(this.displayState instanceof NextEditDisplayState.Empty);
                bl = bl3;
            }
            finally {
                this_$iv.phase = Phase.IDLE;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void undisplay() {
        void this_$iv;
        NextEditDisplayManager nextEditDisplayManager = this;
        Unit defaultValue$iv = Unit.INSTANCE;
        boolean $i$f$withUpdatingPhase = false;
        ThreadingAssertions.assertEventDispatchThread();
        if (super.assertNoActiveRendering()) {
            this_$iv.phase = Phase.UPDATING;
            try {
                boolean bl = false;
                this.doUndisplay();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.phase = Phase.IDLE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void suppress() {
        void this_$iv;
        NextEditDisplayManager nextEditDisplayManager = this;
        Unit defaultValue$iv = Unit.INSTANCE;
        boolean $i$f$withUpdatingPhase = false;
        ThreadingAssertions.assertEventDispatchThread();
        if (super.assertNoActiveRendering()) {
            this_$iv.phase = Phase.UPDATING;
            try {
                boolean bl = false;
                if (!(this.displayState instanceof NextEditDisplayState.Suppressed)) {
                    this.displayState.dispose();
                    this.setDisplayState(NextEditDisplayState.Suppressed.INSTANCE);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.phase = Phase.IDLE;
            }
        }
    }

    public final boolean isDisplayInProgress() {
        return switch (WhenMappings.$EnumSwitchMapping$1[this.phase.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void doUndisplay() {
        this.displayState.dispose();
        this.setDisplayState(NextEditDisplayState.Empty.INSTANCE);
    }

    private final NextEditDisplayState displayJumpView(NextEditDisplayParameters displayParameters, NextEditStepController stepController, NextEditSessionEventsReporter reporter) {
        TextRange editRange = new TextRange(displayParameters.getStartOffset(), Math.max(displayParameters.getEndOffset() - 1, displayParameters.getStartOffset()));
        NextEditJumpView jumpView = new NextEditJumpView(displayParameters.getEditor(), editRange);
        jumpView.show();
        reporter.onJumpShown();
        NextEditMagicWand.Companion.getInstance().display(displayParameters.getEditor(), jumpView);
        return new NextEditDisplayState.JumpShown(stepController, jumpView);
    }

    private final NextEditDisplayState displayStepView(NextEditDisplayParameters displayParameters, NextEditSessionEventsReporter reporter) {
        NextEditStepController stepController = this.getStepController(displayParameters);
        return this.doDisplayStepView(stepController, stepController.getDisplayer(), displayParameters, reporter);
    }

    private final NextEditDisplayState tryDisplayNonIntrusiveDiffViewElseJumpView(NextEditDisplayParameters displayParameters, NextEditSessionEventsReporter reporter) {
        NextEditStepController stepController = this.getStepController(displayParameters);
        NextEditStepDisplayer displayer = stepController.getDisplayer();
        if (displayer.isIntrusive(displayParameters.getEditor(), displayParameters.getProject())) {
            return this.displayJumpView(displayParameters, stepController, reporter);
        }
        return this.doDisplayStepView(stepController, displayer, displayParameters, reporter);
    }

    private final NextEditDisplayState doDisplayStepView(NextEditStepController stepController, NextEditStepDisplayer displayer, NextEditDisplayParameters displayParameters, NextEditSessionEventsReporter reporter) {
        Disposable disposable = Disposer.newDisposable((String)"[Next Edit] Step view");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable viewDisposable = disposable;
        for (NextEditBeforeDisplayInitializer initializer : this.beforeDisplayInitializers) {
            initializer.initialize(displayParameters, viewDisposable);
        }
        try {
            NextEditShortcutHintType hintType = this.getShortcutHintType(stepController, displayParameters.getEditor(), displayParameters.getProject());
            displayer.show(displayParameters.getEditor(), displayParameters.getProject(), hintType, viewDisposable);
            reporter.onDiffShown(displayParameters.getStartOffset(), displayParameters.getEndOffset());
            NextEditMagicWand.Companion.getInstance().display(displayParameters.getEditor(), viewDisposable);
            return new NextEditDisplayState.StepShown(stepController, viewDisposable);
        }
        catch (Throwable e) {
            Disposer.dispose((Disposable)viewDisposable);
            throw e;
        }
    }

    private final NextEditShortcutHintType getShortcutHintType(NextEditStepController controller2, Editor editor2, Project project2) {
        return switch (WhenMappings.$EnumSwitchMapping$2[controller2.getKeyHandlerType(editor2, project2).ordinal()]) {
            case 1 -> NextEditShortcutHintType.ACCEPT;
            case 2 -> NextEditShortcutHintType.JUMP;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final NextEditStepController getStepController(NextEditDisplayParameters displayParameters) {
        NextEditStepController nextEditStepController;
        NextEditSessionStep step = displayParameters.getStep();
        if (step instanceof NextEditSessionStep.Action) {
            nextEditStepController = new NextEditActionControllerImpl(((NextEditSessionStep.Action)step).getModel());
        } else if (step instanceof NextEditSessionStep.Diff) {
            NextEditDiffController nextEditDiffController;
            NextEditDiffModel diffModel = ((NextEditSessionStep.Diff)displayParameters.getStep()).getModel();
            if (diffModel instanceof NextEditAdditionDiffModel) {
                nextEditDiffController = NextEditAdditionDiffController.Companion.isCompletionApplicable(displayParameters.getEditor(), (NextEditAdditionDiffModel)diffModel) ? (NextEditAdditionDiffController)new NextEditCompletionController((NextEditAdditionDiffModel)diffModel, ((NextEditSessionStep.Diff)step).getHighlighting(), this.ignoreDocumentChangesGuarder) : (NextEditAdditionDiffController)new NextEditGreenAdditionDiffController((NextEditAdditionDiffModel)diffModel, ((NextEditSessionStep.Diff)step).getHighlighting());
            } else if (diffModel instanceof NextEditDeletionDiffModel) {
                nextEditDiffController = new NextEditDeletionDiffController((NextEditDeletionDiffModel)diffModel);
            } else if (diffModel instanceof NextEditGeneralDiffModel) {
                nextEditDiffController = new NextEditGeneralDiffController((NextEditGeneralDiffModel)diffModel, ((NextEditSessionStep.Diff)step).getFileType(), ((NextEditSessionStep.Diff)step).getHighlighting());
            } else if (diffModel instanceof NextEditSimpleReplaceDiffModel) {
                nextEditDiffController = new NextEditSimpleReplaceDiffController((NextEditSimpleReplaceDiffModel)diffModel, ((NextEditSessionStep.Diff)step).getFileType());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            nextEditStepController = nextEditDiffController;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return nextEditStepController;
    }

    private final boolean assertNoActiveRendering() {
        return switch (WhenMappings.$EnumSwitchMapping$1[this.phase.ordinal()]) {
            case 1 -> {
                LOG.error("Already rendering another diff. Cannot render a diff recursively.");
                yield false;
            }
            case 2 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withUpdatingPhase(T defaultValue, Function0<? extends T> action2) {
        boolean $i$f$withUpdatingPhase = false;
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.assertNoActiveRendering()) {
            return defaultValue;
        }
        this.phase = Phase.UPDATING;
        try {
            Object object = action2.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.phase = Phase.IDLE;
            InlineMarker.finallyEnd((int)1);
        }
    }

    public void dispose() {
        this.undisplay();
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new MLCompletionLogger(logger, MLCompletionLogger.FeatureType.NextEdit);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "intellij.ml.llm.nextEdits"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayManager$Phase;", "", "<init>", "(Ljava/lang/String;I)V", "UPDATING", "IDLE", "intellij.ml.llm.nextEdits"})
    public static final class Phase
    extends Enum<Phase> {
        public static final /* enum */ Phase UPDATING = new Phase();
        public static final /* enum */ Phase IDLE = new Phase();
        private static final /* synthetic */ Phase[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Phase[] values() {
            return (Phase[])$VALUES.clone();
        }

        public static Phase valueOf(String value2) {
            return Enum.valueOf(Phase.class, value2);
        }

        @NotNull
        public static EnumEntries<Phase> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = phaseArray = new Phase[]{Phase.UPDATING, Phase.IDLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[NextEditDisplayIntrusionMode.values().length];
            try {
                nArray[NextEditDisplayIntrusionMode.STEP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditDisplayIntrusionMode.NON_INTRUSIVE_STEP_OR_JUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditDisplayIntrusionMode.JUMP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Phase.values().length];
            try {
                nArray[Phase.UPDATING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Phase.IDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[NextEditStepController.KeyHandlerType.values().length];
            try {
                nArray[NextEditStepController.KeyHandlerType.ACCEPT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.KeyHandlerType.JUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

