/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.ui.util;

import com.intellij.ml.llm.nextEdits.language.NextEditSuggestionHighlighter;
import com.intellij.ml.llm.nextEdits.session.highlight.NextEditHighlightingInfo;
import com.intellij.ml.llm.nextEdits.ui.diff.EnrichedNextEditDiffPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J*\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fJ:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J(\u0010!\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002\u00a8\u0006*"}, d2={"Lcom/intellij/ml/llm/nextEdits/ui/util/NextEditComponentFactory;", "", "<init>", "()V", "createEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "disposable", "Lcom/intellij/openapi/Disposable;", "presentation", "Lcom/intellij/ml/llm/nextEdits/ui/diff/EnrichedNextEditDiffPresentation;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "fontSize", "", "indentToTrim", "customEditorBackground", "Ljava/awt/Color;", "additionalHighlighting", "Lcom/intellij/ml/llm/nextEdits/session/highlight/NextEditHighlightingInfo;", "createEmptyEditor", "createEmptyPanel", "Ljavax/swing/JComponent;", "dimension", "Ljava/awt/Dimension;", "widthInPixels", "heightInPixels", "editor", "Lcom/intellij/openapi/editor/Editor;", "heightInLines", "text", "", "createSimpleEditor", "renderLineSeparator", "", "lineNumber", "placement", "Lcom/intellij/openapi/editor/markup/SeparatorPlacement;", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "DeletionMarkerElementRenderer", "intellij.ml.llm.nextEdits"})
public final class NextEditComponentFactory {
    @NotNull
    public static final NextEditComponentFactory INSTANCE = new NextEditComponentFactory();

    private NextEditComponentFactory() {
    }

    @NotNull
    public final EditorEx createEditor(@NotNull Disposable disposable, @NotNull EnrichedNextEditDiffPresentation presentation2, @NotNull Project project2, @NotNull FileType fileType2, int fontSize, int indentToTrim, @Nullable Color customEditorBackground, @NotNull NextEditHighlightingInfo additionalHighlighting) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileType2, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)additionalHighlighting, (String)"additionalHighlighting");
        EditorEx editor2 = this.createEditor(disposable, project2, fileType2, presentation2.getText(), fontSize, customEditorBackground);
        block5: for (EnrichedNextEditDiffPresentation.Highlighting fragment : presentation2.getHighlightings()) {
            EnrichedNextEditDiffPresentation.Highlighting highlighting = fragment;
            if (highlighting instanceof EnrichedNextEditDiffPresentation.Highlighting.Ranged) {
                editor2.getMarkupModel().addRangeHighlighter(fragment.getAttributesKey(), ((EnrichedNextEditDiffPresentation.Highlighting.Ranged)fragment).getStartOffset(), ((EnrichedNextEditDiffPresentation.Highlighting.Ranged)fragment).getEndOffset(), 5001, HighlighterTargetArea.EXACT_RANGE);
                continue;
            }
            if (highlighting instanceof EnrichedNextEditDiffPresentation.Highlighting.Deletion) {
                DeletionMarkerElementRenderer renderer2 = new DeletionMarkerElementRenderer(((EnrichedNextEditDiffPresentation.Highlighting.Deletion)fragment).getAttributesKey());
                int lineNumber = editor2.getDocument().getLineNumber(((EnrichedNextEditDiffPresentation.Highlighting.Deletion)fragment).getOffset());
                switch (WhenMappings.$EnumSwitchMapping$0[((EnrichedNextEditDiffPresentation.Highlighting.Deletion)fragment).getType().ordinal()]) {
                    case 1: {
                        editor2.getInlayModel().addInlineElement(((EnrichedNextEditDiffPresentation.Highlighting.Deletion)fragment).getOffset(), true, (EditorCustomElementRenderer)renderer2);
                        continue block5;
                    }
                    case 2: {
                        this.renderLineSeparator((Editor)editor2, lineNumber, SeparatorPlacement.TOP, ((EnrichedNextEditDiffPresentation.Highlighting.Deletion)fragment).getAttributesKey());
                        continue block5;
                    }
                    case 3: {
                        this.renderLineSeparator((Editor)editor2, lineNumber, SeparatorPlacement.BOTTOM, ((EnrichedNextEditDiffPresentation.Highlighting.Deletion)fragment).getAttributesKey());
                        continue block5;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            throw new NoWhenBranchMatchedException();
        }
        for (NextEditSuggestionHighlighter.Highlighting highlighting : additionalHighlighting.getHighlightings()) {
            TextRange actualRange = new TextRange(Math.max(0, highlighting.getRange().getStartOffset()), Math.min(editor2.getDocument().getTextLength(), highlighting.getRange().getEndOffset()));
            if (actualRange.isEmpty()) continue;
            editor2.getMarkupModel().addRangeHighlighter(actualRange.getStartOffset(), actualRange.getEndOffset(), 5001, highlighting.getAttributes(), HighlighterTargetArea.EXACT_RANGE);
        }
        int n = editor2.getDocument().getLineCount();
        for (int line = 0; line < n; ++line) {
            int lineStart = editor2.getDocument().getLineStartOffset(line);
            int lineEnd = editor2.getDocument().getLineEndOffset(line);
            int prefixToTrim = Math.min(indentToTrim, lineEnd - lineStart);
            if (prefixToTrim <= 0) continue;
            editor2.getDocument().replaceString(lineStart, lineStart + prefixToTrim, (CharSequence)"");
        }
        return editor2;
    }

    public static /* synthetic */ EditorEx createEditor$default(NextEditComponentFactory nextEditComponentFactory, Disposable disposable, EnrichedNextEditDiffPresentation enrichedNextEditDiffPresentation, Project project2, FileType fileType2, int n, int n2, Color color, NextEditHighlightingInfo nextEditHighlightingInfo, int n3, Object object) {
        if ((n3 & 0x80) != 0) {
            nextEditHighlightingInfo = NextEditHighlightingInfo.Empty.INSTANCE;
        }
        return nextEditComponentFactory.createEditor(disposable, enrichedNextEditDiffPresentation, project2, fileType2, n, n2, color, nextEditHighlightingInfo);
    }

    @NotNull
    public final EditorEx createEmptyEditor(@NotNull Disposable disposable, @NotNull Project project2, int fontSize, @Nullable Color customEditorBackground) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        EnrichedNextEditDiffPresentation enrichedNextEditDiffPresentation = new EnrichedNextEditDiffPresentation("", CollectionsKt.emptyList());
        PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)plainTextFileType, (String)"INSTANCE");
        return NextEditComponentFactory.createEditor$default(this, disposable, enrichedNextEditDiffPresentation, project2, (FileType)plainTextFileType, fontSize, 0, customEditorBackground, null, 128, null);
    }

    public static /* synthetic */ EditorEx createEmptyEditor$default(NextEditComponentFactory nextEditComponentFactory, Disposable disposable, Project project2, int n, Color color, int n2, Object object) {
        if ((n2 & 8) != 0) {
            color = null;
        }
        return nextEditComponentFactory.createEmptyEditor(disposable, project2, n, color);
    }

    @NotNull
    public final JComponent createEmptyPanel(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        JPanel panel2 = new JPanel();
        panel2.setOpaque(false);
        panel2.setBackground(null);
        panel2.setPreferredSize(dimension);
        return panel2;
    }

    @NotNull
    public final JComponent createEmptyPanel(int widthInPixels, int heightInPixels) {
        return this.createEmptyPanel(new Dimension(widthInPixels, heightInPixels));
    }

    @NotNull
    public final JComponent createEmptyPanel(@NotNull Editor editor2, int widthInPixels, int heightInLines) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return this.createEmptyPanel(widthInPixels, editor2.getLineHeight() * heightInLines);
    }

    private final EditorEx createEditor(Disposable disposable, Project project2, FileType fileType2, String text2, int fontSize, Color customEditorBackground) {
        EditorSettings editorSettings;
        Editor editor2 = this.createSimpleEditor(disposable, project2, text2, fileType2);
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor3 = (EditorEx)editor2;
        EditorSettings $this$createEditor_u24lambda_u240 = editorSettings = editor3.getSettings();
        boolean bl = false;
        $this$createEditor_u24lambda_u240.setLineNumbersShown(false);
        $this$createEditor_u24lambda_u240.setCaretRowShown(false);
        $this$createEditor_u24lambda_u240.setLineMarkerAreaShown(false);
        $this$createEditor_u24lambda_u240.setFoldingOutlineShown(false);
        $this$createEditor_u24lambda_u240.setAdditionalColumnsCount(0);
        $this$createEditor_u24lambda_u240.setAdditionalLinesCount(0);
        $this$createEditor_u24lambda_u240.setRightMarginShown(false);
        $this$createEditor_u24lambda_u240.setUseSoftWraps(false);
        $this$createEditor_u24lambda_u240.setAdditionalPageAtBottom(false);
        Color color = customEditorBackground;
        if (color == null) {
            color = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
        }
        editor3.setBackgroundColor(color);
        editor3.getScrollPane().getVerticalScrollBar().setOpaque(false);
        editor3.getColorsScheme().setColor(EditorColors.LINE_NUMBER_ON_CARET_ROW_COLOR, editor3.getColorsScheme().getColor(EditorColors.LINE_NUMBERS_COLOR));
        editor3.getScrollingModel().disableAnimation();
        EditorSettings $this$createEditor_u24lambda_u241 = editorSettings = editor3.getGutterComponentEx();
        boolean bl2 = false;
        $this$createEditor_u24lambda_u241.setPaintBackground(false);
        editor3.setFontSize(fontSize);
        return editor3;
    }

    private final Editor createSimpleEditor(Disposable disposable, Project project2, String text2, FileType fileType2) {
        Document document2;
        EditorFactory factory = EditorFactory.getInstance();
        if (factory instanceof EditorFactoryImpl) {
            document2 = ((EditorFactoryImpl)factory).createDocument((CharSequence)text2, false, true);
        } else {
            Document document3 = factory.createDocument((CharSequence)text2);
            Intrinsics.checkNotNull((Object)document3);
            document2 = document3;
        }
        Document document4 = document2;
        Editor editor2 = factory.createEditor(document4, project2, fileType2, true);
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> NextEditComponentFactory.createSimpleEditor$lambda$2(factory, editor2));
        Intrinsics.checkNotNull((Object)editor2);
        return editor2;
    }

    private final void renderLineSeparator(Editor editor2, int lineNumber, SeparatorPlacement placement, TextAttributesKey attributesKey) {
        int lineStart = editor2.getDocument().getLineStartOffset(lineNumber);
        int lineEnd = editor2.getDocument().getLineEndOffset(lineNumber);
        RangeHighlighter rangeHighlighter = editor2.getMarkupModel().addRangeHighlighter(null, lineStart, lineEnd, 1000, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter rangeHighlighter2 = rangeHighlighter;
        TextAttributes textAttributes = editor2.getColorsScheme().getAttributes(attributesKey);
        rangeHighlighter2.setLineSeparatorColor(textAttributes != null ? textAttributes.getBackgroundColor() : null);
        rangeHighlighter2.setLineSeparatorPlacement(placement);
    }

    private static final Unit createSimpleEditor$lambda$2(EditorFactory $factory, Editor $editor) {
        $factory.releaseEditor($editor);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J,\u0010\n\u001a\u00020\u000b2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/nextEdits/ui/util/NextEditComponentFactory$DeletionMarkerElementRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "<init>", "(Lcom/intellij/openapi/editor/colors/TextAttributesKey;)V", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "paint", "", "g", "Ljava/awt/Graphics2D;", "targetRegion", "Ljava/awt/geom/Rectangle2D;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.ml.llm.nextEdits"})
    private static final class DeletionMarkerElementRenderer
    implements EditorCustomElementRenderer {
        @NotNull
        private final TextAttributesKey attributesKey;

        public DeletionMarkerElementRenderer(@NotNull TextAttributesKey attributesKey) {
            Intrinsics.checkNotNullParameter((Object)attributesKey, (String)"attributesKey");
            this.attributesKey = attributesKey;
        }

        public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return 2;
        }

        public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics2D g, @NotNull Rectangle2D targetRegion, @NotNull TextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            Object object = inlay.getEditor().getColorsScheme().getAttributes(this.attributesKey);
            if (object == null || (object = object.getBackgroundColor()) == null) {
                return;
            }
            g.setColor((Color)object);
            g.fill(targetRegion);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EnrichedNextEditDiffPresentation.Highlighting.Deletion.Type.values().length];
            try {
                nArray[EnrichedNextEditDiffPresentation.Highlighting.Deletion.Type.INLINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedNextEditDiffPresentation.Highlighting.Deletion.Type.LINE_ABOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedNextEditDiffPresentation.Highlighting.Deletion.Type.LINE_BELOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

