/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.ui.parser;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.ExternalPrivacyWrapper;
import com.intellij.ml.llm.privacy.extensions.vfs.VirtualFilePrivacyWrapper;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/privacy/ui/parser/DefaultMutableTreeNodePrivacyWrapper;", "Lcom/intellij/ml/llm/privacy/extensions/ExternalPrivacyWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "obj", "Ljavax/swing/tree/DefaultMutableTreeNode;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultMutableTreeNode;)V", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "promiseChange", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "intellij.ml.llm.privacy"})
public final class DefaultMutableTreeNodePrivacyWrapper
extends ExternalPrivacyWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final DefaultMutableTreeNode obj;

    public DefaultMutableTreeNodePrivacyWrapper(@NotNull Project project2, @NotNull DefaultMutableTreeNode obj) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        this.project = project2;
        this.obj = obj;
    }

    @Nullable
    public final PSString text() {
        Object object;
        Object userObject = this.obj.getUserObject();
        Object object2 = userObject;
        if (object2 instanceof ProjectViewNode) {
            VirtualFile file = ((ProjectViewNode)userObject).getVirtualFile();
            if (file != null && PrivacyPathCheckerKt.isAiIgnoreBlocked(this.project, file)) {
                return null;
            }
            Object object3 = userObject;
            Object object4 = object3 instanceof PresentableNodeDescriptor ? (PresentableNodeDescriptor)object3 : null;
            if (object4 == null || (object4 = object4.getPresentation()) == null || (object4 = object4.getPresentableText()) == null) {
                String string = ((ProjectViewNode)userObject).toString();
                object4 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            }
            object = this.promisedSafety((String)object4);
        } else if (object2 instanceof ChangeListChange) {
            Change change = ((ChangeListChange)userObject).getChange();
            object = this.promiseChange(change);
        } else if (object2 instanceof Change) {
            object = this.promiseChange((Change)userObject);
        } else if (object2 instanceof ShelvedWrapper) {
            FilePath filePath = ((ShelvedWrapper)userObject).getOriginalFilePath();
            if (filePath != null && PrivacyPathCheckerKt.isAiIgnoreBlocked(this.project, filePath)) {
                return null;
            }
            String string = ((ShelvedWrapper)userObject).getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            object = this.promisedSafety(string);
        } else if (object2 instanceof Module) {
            object = ((Module)userObject).getModuleFile();
            if (object == null || (object = ExtensionsKtKt.getPrivacySafe((VirtualFile)object)) == null || (object = ((VirtualFilePrivacyWrapper)((Object)object)).getName()) == null) {
                object = ConstantsKt.getPrivacyConst((String)"module");
            }
        } else if (object2 instanceof FilePath) {
            if (PrivacyPathCheckerKt.isAiIgnoreBlocked(this.project, (FilePath)userObject)) {
                return null;
            }
            String string = VcsUtil.getPresentablePath((Project)this.project, (FilePath)((FilePath)userObject), (boolean)true, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentablePath(...)");
            object = this.promisedSafety(string);
        } else if (object2 instanceof ChangeList) {
            String string = ((ChangeList)userObject).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            object = this.promisedSafety(string);
        } else {
            object = object2 instanceof ChangesBrowserNode.Tag ? this.promisedSafety(userObject.toString()) : ConstantsKt.getEMPTY();
        }
        return object;
    }

    private final PSString promiseChange(Change change) {
        String string;
        VirtualFile file;
        VirtualFile virtualFile2;
        Object object = change.getVirtualFile();
        if (object == null) {
            ContentRevision contentRevision;
            ContentRevision contentRevision2 = change.getBeforeRevision();
            object = contentRevision2 != null ? contentRevision2.getFile() : null;
            if (object == null && ((contentRevision = change.getAfterRevision()) != null && (contentRevision = contentRevision.getFile()) != null ? contentRevision.getVirtualFile() : (object = null)) == null) {
                return null;
            }
        }
        if ((virtualFile2 = (file = object)) instanceof VirtualFile ? PrivacyPathCheckerKt.isAiIgnoreBlocked(this.project, file) : virtualFile2 instanceof FilePath && PrivacyPathCheckerKt.isAiIgnoreBlocked(this.project, (FilePath)file)) {
            return null;
        }
        String status = change.getFileStatus().toString();
        VirtualFile virtualFile3 = file;
        if (virtualFile3 instanceof VirtualFile) {
            string = VcsUtil.getPresentablePath((Project)this.project, (VirtualFile)file, (boolean)true, (boolean)true);
        } else if (virtualFile3 instanceof FilePath) {
            string = VcsUtil.getPresentablePath((Project)this.project, (FilePath)((FilePath)file), (boolean)true, (boolean)true);
        } else {
            return null;
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String path = string2;
        String string3 = status.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return this.promisedSafety(string3 + ": " + path);
    }
}

