/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.Language;
import com.intellij.ml.llm.core.statistics.CommonLoggerService;
import com.intellij.ml.llm.core.statistics.CompositeStatisticsIdeActivity;
import com.intellij.ml.llm.core.statistics.ScoreResult;
import com.intellij.ml.llm.refactorings.LlmLookupManagerListener;
import com.intellij.ml.llm.refactorings.LlmLookupPopulationService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdHotspotRangeUpdate;
import com.jetbrains.rd.ide.model.RdHotspotRangesUpdate;
import com.jetbrains.rd.ide.model.RdHotspotRangesUpdateBase;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.liveTemplates.FrontendRdHotspotRangesUpdateReceivedListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/rider/RdHotspotHighlighterTracker;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/jetbrains/rdclient/liveTemplates/FrontendRdHotspotRangesUpdateReceivedListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "hotspotRanges", "", "Lcom/jetbrains/rd/ide/model/RdHotspotRangeUpdate;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "lastLookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "onChange", "", "item", "Lcom/jetbrains/rd/ide/model/RdHotspotRangesUpdateBase;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "dispose", "Startup", "intellij.ml.llm.rider"})
@SourceDebugExtension(value={"SMAP\nRdHotspotHighlighterTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdHotspotHighlighterTracker.kt\ncom/intellij/ml/llm/rider/RdHotspotHighlighterTracker\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,96:1\n30#2,2:97\n*S KotlinDebug\n*F\n+ 1 RdHotspotHighlighterTracker.kt\ncom/intellij/ml/llm/rider/RdHotspotHighlighterTracker\n*L\n68#1:97,2\n*E\n"})
public final class RdHotspotHighlighterTracker
extends LifetimedService
implements FrontendRdHotspotRangesUpdateReceivedListener {
    @NotNull
    private final Project project;
    @NotNull
    private List<RdHotspotRangeUpdate> hotspotRanges;
    @Nullable
    private MessageBusConnection connection;
    @Nullable
    private LookupImpl lastLookup;

    /*
     * WARNING - void declaration
     */
    public RdHotspotHighlighterTracker(@NotNull Project project2) {
        void $this$_init__u24lambda_u240;
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.hotspotRanges = CollectionsKt.emptyList();
        MessageBus messageBus = this.project.getMessageBus();
        Intrinsics.checkNotNull((Object)((Object)this), (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
        MessageBusConnection messageBusConnection2 = messageBusConnection = messageBus.connect((Disposable)this);
        RdHotspotHighlighterTracker rdHotspotHighlighterTracker = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.subscribe(FrontendRdHotspotRangesUpdateReceivedListener.Companion.getTOPIC(), (Object)this);
        rdHotspotHighlighterTracker.connection = messageBusConnection;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void onChange(@NotNull RdHotspotRangesUpdateBase item, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!(item instanceof RdHotspotRangesUpdate)) {
            return;
        }
        RdDocumentId documentId = ((RdHotspotRangesUpdate)item).getActiveRange().getDocumentId();
        LookupManager lookupManager = LookupManager.getInstance((Project)this.project);
        LookupEx lookupEx = lookupManager.getActiveLookup();
        LookupImpl lookupImpl = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
        if (lookupImpl == null) {
            return;
        }
        LookupImpl activeLookup = lookupImpl;
        if (Intrinsics.areEqual((Object)activeLookup, (Object)this.lastLookup)) {
            return;
        }
        this.lastLookup = activeLookup;
        PsiFile psiFile = activeLookup.getPsiFile();
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null || (psiFile2 = psiFile2.getVirtualFile()) == null) {
            return;
        }
        PsiFile vFile = psiFile2;
        Document document2 = VirtualFileUtil.findDocument((VirtualFile)vFile);
        if (!Intrinsics.areEqual((Object)(document2 != null ? DocumentExKt.getDocumentId((Document)document2, (Project)this.project) : null), (Object)documentId)) {
            return;
        }
        Editor editor2 = activeLookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        CommonLoggerService loggerService = CommonLoggerService.Companion.getInstance();
        Language language = psiFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        CompositeStatisticsIdeActivity statistic = loggerService.logNameSuggestionStarted(this.project, null, language2);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<LlmLookupPopulationService> serviceClass$iv = LlmLookupPopulationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        LlmLookupPopulationService llmLookupPopulationService = (LlmLookupPopulationService)object;
        Editor editor4 = activeLookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor4, (String)"getEditor(...)");
        Job populationJob = llmLookupPopulationService.populateLookup(this.project, activeLookup, editor4, statistic);
        activeLookup.addLookupListener(new LookupListener(populationJob, loggerService, statistic, language2, editor3, psiFile){
            final /* synthetic */ Job $populationJob;
            final /* synthetic */ CommonLoggerService $loggerService;
            final /* synthetic */ CompositeStatisticsIdeActivity $statistic;
            final /* synthetic */ Language $language;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PsiFile $psiFile;
            {
                this.$populationJob = $populationJob;
                this.$loggerService = $loggerService;
                this.$statistic = $statistic;
                this.$language = $language;
                this.$editor = $editor;
                this.$psiFile = $psiFile;
            }

            public void itemSelected(LookupEvent event) {
                String lookupString;
                LookupElement item;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Job.DefaultImpls.cancel$default((Job)this.$populationJob, null, (int)1, null);
                LookupElement lookupElement = item = event.getItem();
                String string = lookupString = lookupElement != null ? lookupElement.getLookupString() : null;
                if (item instanceof LlmLookupManagerListener.LlmLookupElement) {
                    this.$loggerService.logNameSuggestionFinished(this.$statistic, lookupString, ScoreResult.YES, null, this.$language);
                    ((LlmLookupManagerListener.LlmLookupElement)item).handleInsert(this.$editor);
                } else {
                    this.$loggerService.logNameSuggestionFinished(this.$statistic, lookupString, ScoreResult.NO, null, this.$language);
                }
            }

            public void lookupCanceled(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Job.DefaultImpls.cancel$default((Job)this.$populationJob, null, (int)1, null);
                this.$loggerService.logNameSuggestionFinished(this.$statistic, null, ScoreResult.NO, this.$psiFile.getClass(), this.$language);
            }
        });
    }

    public void dispose() {
        MessageBusConnection messageBusConnection = this.connection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.connection = null;
        this.hotspotRanges = CollectionsKt.emptyList();
        super.dispose();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/rider/RdHotspotHighlighterTracker$Startup;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.rider"})
    @SourceDebugExtension(value={"SMAP\nRdHotspotHighlighterTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdHotspotHighlighterTracker.kt\ncom/intellij/ml/llm/rider/RdHotspotHighlighterTracker$Startup\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,96:1\n30#2,2:97\n*S KotlinDebug\n*F\n+ 1 RdHotspotHighlighterTracker.kt\ncom/intellij/ml/llm/rider/RdHotspotHighlighterTracker$Startup\n*L\n43#1:97,2\n*E\n"})
    public static final class Startup
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<RdHotspotHighlighterTracker> serviceClass$iv = RdHotspotHighlighterTracker.class;
            if ($this$service$iv.getService(serviceClass$iv) == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return Unit.INSTANCE;
        }
    }
}

