/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider;

import com.intellij.lang.Language;
import com.intellij.ml.llm.core.chat.snippets.CodeSnippetProvider;
import com.intellij.ml.llm.rider.ReSharperCodeSnippetProviderKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.AbstractSandboxInfo;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdFileDocumentId;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.lang.ProtocolLanguageManager;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.editors.RiderTextControlHost;
import com.jetbrains.rider.editors.sandboxes.SandboxManager;
import com.jetbrains.rider.model.ExtraInfo;
import com.jetbrains.rider.model.SandboxInfo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\tH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/rider/ReSharperCodeSnippetProvider;", "Lcom/intellij/ml/llm/core/chat/snippets/CodeSnippetProvider;", "<init>", "()V", "isApplicableLanguage", "", "language", "Lcom/intellij/lang/Language;", "tryCreateEditor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "trySelectAppropriateContext", "Lcom/jetbrains/rd/ide/model/RdFileDocumentId;", "targetLanguage", "getProjectFilesByType", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "tryFinalizeEditor", "", "editor", "Companion", "intellij.ml.llm.rider"})
@SourceDebugExtension(value={"SMAP\nReSharperCodeSnippetProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperCodeSnippetProvider.kt\ncom/intellij/ml/llm/rider/ReSharperCodeSnippetProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class ReSharperCodeSnippetProvider
implements CodeSnippetProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String START_MARKER = "<RESHARPER_CODE_TO_SHOW_START>";
    @NotNull
    public static final String END_MARKER = "<RESHARPER_CODE_TO_SHOW_END>";

    private final boolean isApplicableLanguage(Language language) {
        if (language == null) {
            return false;
        }
        ProtocolLanguageManager protocolLanguageManager = ProtocolLanguageManager.Companion.getInstance();
        return protocolLanguageManager != null ? protocolLanguageManager.isProtocolLanguage(language) : false;
    }

    @Nullable
    public Editor tryCreateEditor(@NotNull Project project2, @NotNull Document document2, @NotNull Language language) {
        Object[] codeRange;
        String[] range;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!this.isApplicableLanguage(language)) {
            return null;
        }
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text2 = string;
        int codeToShowStart = StringsKt.indexOf$default((CharSequence)text2, (String)START_MARKER, (int)0, (boolean)false, (int)6, null);
        int codeToShowEnd = StringsKt.indexOf$default((CharSequence)text2, (String)END_MARKER, (int)0, (boolean)false, (int)6, null);
        if (codeToShowStart != -1 && codeToShowEnd != -1) {
            String fullCode;
            String string2 = fullCode = text2;
            int n = codeToShowEnd + 28;
            string2 = fullCode = ((Object)StringsKt.removeRange((CharSequence)string2, (int)codeToShowEnd, (int)n)).toString();
            n = codeToShowStart + 30;
            fullCode = ((Object)StringsKt.removeRange((CharSequence)string2, (int)codeToShowStart, (int)n)).toString();
            range = new RdTextRange(codeToShowStart, codeToShowEnd - 30);
            String string3 = fullCode;
            int n2 = range.getStartOffset();
            int n3 = range.getEndOffset();
            String string4 = string3.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            codeRange = string4;
            ApplicationKt.getApplication().runWriteAction(() -> ReSharperCodeSnippetProvider.tryCreateEditor$lambda$1(project2, document2, (String)codeRange));
            document2.putUserData(ReSharperCodeSnippetProviderKt.getRESHARPER_CODE_RANGE_KEY(), (Object)range);
            document2.putUserData(ReSharperCodeSnippetProviderKt.getRESHARPER_CODE_KEY(), (Object)fullCode);
        }
        range = new String[]{"mscorlib", "System", "System.Core", "Microsoft.CSharp", "System.ValueTuple"};
        List modules = CollectionsKt.listOf((Object[])range);
        codeRange = new String[]{"System", "System.IO", "System.Collections.Generic", "System.Console", "System.Dynamic", "System.Linq", "System.Linq.Expressions", "System.Text", "System.Threading.Tasks"};
        List imports = CollectionsKt.listOf((Object[])codeRange);
        String string5 = (String)document2.getUserData(ReSharperCodeSnippetProviderKt.getRESHARPER_CODE_KEY());
        if (string5 == null) {
            String string6 = document2.getText();
            string5 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
        }
        String fullCode = string5;
        RdTextRange rdTextRange = (RdTextRange)document2.getUserData(ReSharperCodeSnippetProviderKt.getRESHARPER_CODE_RANGE_KEY());
        if (rdTextRange == null) {
            rdTextRange = new RdTextRange(0, document2.getTextLength());
        }
        RdTextRange range2 = rdTextRange;
        RdFileDocumentId documentId = this.trySelectAppropriateContext(project2, language);
        ExtraInfo extraInfo = new ExtraInfo(imports, CollectionsKt.emptyList());
        List list = CollectionsKt.emptyList();
        RdLanguage rdLanguage = ProtocolLanguageManagerKt.toRdLanguageOrThrow((Language)language);
        List list2 = CollectionsKt.emptyList();
        SandboxInfo sandboxSource = new SandboxInfo("ChatCodeSnippet", (RdDocumentId)documentId, fullCode, range2, true, extraInfo, modules, true, list, rdLanguage, false, null, true, list2);
        SandboxManager.Companion.getInstance().markAsSandbox(document2, (AbstractSandboxInfo)sandboxSource);
        Editor editor2 = EditorFactory.getInstance().createViewer(document2, project2);
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        return (Editor)((EditorEx)editor2);
    }

    private final RdFileDocumentId trySelectAppropriateContext(Project project2, Language targetLanguage) {
        PsiFile focusedPsiFile;
        VirtualFile focusedFile;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor();
        Object object = focusedFile = fileEditor != null ? fileEditor.getFile() : null;
        if (focusedFile != null && (focusedPsiFile = VirtualFileUtil.findPsiFile((VirtualFile)focusedFile, (Project)project2)) != null && (focusedPsiFile.getLanguage().isKindOf(targetLanguage) || targetLanguage.isKindOf(focusedPsiFile.getLanguage()))) {
            return com.jetbrains.rd.ide.document.DocumentExKt.createDocumentId((VirtualFile)focusedFile);
        }
        LanguageFileType languageFileType = targetLanguage.getAssociatedFileType();
        if (languageFileType == null) {
            return null;
        }
        LanguageFileType associatedFileType = languageFileType;
        Collection<VirtualFile> matchingLanguageFiles = this.getProjectFilesByType(project2, (FileType)associatedFileType);
        VirtualFile virtualFile2 = (VirtualFile)CollectionsKt.firstOrNull((Iterable)matchingLanguageFiles);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            return com.jetbrains.rd.ide.document.DocumentExKt.createDocumentId((VirtualFile)it);
        }
        if (focusedFile != null && (virtualFile2 = com.jetbrains.rd.ide.document.DocumentExKt.createDocumentId((VirtualFile)focusedFile)) != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @NotNull
    public final Collection<VirtualFile> getProjectFilesByType(@NotNull Project project2, @NotNull FileType fileType2) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileType2, (String)"fileType");
        Ref.ObjectRef files = new Ref.ObjectRef();
        DumbService.Companion.getInstance(project2).runReadActionInSmartMode(() -> ReSharperCodeSnippetProvider.getProjectFilesByType$lambda$4(files, fileType2, project2));
        if (files.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"files");
            collection = null;
        } else {
            collection = (Collection)files.element;
        }
        return collection;
    }

    public void tryFinalizeEditor(@NotNull Project project2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!this.isApplicableLanguage(DocumentUtilKt.getLanguage((Editor)editor2))) {
            return;
        }
        if (DocumentExKt.getTextControlId((Editor)editor2) != null) {
            return;
        }
        FrontendTextControlHost frontendTextControlHost = FrontendTextControlHost.Companion.getInstance(project2);
        Intrinsics.checkNotNull((Object)frontendTextControlHost, (String)"null cannot be cast to non-null type com.jetbrains.rider.editors.RiderTextControlHost");
        RiderTextControlHost textControlHost = (RiderTextControlHost)frontendTextControlHost;
        textControlHost.bindEditor(editor2);
    }

    private static final void tryCreateEditor$lambda$1$lambda$0(Document $document, String $codeRange) {
        $document.setReadOnly(false);
        $document.setText((CharSequence)$codeRange);
        $document.setReadOnly(true);
    }

    private static final void tryCreateEditor$lambda$1(Project $project, Document $document, String $codeRange) {
        WriteCommandAction.writeCommandAction((Project)$project).run(() -> ReSharperCodeSnippetProvider.tryCreateEditor$lambda$1$lambda$0($document, $codeRange));
    }

    private static final void getProjectFilesByType$lambda$4(Ref.ObjectRef $files, FileType $fileType, Project $project) {
        Collection collection = FileTypeIndex.getFiles((FileType)$fileType, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)$project));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
        $files.element = collection;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/rider/ReSharperCodeSnippetProvider$Companion;", "", "<init>", "()V", "START_MARKER", "", "END_MARKER", "intellij.ml.llm.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

