/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.chat.context;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.ui.DatabaseSchemaSelectionTree;
import com.intellij.database.view.ui.DatabaseSchemaSelectionTreeKt;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatContextViewModel;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.sql.SqlLLMBundle;
import com.intellij.ml.llm.sql.chat.context.SqlObjectContextAttachment;
import com.intellij.ml.llm.sql.chat.context.UtilsKt$findDataSourceNode$;
import com.intellij.ml.llm.sql.consent.ConsentKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"getCurrentContext", "Lkotlin/Pair;", "Lcom/intellij/database/psi/DbDataSource;", "Lcom/intellij/database/model/basic/BasicSchema;", "file", "Lcom/intellij/sql/psi/SqlFile;", "getSchema", "dataSource", "path", "Lcom/intellij/database/util/ObjectPath;", "getConsoleSchema", "getSomeImportedSchema", "findDataSourceNode", "Lcom/intellij/database/model/DasDataSource;", "selected", "Ljavax/swing/tree/DefaultMutableTreeNode;", "createSchemaContextPopupComponent", "Lcom/intellij/openapi/ui/popup/JBPopup;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/AIChatContextViewModel;", "intellij.ml.llm.sql"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncom/intellij/ml/llm/sql/chat/context/UtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,87:1\n477#2:88\n*S KotlinDebug\n*F\n+ 1 utils.kt\ncom/intellij/ml/llm/sql/chat/context/UtilsKt\n*L\n59#1:88\n*E\n"})
public final class UtilsKt {
    @Nullable
    public static final Pair<DbDataSource, BasicSchema> getCurrentContext(@NotNull SqlFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List list = SqlImplUtil.getDataSources((PsiElement)((PsiElement)file));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        DbDataSource dbDataSource = (DbDataSource)CollectionsKt.singleOrNull((List)list);
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dataSource = dbDataSource;
        BasicSchema basicSchema = UtilsKt.getConsoleSchema(dataSource, file);
        if (basicSchema == null && (basicSchema = UtilsKt.getSomeImportedSchema(dataSource, file)) == null) {
            return null;
        }
        BasicSchema schema = basicSchema;
        return TuplesKt.to((Object)dataSource, (Object)schema);
    }

    private static final BasicSchema getSchema(DbDataSource dataSource, ObjectPath path) {
        DasModel dasModel = dataSource.getModel();
        BasicModel basicModel = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (basicModel == null) {
            return null;
        }
        BasicModel model = basicModel;
        Object object = QNameUtil.findByPath((DasModel)((DasModel)model), (ObjectPath)path).first();
        return object instanceof BasicSchema ? (BasicSchema)object : null;
    }

    private static final BasicSchema getConsoleSchema(DbDataSource dataSource, SqlFile file) {
        JdbcConsole jdbcConsole = JdbcConsoleProvider.getValidConsole((Project)file.getProject(), (VirtualFile)file.getVirtualFile());
        if (jdbcConsole == null) {
            return null;
        }
        JdbcConsole console = jdbcConsole;
        return UtilsKt.getSchema(dataSource, console.getCurrentNamespace());
    }

    private static final BasicSchema getSomeImportedSchema(DbDataSource dataSource, SqlFile file) {
        SqlImportState sqlImportState = SqlDialectImplUtilCore.getImportCheckerAt((SqlFile)file, null);
        Intrinsics.checkNotNullExpressionValue((Object)sqlImportState, (String)"getImportCheckerAt(...)");
        SqlImportState checker = sqlImportState;
        JBIterable jBIterable = DasUtil.getSchemas((DasDataSource)((DasDataSource)dataSource)).filter(BasicSchema.class).filter(arg_0 -> UtilsKt.getSomeImportedSchema$lambda$1(arg_0 -> UtilsKt.getSomeImportedSchema$lambda$0(checker, dataSource, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return (BasicSchema)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
    }

    private static final DasDataSource findDataSourceNode(DefaultMutableTreeNode selected) {
        Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)selected, UtilsKt::findDataSourceNode$lambda$2), UtilsKt::findDataSourceNode$lambda$3);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findDataSourceNode$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (DasDataSource)SequencesKt.firstOrNull((Sequence)sequence);
    }

    @NotNull
    public static final JBPopup createSchemaContextPopupComponent(@NotNull Project project2, @NotNull AIChatContextViewModel model) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        DatabaseSchemaSelectionTree tree = new DatabaseSchemaSelectionTree(project2, SetsKt.emptySet(), false, null, 12, null);
        return DatabaseSchemaSelectionTreeKt.createPopup((DatabaseSchemaSelectionTree)tree, UtilsKt::createSchemaContextPopupComponent$lambda$4, () -> UtilsKt.createSchemaContextPopupComponent$lambda$6(tree, project2, model));
    }

    private static final boolean getSomeImportedSchema$lambda$0(SqlImportState $checker, DbDataSource $dataSource, BasicSchema schema) {
        return $checker.isImported((DasDataSource)$dataSource, (DasObject)schema);
    }

    private static final boolean getSomeImportedSchema$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final DefaultMutableTreeNode findDataSourceNode$lambda$2(DefaultMutableTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TreeNode treeNode = it.getParent();
        return treeNode instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)treeNode : null;
    }

    private static final Object findDataSourceNode$lambda$3(DefaultMutableTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUserObject();
    }

    private static final boolean createSchemaContextPopupComponent$lambda$4(DefaultMutableTreeNode it) {
        Object obj = it.getUserObject();
        return !(obj instanceof DasDataSource) && !(obj instanceof BasicDatabase);
    }

    private static final Unit createSchemaContextPopupComponent$lambda$6(DatabaseSchemaSelectionTree $tree, Project $project, AIChatContextViewModel $model) {
        DefaultMutableTreeNode selected;
        Object[] objectArray = $tree.getTree().getSelectedNodes(DefaultMutableTreeNode.class, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSelectedNodes(...)");
        DefaultMutableTreeNode defaultMutableTreeNode = selected = (DefaultMutableTreeNode)ArraysKt.singleOrNull((Object[])objectArray);
        Object object = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
        BasicSchema basicSchema = object instanceof BasicSchema ? (BasicSchema)object : null;
        if (basicSchema == null) {
            boolean bl = false;
            new Notification("AI notification group", SqlLLMBundle.message("notification.title.cannot.attach.element", new Object[0]), SqlLLMBundle.message("notification.content.please.select.schema.object", new Object[0]), NotificationType.INFORMATION).notify($project);
            return Unit.INSTANCE;
        }
        BasicSchema schema = basicSchema;
        String string = schema.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!ConsentKt.canAttachSchema($project, string)) {
            return Unit.INSTANCE;
        }
        DasDataSource dasDataSource = UtilsKt.findDataSourceNode(selected);
        if (dasDataSource == null) {
            return Unit.INSTANCE;
        }
        DasDataSource dataSource = dasDataSource;
        $model.addContextItem((ContextAttachment)new SqlObjectContextAttachment($project, dataSource, (BasicElement)schema, null, 8, null));
        return Unit.INSTANCE;
    }
}

