/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.selfReview.agent.model;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.ml.llm.core.chat.messages.ChatMessageRating;
import com.intellij.ml.llm.vcs.LLMVcsBundle;
import com.intellij.ml.llm.vcs.selfReview.VcsAISelfReviewCollector;
import com.intellij.ml.llm.vcs.selfReview.agent.VcsAISelfReviewAgent;
import com.intellij.ml.llm.vcs.selfReview.agent.VcsAISelfReviewStateHandler;
import com.intellij.ml.llm.vcs.selfReview.agent.model.VcsAISelfReviewRequest;
import com.intellij.ml.llm.vcs.selfReview.agent.model.VcsAISelfReviewResult;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.changes.Change;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u00011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\u001c\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\"H\u0016J\u0012\u0010&\u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0018\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u000fH\u0002J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u000fH\u0002J\u0014\u0010.\u001a\u00020\u001e2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013J\b\u00100\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0016\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/VcsAISelfReviewStateHandler;", "project", "Lcom/intellij/openapi/project/Project;", "initialRequest", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;)V", "rating", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;", "getRating$intellij_ml_llm_vcs", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "latestRequest", "state", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State;", "getState", "problems", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult$Problem;", "getProblems", "()Lkotlinx/coroutines/flow/StateFlow;", "changes", "Lcom/intellij/openapi/vcs/changes/Change;", "getChanges", "runningReviewActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "getCurrentRequest", "setErrorState", "", "e", "", "partialReview", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "setPartialReviewState", "setFullReviewState", "fullReview", "setCancelledState", "setFiltersAppliedState", "filterName", "", "", "setNewState", "newState", "logReviewActivity", "requestAnalysis", "includedChanges", "cancelAnalysis", "State", "intellij.ml.llm.vcs"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsAISelfReviewViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsAISelfReviewViewModel.kt\ncom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n230#2,5:144\n214#2,5:149\n214#2,5:154\n30#3,2:159\n1#4:161\n*S KotlinDebug\n*F\n+ 1 VcsAISelfReviewViewModel.kt\ncom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel\n*L\n74#1:144,5\n80#1:149,5\n90#1:154,5\n102#1:159,2\n*E\n"})
public final class VcsAISelfReviewViewModel
implements VcsAISelfReviewStateHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final MutableStateFlow<ChatMessageRating> rating;
    @NotNull
    private final MutableStateFlow<VcsAISelfReviewRequest> latestRequest;
    @NotNull
    private final MutableStateFlow<State> state;
    @NotNull
    private final StateFlow<List<VcsAISelfReviewResult.Problem>> problems;
    @NotNull
    private final StateFlow<List<Change>> changes;
    @NotNull
    private final MutableStateFlow<StructuredIdeActivity> runningReviewActivity;

    public VcsAISelfReviewViewModel(@NotNull Project project2, @NotNull VcsAISelfReviewRequest initialRequest) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)initialRequest, (String)"initialRequest");
        this.project = project2;
        this.rating = StateFlowKt.MutableStateFlow((Object)ChatMessageRating.None);
        this.latestRequest = StateFlowKt.MutableStateFlow((Object)initialRequest);
        this.state = StateFlowKt.MutableStateFlow((Object)State.NotStarted.INSTANCE);
        this.problems = CoroutineUtilKt.mapState((StateFlow)((StateFlow)this.state), VcsAISelfReviewViewModel::problems$lambda$0);
        this.changes = CoroutineUtilKt.mapState((StateFlow)((StateFlow)this.latestRequest), VcsAISelfReviewViewModel::changes$lambda$1);
        this.runningReviewActivity = StateFlowKt.MutableStateFlow(null);
    }

    @NotNull
    public final MutableStateFlow<ChatMessageRating> getRating$intellij_ml_llm_vcs() {
        return this.rating;
    }

    @NotNull
    public final MutableStateFlow<State> getState() {
        return this.state;
    }

    @NotNull
    public final StateFlow<List<VcsAISelfReviewResult.Problem>> getProblems() {
        return this.problems;
    }

    @NotNull
    public final StateFlow<List<Change>> getChanges() {
        return this.changes;
    }

    @Override
    @NotNull
    public VcsAISelfReviewRequest getCurrentRequest() {
        return (VcsAISelfReviewRequest)this.latestRequest.getValue();
    }

    @Override
    public void setErrorState(@Nullable Throwable e, @Nullable VcsAISelfReviewResult partialReview) {
        String string;
        if (e != null) {
            Object[] objectArray = new Object[1];
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            objectArray[0] = string2;
            string = LLMVcsBundle.message("selfReview.problems.fail.received", objectArray);
        } else {
            string = LLMVcsBundle.message("selfReview.problems.no.response.received", new Object[0]);
        }
        String errorMessage = string;
        Object object = this.state.getValue();
        State.RequestHolder requestHolder = object instanceof State.RequestHolder ? (State.RequestHolder)object : null;
        VcsAISelfReviewRequest request2 = requestHolder != null ? requestHolder.getRequest() : null;
        VcsAISelfReviewResult partialResult = partialReview == null && request2 != null ? new VcsAISelfReviewResult(request2, CollectionsKt.emptyList()) : partialReview;
        this.setNewState(new State.Error(errorMessage, partialResult));
    }

    @Override
    public void setPartialReviewState(@NotNull VcsAISelfReviewResult partialReview) {
        Intrinsics.checkNotNullParameter((Object)partialReview, (String)"partialReview");
        this.setNewState(new State.PartialReviewReceived(partialReview));
    }

    @Override
    public void setFullReviewState(@NotNull VcsAISelfReviewResult fullReview) {
        Intrinsics.checkNotNullParameter((Object)fullReview, (String)"fullReview");
        this.setNewState(new State.FullReviewReceived(fullReview));
    }

    @Override
    public void setCancelledState(@Nullable VcsAISelfReviewResult partialReview) {
        this.setNewState(new State.Cancelled(partialReview));
    }

    @Override
    public void setFiltersAppliedState(@NotNull String filterName, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
        this.setNewState(new State.FilterApplied(filterName, state2, this.getCurrentRequest()));
    }

    private final void setNewState(State newState) {
        State nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<State> $this$update$iv = this.state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            State it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = newState)));
        this.logReviewActivity(newState);
    }

    private final void logReviewActivity(State newState) {
        if (newState instanceof State.Running) {
            StructuredIdeActivity nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<StructuredIdeActivity> $this$getAndUpdate$iv = this.runningReviewActivity;
            boolean $i$f$getAndUpdate = false;
            do {
                prevValue$iv = $this$getAndUpdate$iv.getValue();
                StructuredIdeActivity activity2 = (StructuredIdeActivity)prevValue$iv;
                boolean bl = false;
                if (activity2 == null) continue;
                VcsAISelfReviewCollector.INSTANCE.logReviewComplete(activity2, newState);
            } while (!$this$getAndUpdate$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = VcsAISelfReviewCollector.INSTANCE.logReviewStarted(this.project, this))));
        } else if (newState instanceof State.WithFullReview || newState instanceof State.Cancelled || newState instanceof State.Error) {
            Object nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<StructuredIdeActivity> $this$getAndUpdate$iv = this.runningReviewActivity;
            boolean $i$f$getAndUpdate = false;
            do {
                prevValue$iv = $this$getAndUpdate$iv.getValue();
                StructuredIdeActivity activity3 = (StructuredIdeActivity)prevValue$iv;
                boolean bl = false;
                if (activity3 == null) continue;
                VcsAISelfReviewCollector.INSTANCE.logReviewComplete(activity3, newState);
            } while (!$this$getAndUpdate$iv.compareAndSet(prevValue$iv, nextValue$iv = null));
        }
    }

    public final void requestAnalysis(@NotNull List<? extends Change> includedChanges) {
        Intrinsics.checkNotNullParameter(includedChanges, (String)"includedChanges");
        if (includedChanges.isEmpty()) {
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<VcsAISelfReviewAgent> serviceClass$iv = VcsAISelfReviewAgent.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Job reviewJob2 = ((VcsAISelfReviewAgent)object).execute(includedChanges, this, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                VcsAISelfReviewViewModel.access$cancelAnalysis((VcsAISelfReviewViewModel)this.receiver);
            }
        }));
        this.setNewState(new State.Running(this.getCurrentRequest(), (Function0<Unit>)((Function0)() -> VcsAISelfReviewViewModel.requestAnalysis$lambda$5(this, reviewJob2))));
    }

    private final void cancelAnalysis() {
        VcsAISelfReviewResult vcsAISelfReviewResult;
        Object object = this.state.getValue();
        Object object2 = object instanceof State.RequestHolder ? (State.RequestHolder)object : null;
        if (object2 != null && (object2 = object2.getRequest()) != null) {
            Object it = object2;
            boolean bl = false;
            vcsAISelfReviewResult = new VcsAISelfReviewResult((VcsAISelfReviewRequest)it, CollectionsKt.emptyList());
        } else {
            vcsAISelfReviewResult = null;
        }
        VcsAISelfReviewResult partialReview = vcsAISelfReviewResult;
        this.setNewState(new State.Cancelled(partialReview));
    }

    private static final List problems$lambda$0(State state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Object object = state2 instanceof State.FullReviewReceived ? (State.FullReviewReceived)state2 : null;
        if (object == null || (object = ((State.FullReviewReceived)object).getFullReview()) == null || (object = ((VcsAISelfReviewResult)object).getProblems()) == null) {
            Object object2 = state2 instanceof State.PartialReviewReceived ? (State.PartialReviewReceived)state2 : null;
            object = object2 != null && (object2 = ((State.PartialReviewReceived)object2).getPartialReview()) != null ? ((VcsAISelfReviewResult)object2).getProblems() : CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List changes$lambda$1(VcsAISelfReviewRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        VcsAISelfReviewRequest.LocalChanges localChanges = request2 instanceof VcsAISelfReviewRequest.LocalChanges ? (VcsAISelfReviewRequest.LocalChanges)request2 : null;
        List list = localChanges != null ? localChanges.getChanges() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Unit requestAnalysis$lambda$5(VcsAISelfReviewViewModel this$0, Job $reviewJob) {
        this$0.cancelAnalysis();
        Job.DefaultImpls.cancel$default((Job)$reviewJob, null, (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$cancelAnalysis(VcsAISelfReviewViewModel $this) {
        $this.cancelAnalysis();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\n\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\u0082\u0001\u0007\f\r\u000e\u000f\u0010\u0011\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State;", "", "RequestHolder", "NotStarted", "WithPartialReview", "WithFullReview", "Running", "PartialReviewReceived", "FullReviewReceived", "Error", "Cancelled", "FilterApplied", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$Cancelled;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$Error;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$FilterApplied;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$FullReviewReceived;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$NotStarted;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$PartialReviewReceived;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$Running;", "intellij.ml.llm.vcs"})
    public static interface State {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0015\u0010\n\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$Cancelled;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$WithPartialReview;", "partialReview", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "<init>", "(Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;)V", "getPartialReview", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.vcs"})
        public static final class Cancelled
        implements State,
        WithPartialReview {
            @Nullable
            private final VcsAISelfReviewResult partialReview;

            public Cancelled(@Nullable VcsAISelfReviewResult partialReview) {
                this.partialReview = partialReview;
            }

            @Override
            @Nullable
            public VcsAISelfReviewResult getPartialReview() {
                return this.partialReview;
            }

            @Nullable
            public final VcsAISelfReviewResult component1() {
                return this.partialReview;
            }

            @NotNull
            public final Cancelled copy(@Nullable VcsAISelfReviewResult partialReview) {
                return new Cancelled(partialReview);
            }

            public static /* synthetic */ Cancelled copy$default(Cancelled cancelled, VcsAISelfReviewResult vcsAISelfReviewResult, int n, Object object) {
                if ((n & 1) != 0) {
                    vcsAISelfReviewResult = cancelled.partialReview;
                }
                return cancelled.copy(vcsAISelfReviewResult);
            }

            @NotNull
            public String toString() {
                return "Cancelled(partialReview=" + this.partialReview + ")";
            }

            public int hashCode() {
                return this.partialReview == null ? 0 : this.partialReview.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Cancelled)) {
                    return false;
                }
                Cancelled cancelled = (Cancelled)other;
                return Intrinsics.areEqual((Object)this.partialReview, (Object)cancelled.partialReview);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u001f\u0010\u000f\u001a\u00020\u00002\b\b\u0003\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$Error;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$WithPartialReview;", "message", "", "partialReview", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;)V", "getMessage", "()Ljava/lang/String;", "getPartialReview", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.vcs"})
        public static final class Error
        implements State,
        WithPartialReview {
            @NotNull
            private final String message;
            @Nullable
            private final VcsAISelfReviewResult partialReview;

            public Error(@NlsContexts.Label @NotNull String message, @Nullable VcsAISelfReviewResult partialReview) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.message = message;
                this.partialReview = partialReview;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @Override
            @Nullable
            public VcsAISelfReviewResult getPartialReview() {
                return this.partialReview;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @Nullable
            public final VcsAISelfReviewResult component2() {
                return this.partialReview;
            }

            @NotNull
            public final Error copy(@NlsContexts.Label @NotNull String message, @Nullable VcsAISelfReviewResult partialReview) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new Error(message, partialReview);
            }

            public static /* synthetic */ Error copy$default(Error error, String string, VcsAISelfReviewResult vcsAISelfReviewResult, int n, Object object) {
                if ((n & 1) != 0) {
                    string = error.message;
                }
                if ((n & 2) != 0) {
                    vcsAISelfReviewResult = error.partialReview;
                }
                return error.copy(string, vcsAISelfReviewResult);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ", partialReview=" + this.partialReview + ")";
            }

            public int hashCode() {
                int result2 = this.message.hashCode();
                result2 = result2 * 31 + (this.partialReview == null ? 0 : this.partialReview.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                if (!Intrinsics.areEqual((Object)this.message, (Object)error.message)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.partialReview, (Object)error.partialReview);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$FilterApplied;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$RequestHolder;", "filterName", "", "state", "", "request", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;", "<init>", "(Ljava/lang/String;ZLcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;)V", "getFilterName", "()Ljava/lang/String;", "getState", "()Z", "getRequest", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.ml.llm.vcs"})
        public static final class FilterApplied
        implements State,
        RequestHolder {
            @NotNull
            private final String filterName;
            private final boolean state;
            @Nullable
            private final VcsAISelfReviewRequest request;

            public FilterApplied(@NotNull String filterName, boolean state2, @Nullable VcsAISelfReviewRequest request2) {
                Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
                this.filterName = filterName;
                this.state = state2;
                this.request = request2;
            }

            @NotNull
            public final String getFilterName() {
                return this.filterName;
            }

            public final boolean getState() {
                return this.state;
            }

            @Override
            @Nullable
            public VcsAISelfReviewRequest getRequest() {
                return this.request;
            }

            @NotNull
            public final String component1() {
                return this.filterName;
            }

            public final boolean component2() {
                return this.state;
            }

            @Nullable
            public final VcsAISelfReviewRequest component3() {
                return this.request;
            }

            @NotNull
            public final FilterApplied copy(@NotNull String filterName, boolean state2, @Nullable VcsAISelfReviewRequest request2) {
                Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
                return new FilterApplied(filterName, state2, request2);
            }

            public static /* synthetic */ FilterApplied copy$default(FilterApplied filterApplied, String string, boolean bl, VcsAISelfReviewRequest vcsAISelfReviewRequest, int n, Object object) {
                if ((n & 1) != 0) {
                    string = filterApplied.filterName;
                }
                if ((n & 2) != 0) {
                    bl = filterApplied.state;
                }
                if ((n & 4) != 0) {
                    vcsAISelfReviewRequest = filterApplied.request;
                }
                return filterApplied.copy(string, bl, vcsAISelfReviewRequest);
            }

            @NotNull
            public String toString() {
                return "FilterApplied(filterName=" + this.filterName + ", state=" + this.state + ", request=" + this.request + ")";
            }

            public int hashCode() {
                int result2 = this.filterName.hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.state);
                result2 = result2 * 31 + (this.request == null ? 0 : this.request.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FilterApplied)) {
                    return false;
                }
                FilterApplied filterApplied = (FilterApplied)other;
                if (!Intrinsics.areEqual((Object)this.filterName, (Object)filterApplied.filterName)) {
                    return false;
                }
                if (this.state != filterApplied.state) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.request, (Object)filterApplied.request);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$FullReviewReceived;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$WithFullReview;", "fullReview", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "<init>", "(Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;)V", "getFullReview", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.vcs"})
        public static final class FullReviewReceived
        implements State,
        WithFullReview {
            @NotNull
            private final VcsAISelfReviewResult fullReview;

            public FullReviewReceived(@NotNull VcsAISelfReviewResult fullReview) {
                Intrinsics.checkNotNullParameter((Object)fullReview, (String)"fullReview");
                this.fullReview = fullReview;
            }

            @Override
            @NotNull
            public VcsAISelfReviewResult getFullReview() {
                return this.fullReview;
            }

            @NotNull
            public final VcsAISelfReviewResult component1() {
                return this.fullReview;
            }

            @NotNull
            public final FullReviewReceived copy(@NotNull VcsAISelfReviewResult fullReview) {
                Intrinsics.checkNotNullParameter((Object)fullReview, (String)"fullReview");
                return new FullReviewReceived(fullReview);
            }

            public static /* synthetic */ FullReviewReceived copy$default(FullReviewReceived fullReviewReceived, VcsAISelfReviewResult vcsAISelfReviewResult, int n, Object object) {
                if ((n & 1) != 0) {
                    vcsAISelfReviewResult = fullReviewReceived.fullReview;
                }
                return fullReviewReceived.copy(vcsAISelfReviewResult);
            }

            @NotNull
            public String toString() {
                return "FullReviewReceived(fullReview=" + this.fullReview + ")";
            }

            public int hashCode() {
                return this.fullReview.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FullReviewReceived)) {
                    return false;
                }
                FullReviewReceived fullReviewReceived = (FullReviewReceived)other;
                return Intrinsics.areEqual((Object)this.fullReview, (Object)fullReviewReceived.fullReview);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$NotStarted;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State;", "<init>", "()V", "intellij.ml.llm.vcs"})
        public static final class NotStarted
        implements State {
            @NotNull
            public static final NotStarted INSTANCE = new NotStarted();

            private NotStarted() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$PartialReviewReceived;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$WithPartialReview;", "partialReview", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "<init>", "(Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;)V", "getPartialReview", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.vcs"})
        public static final class PartialReviewReceived
        implements State,
        WithPartialReview {
            @NotNull
            private final VcsAISelfReviewResult partialReview;

            public PartialReviewReceived(@NotNull VcsAISelfReviewResult partialReview) {
                Intrinsics.checkNotNullParameter((Object)partialReview, (String)"partialReview");
                this.partialReview = partialReview;
            }

            @Override
            @NotNull
            public VcsAISelfReviewResult getPartialReview() {
                return this.partialReview;
            }

            @NotNull
            public final VcsAISelfReviewResult component1() {
                return this.partialReview;
            }

            @NotNull
            public final PartialReviewReceived copy(@NotNull VcsAISelfReviewResult partialReview) {
                Intrinsics.checkNotNullParameter((Object)partialReview, (String)"partialReview");
                return new PartialReviewReceived(partialReview);
            }

            public static /* synthetic */ PartialReviewReceived copy$default(PartialReviewReceived partialReviewReceived, VcsAISelfReviewResult vcsAISelfReviewResult, int n, Object object) {
                if ((n & 1) != 0) {
                    vcsAISelfReviewResult = partialReviewReceived.partialReview;
                }
                return partialReviewReceived.copy(vcsAISelfReviewResult);
            }

            @NotNull
            public String toString() {
                return "PartialReviewReceived(partialReview=" + this.partialReview + ")";
            }

            public int hashCode() {
                return this.partialReview.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PartialReviewReceived)) {
                    return false;
                }
                PartialReviewReceived partialReviewReceived = (PartialReviewReceived)other;
                return Intrinsics.areEqual((Object)this.partialReview, (Object)partialReviewReceived.partialReview);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$RequestHolder;", "", "request", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;", "getRequest", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;", "intellij.ml.llm.vcs"})
        public static interface RequestHolder {
            @Nullable
            public VcsAISelfReviewRequest getRequest();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$Running;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$RequestHolder;", "request", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;", "cancel", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;Lkotlin/jvm/functions/Function0;)V", "getRequest", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;", "getCancel", "()Lkotlin/jvm/functions/Function0;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.vcs"})
        public static final class Running
        implements State,
        RequestHolder {
            @NotNull
            private final VcsAISelfReviewRequest request;
            @NotNull
            private final Function0<Unit> cancel;

            public Running(@NotNull VcsAISelfReviewRequest request2, @NotNull Function0<Unit> cancel) {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                Intrinsics.checkNotNullParameter(cancel, (String)"cancel");
                this.request = request2;
                this.cancel = cancel;
            }

            @Override
            @NotNull
            public VcsAISelfReviewRequest getRequest() {
                return this.request;
            }

            @NotNull
            public final Function0<Unit> getCancel() {
                return this.cancel;
            }

            @NotNull
            public final VcsAISelfReviewRequest component1() {
                return this.request;
            }

            @NotNull
            public final Function0<Unit> component2() {
                return this.cancel;
            }

            @NotNull
            public final Running copy(@NotNull VcsAISelfReviewRequest request2, @NotNull Function0<Unit> cancel) {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                Intrinsics.checkNotNullParameter(cancel, (String)"cancel");
                return new Running(request2, cancel);
            }

            public static /* synthetic */ Running copy$default(Running running, VcsAISelfReviewRequest vcsAISelfReviewRequest, Function0 function0, int n, Object object) {
                if ((n & 1) != 0) {
                    vcsAISelfReviewRequest = running.request;
                }
                if ((n & 2) != 0) {
                    function0 = running.cancel;
                }
                return running.copy(vcsAISelfReviewRequest, function0);
            }

            @NotNull
            public String toString() {
                return "Running(request=" + this.request + ", cancel=" + this.cancel + ")";
            }

            public int hashCode() {
                int result2 = this.request.hashCode();
                result2 = result2 * 31 + this.cancel.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Running)) {
                    return false;
                }
                Running running = (Running)other;
                if (!Intrinsics.areEqual((Object)this.request, (Object)running.request)) {
                    return false;
                }
                return Intrinsics.areEqual(this.cancel, running.cancel);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$WithFullReview;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$RequestHolder;", "request", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;", "getRequest", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;", "fullReview", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "getFullReview", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "intellij.ml.llm.vcs"})
        public static interface WithFullReview
        extends RequestHolder {
            @Override
            @NotNull
            default public VcsAISelfReviewRequest getRequest() {
                return this.getFullReview().getRequest();
            }

            @NotNull
            public VcsAISelfReviewResult getFullReview();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$WithPartialReview;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewViewModel$State$RequestHolder;", "request", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;", "getRequest", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewRequest;", "partialReview", "Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "getPartialReview", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/model/VcsAISelfReviewResult;", "intellij.ml.llm.vcs"})
        public static interface WithPartialReview
        extends RequestHolder {
            @Override
            @Nullable
            default public VcsAISelfReviewRequest getRequest() {
                VcsAISelfReviewResult vcsAISelfReviewResult = this.getPartialReview();
                return vcsAISelfReviewResult != null ? vcsAISelfReviewResult.getRequest() : null;
            }

            @Nullable
            public VcsAISelfReviewResult getPartialReview();
        }
    }
}

