/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.smartChat.endpoints;

import com.intellij.ml.llm.core.chat.messages.UserMessage;
import com.intellij.ml.llm.core.chat.messages.impl.FunctionCallError;
import com.intellij.ml.llm.core.chat.messages.impl.FunctionCallResult;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.vfs.VfsUtilCoreKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.smartChat.endpoints.EndpointDescriptorBuilder;
import com.intellij.ml.llm.smartChat.endpoints.EndpointType;
import com.intellij.ml.llm.smartChat.endpoints.LlmFunctionDescriptor;
import com.intellij.ml.llm.smartChat.endpoints.LlmParametersBuilder;
import com.intellij.ml.llm.smartChat.endpoints.PropertyDescriptorBuilder;
import com.intellij.ml.llm.smartChat.endpoints.SmartChatEndpoint;
import com.intellij.ml.llm.vcs.LLMVcsBundle;
import com.intellij.ml.llm.vcs.smartChat.endpoints.VcsLogEndpoint$LogArguments$;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/vcs/smartChat/endpoints/VcsLogEndpoint;", "Lcom/intellij/ml/llm/smartChat/endpoints/SmartChatEndpoint;", "<init>", "()V", "llmFunction", "Lcom/intellij/ml/llm/smartChat/endpoints/LlmFunctionDescriptor;", "getLlmFunction", "()Lcom/intellij/ml/llm/smartChat/endpoints/LlmFunctionDescriptor;", "call", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult;", "serializedArguments", "", "project", "Lcom/intellij/openapi/project/Project;", "chat", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPresentationString", "isAvailable", "", "userMessage", "Lcom/intellij/ml/llm/core/chat/messages/UserMessage;", "(Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lcom/intellij/ml/llm/core/chat/messages/UserMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "LogArguments", "NoVcsFound", "NoCommitsFound", "intellij.ml.llm.vcs"})
@SourceDebugExtension(value={"SMAP\nVcsLogEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogEndpoint.kt\ncom/intellij/ml/llm/vcs/smartChat/endpoints/VcsLogEndpoint\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n222#2:97\n1563#3:98\n1634#3,3:99\n*S KotlinDebug\n*F\n+ 1 VcsLogEndpoint.kt\ncom/intellij/ml/llm/vcs/smartChat/endpoints/VcsLogEndpoint\n*L\n60#1:97\n75#1:98\n75#1:99,3\n*E\n"})
public final class VcsLogEndpoint
implements SmartChatEndpoint {
    @NotNull
    public LlmFunctionDescriptor getLlmFunction() {
        return LlmFunctionDescriptor.Companion.invoke(VcsLogEndpoint::_get_llmFunction_$lambda$3);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object call(@NotNull String serializedArguments, @NotNull Project project2, @NotNull ChatSession chat, @NotNull Continuation<? super FunctionCallResult> $completion) {
        void this_$iv;
        Json json = (Json)Json.Default;
        String string$iv = serializedArguments;
        int $i$f$decodeFromString = 0;
        this_$iv.getSerializersModule();
        LogArguments arguments = (LogArguments)this_$iv.decodeFromString((DeserializationStrategy)LogArguments.Companion.serializer(), string$iv);
        VcsRoot[] vcsRootArray = ProjectLevelVcsManager.getInstance((Project)project2).getAllVcsRoots();
        Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
        VcsRoot[] vcsRoots = vcsRootArray;
        if (vcsRoots.length == 0) {
            return new FunctionCallResult.Error((FunctionCallError)new NoVcsFound(), null, 2, null);
        }
        CollectConsumer collector = new CollectConsumer();
        for (VcsRoot vcsRoot : vcsRoots) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List commits2;
            String branch;
            VcsLogProvider logProvider;
            VcsRoot rootObject;
            VirtualFile root;
            Intrinsics.checkNotNullExpressionValue((Object)vcsRoot.getPath(), (String)"getPath(...)");
            if (ProjectLevelVcsManager.getInstance((Project)project2).getVcsRootObjectFor(root) == null || (VcsLogProvider)VcsLogManager.Companion.findLogProviders((Collection)CollectionsKt.listOf((Object)rootObject), project2).get(root) == null || logProvider.getCurrentBranch(root) == null) continue;
            VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{VcsLogFilterObject.fromBranch((String)branch)};
            Intrinsics.checkNotNullExpressionValue((Object)logProvider.getCommitsMatchingFilter(root, VcsLogFilterObject.collection((VcsLogFilter[])vcsLogFilterArray), (PermanentGraph.Options)PermanentGraph.Options.Default, arguments.getTo()), (String)"getCommitsMatchingFilter(...)");
            if (arguments.getFrom() >= commits2.size()) continue;
            Iterable iterable = commits2.subList(arguments.getFrom(), commits2.size());
            VirtualFile virtualFile2 = root;
            VcsLogProvider vcsLogProvider = logProvider;
            boolean $i$f$map = false;
            void var18_20 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TimedVcsCommit timedVcsCommit = (TimedVcsCommit)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Hash)it.getId()).asString());
            }
            collection = (List)destination$iv$iv;
            vcsLogProvider.readMetadata(virtualFile2, (List)collection, (Consumer)collector);
        }
        if (collector.getResult().isEmpty()) {
            return new FunctionCallResult.Error((FunctionCallError)new NoCommitsFound(), null, 2, null);
        }
        Collection collection = collector.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResult(...)");
        PSString response2 = PSStringKt.joinToString$default((Iterable)collection, (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)",\n")), null, null, (int)0, null, VcsLogEndpoint::call$lambda$5, (int)30, null);
        return new FunctionCallResult.Success(response2, null, null, 6, null);
    }

    @NotNull
    public String getPresentationString() {
        return LLMVcsBundle.message("function.getting.vcs.log.status", new Object[0]);
    }

    @Nullable
    public Object isAvailable(@NotNull ChatSession chat, @NotNull UserMessage userMessage, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)Registry.Companion.is("llm.smartChat.endpointEnabled.VcsLogEndpoint"));
    }

    private static final Unit _get_llmFunction_$lambda$3$lambda$2$lambda$0(PropertyDescriptorBuilder $this$property) {
        Intrinsics.checkNotNullParameter((Object)$this$property, (String)"$this$property");
        $this$property.setType(EndpointType.STRING);
        $this$property.setDescription("First commit number to take from log, first number is 0");
        return Unit.INSTANCE;
    }

    private static final Unit _get_llmFunction_$lambda$3$lambda$2$lambda$1(PropertyDescriptorBuilder $this$property) {
        Intrinsics.checkNotNullParameter((Object)$this$property, (String)"$this$property");
        $this$property.setType(EndpointType.STRING);
        $this$property.setDescription("Last commit number to take from log");
        return Unit.INSTANCE;
    }

    private static final Unit _get_llmFunction_$lambda$3$lambda$2(LlmParametersBuilder $this$parameters) {
        Intrinsics.checkNotNullParameter((Object)$this$parameters, (String)"$this$parameters");
        $this$parameters.setType(EndpointType.OBJECT);
        $this$parameters.property("from", VcsLogEndpoint::_get_llmFunction_$lambda$3$lambda$2$lambda$0);
        $this$parameters.property("to", VcsLogEndpoint::_get_llmFunction_$lambda$3$lambda$2$lambda$1);
        String[] stringArray = new String[]{"from", "to"};
        $this$parameters.required(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit _get_llmFunction_$lambda$3(EndpointDescriptorBuilder $this$LlmFunctionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$LlmFunctionDescriptor, (String)"$this$LlmFunctionDescriptor");
        $this$LlmFunctionDescriptor.setName("get_vcs_log");
        $this$LlmFunctionDescriptor.setDescription("Returns commits from project vcs log. Takes not more than 20 commits.");
        $this$LlmFunctionDescriptor.parameters(VcsLogEndpoint::_get_llmFunction_$lambda$3$lambda$2);
        return Unit.INSTANCE;
    }

    private static final PrivacySafe call$lambda$5(VcsCommitMetadata it) {
        PSString pSString = ConstantsKt.getPrivacyConst((String)"Author: %s message: %s revision: %s date: %s");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[4];
        Intrinsics.checkNotNull((Object)it);
        pSStringConvertibleArray[0] = ExtensionsKtKt.getPrivacySafe(it).getAuthor();
        pSStringConvertibleArray[1] = ExtensionsKtKt.getPrivacySafe(it).getFullMessage();
        pSStringConvertibleArray[2] = ExtensionsKtKt.getPrivacySafe(it).getId();
        pSStringConvertibleArray[3] = VfsUtilCoreKt.formatPrettyDateTimePrivacySafe((long)it.getTimestamp());
        return (PrivacySafe)pSString.format(pSStringConvertibleArray);
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0005\u0010\nJ%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/vcs/smartChat/endpoints/VcsLogEndpoint$LogArguments;", "", "from", "", "to", "<init>", "(II)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getFrom", "()I", "getTo", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_vcs", "$serializer", "Companion", "intellij.ml.llm.vcs"})
    public static final class LogArguments {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int from;
        private final int to;

        public LogArguments(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public final int getFrom() {
            return this.from;
        }

        public final int getTo() {
            return this.to;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_vcs(LogArguments self, CompositeEncoder output2, SerialDescriptor serialDesc) {
            output2.encodeIntElement(serialDesc, 0, self.from);
            output2.encodeIntElement(serialDesc, 1, self.to);
        }

        public /* synthetic */ LogArguments(int seen0, int from, int to, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)LogArguments$$serializer.INSTANCE.getDescriptor());
            }
            this.from = from;
            this.to = to;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/vcs/smartChat/endpoints/VcsLogEndpoint$LogArguments$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/vcs/smartChat/endpoints/VcsLogEndpoint$LogArguments;", "intellij.ml.llm.vcs"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<LogArguments> serializer() {
                return (KSerializer)LogArguments$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/vcs/smartChat/endpoints/VcsLogEndpoint$NoCommitsFound;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallError;", "<init>", "()V", "intellij.ml.llm.vcs"})
    public static final class NoCommitsFound
    extends FunctionCallError {
        public NoCommitsFound() {
            super(ConstantsKt.getPrivacyConst((String)"No Commits Found"));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/vcs/smartChat/endpoints/VcsLogEndpoint$NoVcsFound;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallError;", "<init>", "()V", "intellij.ml.llm.vcs"})
    public static final class NoVcsFound
    extends FunctionCallError {
        public NoVcsFound() {
            super(ConstantsKt.getPrivacyConst((String)"No VCS found for this project"));
        }
    }
}

