/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal;

import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.terminal.TerminalAiSettingsStorage;
import com.intellij.ml.llm.terminal.TerminalLLMBundle;
import com.intellij.ml.llm.terminal.TerminalTextToCommandModeActivator;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiSettingsProvider;", "Lorg/jetbrains/plugins/terminal/LocalTerminalCustomizer;", "<init>", "()V", "getBlockTerminalConfigurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "TerminalAiSettingsConfigurable", "intellij.ml.llm.terminal"})
public final class TerminalAiSettingsProvider
extends LocalTerminalCustomizer {
    @Nullable
    public UnnamedConfigurable getBlockTerminalConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (TerminalTextToCommandModeActivator.Companion.isNaturalLanguageDetectionEnabled() && AIAssistantUIUtil.INSTANCE.isAuthedAndAllowed(project)) {
            return new TerminalAiSettingsConfigurable();
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAiSettingsProvider$TerminalAiSettingsConfigurable;", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "<init>", "()V", "optionCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "value", "", "optionValue", "getOptionValue", "()Z", "setOptionValue", "(Z)V", "createComponent", "Ljavax/swing/JComponent;", "isModified", "apply", "", "reset", "intellij.ml.llm.terminal"})
    private static final class TerminalAiSettingsConfigurable
    implements UnnamedConfigurable {
        private JBCheckBox optionCheckBox;

        private final boolean getOptionValue() {
            return TerminalAiSettingsStorage.Companion.getInstance().getDetectNaturalLanguage();
        }

        private final void setOptionValue(boolean value) {
            TerminalAiSettingsStorage.Companion.getInstance().setDetectNaturalLanguage(value);
        }

        @NotNull
        public JComponent createComponent() {
            return (JComponent)BuilderKt.panel(arg_0 -> TerminalAiSettingsConfigurable.createComponent$lambda$1(this, arg_0));
        }

        public boolean isModified() {
            JBCheckBox jBCheckBox = this.optionCheckBox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"optionCheckBox");
                jBCheckBox = null;
            }
            return jBCheckBox.isSelected() != this.getOptionValue();
        }

        public void apply() {
            JBCheckBox jBCheckBox = this.optionCheckBox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"optionCheckBox");
                jBCheckBox = null;
            }
            this.setOptionValue(jBCheckBox.isSelected());
        }

        public void reset() {
            JBCheckBox jBCheckBox = this.optionCheckBox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"optionCheckBox");
                jBCheckBox = null;
            }
            jBCheckBox.setSelected(this.getOptionValue());
        }

        private static final Unit createComponent$lambda$1$lambda$0(TerminalAiSettingsConfigurable this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell checkBoxCell = $this$row.checkBox(TerminalLLMBundle.INSTANCE.message("settings.detect.natural.language.checkbox", new Object[0])).gap(RightGap.SMALL);
            this$0.optionCheckBox = (JBCheckBox)checkBoxCell.getComponent();
            Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
            Row.contextHelp$default((Row)$this$row, (String)TerminalLLMBundle.INSTANCE.message("settings.detect.natural.language.description", objectArray), null, (int)2, null);
            return Unit.INSTANCE;
        }

        private static final Unit createComponent$lambda$1(TerminalAiSettingsConfigurable this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, arg_0 -> TerminalAiSettingsConfigurable.createComponent$lambda$1$lambda$0(this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }
    }
}

