/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.rag;

import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.context.rag.SummarizedChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatContextViewModel;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.core.models.api.AiChatMediaMessage;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.observable.properties.ObservableProperty;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0010\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0017\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0096\u0001J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0096A\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u0011\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0096\u0001J\t\u0010#\u001a\u00020\u0014H\u0096\u0001J\u0011\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u001bH\u0096\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0012\u0010(\u001a\u00020)X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001f\u0010,\u001a\u000f\u0012\u0004\u0012\u00020'\u0018\u00010-\u00a2\u0006\u0002\b.X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u00101\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b3\u00100R\u0012\u00104\u001a\u00020'X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0018\u00107\u001a\b\u0012\u0004\u0012\u00020\u001b0-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b7\u00100R\u0018\u00108\u001a\b\u0012\u0004\u0012\u00020\u001b0-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b8\u00100R\u001d\u00109\u001a\r\u0012\u0004\u0012\u00020'0-\u00a2\u0006\u0002\b.X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b:\u00100R\u0019\u0010;\u001a\t\u0018\u00010'\u00a2\u0006\u0002\b<X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b=\u00106R\u0012\u0010>\u001a\u00020'X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b?\u00106R\u0012\u0010@\u001a\u00020AX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0014\u0010D\u001a\u0004\u0018\u00010'X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bE\u00106R\u0012\u0010F\u001a\u00020'X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bG\u00106\u00a8\u0006H"}, d2={"Lcom/intellij/ml/llm/core/chat/context/rag/SummarizedContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "originalContextAttachment", "summarisedText", "Lcom/intellij/ml/llm/privacy/PSString;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;Lcom/intellij/ml/llm/privacy/PSString;)V", "getOriginalContextAttachment", "()Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "getSummarisedText", "()Lcom/intellij/ml/llm/privacy/PSString;", "text", "getText", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "component1", "component2", "copy", "addRemoveListener", "", "listener", "Lkotlin/Function0;", "createMediaMessages", "", "Lcom/intellij/ml/llm/core/models/api/AiChatMediaMessage;", "equals", "", "other", "", "hashCode", "", "onChosen", "model", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/AIChatContextViewModel;", "onRemove", "performAction", "isInMessage", "toString", "", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "hint", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "Lcom/intellij/openapi/util/NlsSafe;", "getHint", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "icon", "Ljavax/swing/Icon;", "getIcon", "id", "getId", "()Ljava/lang/String;", "isValid", "isVisible", "name", "getName", "popupHintText", "Lorg/jetbrains/annotations/Nls;", "getPopupHintText", "popupPresentationText", "getPopupPresentationText", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "tooltipDescriptionText", "getTooltipDescriptionText", "tooltipText", "getTooltipText", "intellij.ml.llm.chat"})
public final class SummarizedContextAttachment
implements ContextAttachment {
    @NotNull
    private final ContextAttachment originalContextAttachment;
    @NotNull
    private final PSString summarisedText;
    @NotNull
    private final PSString text;

    public SummarizedContextAttachment(@NotNull ContextAttachment originalContextAttachment, @NotNull PSString summarisedText) {
        Intrinsics.checkNotNullParameter((Object)originalContextAttachment, (String)"originalContextAttachment");
        Intrinsics.checkNotNullParameter((Object)summarisedText, (String)"summarisedText");
        this.originalContextAttachment = originalContextAttachment;
        this.text = this.summarisedText = summarisedText;
    }

    @NotNull
    public final ContextAttachment getOriginalContextAttachment() {
        return this.originalContextAttachment;
    }

    @NotNull
    public final PSString getSummarisedText() {
        return this.summarisedText;
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.text;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new SummarizedChatAttachment(this.originalContextAttachment, ConstantsKt.getPrivacyConst((String)"summarised contents"), this.getText(), ChatAttachment.Kind.Visible, this.getAttachedBy());
    }

    @NotNull
    public final ContextAttachment component1() {
        return this.originalContextAttachment;
    }

    @NotNull
    public final PSString component2() {
        return this.summarisedText;
    }

    @NotNull
    public final SummarizedContextAttachment copy(@NotNull ContextAttachment originalContextAttachment, @NotNull PSString summarisedText) {
        Intrinsics.checkNotNullParameter((Object)originalContextAttachment, (String)"originalContextAttachment");
        Intrinsics.checkNotNullParameter((Object)summarisedText, (String)"summarisedText");
        return new SummarizedContextAttachment(originalContextAttachment, summarisedText);
    }

    public static /* synthetic */ SummarizedContextAttachment copy$default(SummarizedContextAttachment summarizedContextAttachment, ContextAttachment contextAttachment, PSString pSString, int n, Object object) {
        if ((n & 1) != 0) {
            contextAttachment = summarizedContextAttachment.originalContextAttachment;
        }
        if ((n & 2) != 0) {
            pSString = summarizedContextAttachment.summarisedText;
        }
        return summarizedContextAttachment.copy(contextAttachment, pSString);
    }

    @NotNull
    public String toString() {
        return "SummarizedContextAttachment(originalContextAttachment=" + this.originalContextAttachment + ", summarisedText=" + this.summarisedText + ")";
    }

    public int hashCode() {
        int result2 = this.originalContextAttachment.hashCode();
        result2 = result2 * 31 + this.summarisedText.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SummarizedContextAttachment)) {
            return false;
        }
        SummarizedContextAttachment summarizedContextAttachment = (SummarizedContextAttachment)other;
        if (!Intrinsics.areEqual((Object)this.originalContextAttachment, (Object)summarizedContextAttachment.originalContextAttachment)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.summarisedText, (Object)summarizedContextAttachment.summarisedText);
    }

    @Override
    @NotNull
    public ObservableProperty<String> getName() {
        return this.originalContextAttachment.getName();
    }

    @Override
    @Nullable
    public ObservableProperty<String> getHint() {
        return this.originalContextAttachment.getHint();
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.originalContextAttachment.getTooltipText();
    }

    @Override
    @Nullable
    public String getTooltipDescriptionText() {
        return this.originalContextAttachment.getTooltipDescriptionText();
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.originalContextAttachment.getPopupPresentationText();
    }

    @Override
    @Nullable
    public String getPopupHintText() {
        return this.originalContextAttachment.getPopupHintText();
    }

    @Override
    @Nullable
    public ObservableProperty<Icon> getIcon() {
        return this.originalContextAttachment.getIcon();
    }

    @Override
    @NotNull
    public ObservableProperty<Boolean> isVisible() {
        return this.originalContextAttachment.isVisible();
    }

    @Override
    @NotNull
    public ObservableProperty<Boolean> isValid() {
        return this.originalContextAttachment.isValid();
    }

    @Override
    public void performAction(boolean isInMessage) {
        this.originalContextAttachment.performAction(isInMessage);
    }

    @Override
    public void onRemove() {
        this.originalContextAttachment.onRemove();
    }

    @Override
    public void addRemoveListener(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.originalContextAttachment.addRemoveListener(listener2);
    }

    @Override
    public void onChosen(@NotNull AIChatContextViewModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.originalContextAttachment.onChosen(model);
    }

    @Override
    @Nullable
    public Object createMediaMessages(@NotNull Continuation<? super List<AiChatMediaMessage>> $completion) {
        return this.originalContextAttachment.createMediaMessages($completion);
    }

    @NotNull
    public String getId() {
        return this.originalContextAttachment.getId();
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.originalContextAttachment.getAttachedBy();
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return this.originalContextAttachment.getPrivacy();
    }
}

