/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.parts.latex;

import com.intellij.ide.ui.UISettings;
import com.intellij.idea.AppMode;
import com.intellij.ml.llm.core.chat.parts.latex.LatexDetectionUtils;
import com.intellij.ml.llm.core.chat.parts.latex.LatexIconProvider;
import com.intellij.ml.llm.core.chat.parts.latex.LatexMessagePartViewExtensionKt;
import com.intellij.ml.llm.core.chat.parts.latex.LatexView;
import com.intellij.ml.llm.core.chat.ui.chat.MessagePartViewExtension;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Element;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J%\u0010\r\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000e2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0010\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000e2\u000b\u0010\f\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000e2\u0006\u0010\b\u001a\u00020\tH\u0007J,\u0010\u0011\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000e2\u000b\u0010\f\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\n\u0010\u0014\u001a\u00020\u000b*\u00020\u000bJ \u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/core/chat/parts/latex/LatexMessagePartViewExtension;", "Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartViewExtension;", "<init>", "()V", "getExtension", "Lkotlin/Function2;", "Ljavax/swing/text/Element;", "Ljavax/swing/text/View;", "context", "Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartViewExtension$Context;", "preProcessRawHTML", "", "html", "postProcessRawHTML", "Lcom/intellij/openapi/util/NlsSafe;", "(Ljava/lang/String;Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartViewExtension$Context;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "testProcessRawHtml", "processRawHtml", "isComputeIconAvailable", "", "trimLatexFormula", "requestIconFromText", "text", "iconProvider", "Lcom/intellij/ml/llm/core/chat/parts/latex/LatexIconProvider;", "endExclusive", "", "Lkotlin/ranges/IntRange;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nLatexMessagePartViewExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatexMessagePartViewExtension.kt\ncom/intellij/ml/llm/core/chat/parts/latex/LatexMessagePartViewExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1788#2,3:223\n1563#2:226\n1634#2,3:227\n1740#2,3:230\n1761#2,3:233\n1869#2,2:236\n1869#2,2:238\n1869#2,2:240\n808#2,11:242\n1791#2:253\n*S KotlinDebug\n*F\n+ 1 LatexMessagePartViewExtension.kt\ncom/intellij/ml/llm/core/chat/parts/latex/LatexMessagePartViewExtension\n*L\n79#1:223,3\n80#1:226\n80#1:227,3\n80#1:230,3\n81#1:233,3\n94#1:236,2\n99#1:238,2\n101#1:240,2\n120#1:242,11\n79#1:253\n*E\n"})
public final class LatexMessagePartViewExtension
implements MessagePartViewExtension {
    @Override
    @NotNull
    public Function2<Element, View, View> getExtension(@Nullable MessagePartViewExtension.Context context) {
        return (arg_0, arg_1) -> LatexMessagePartViewExtension.getExtension$lambda$0(context, arg_0, arg_1);
    }

    @Override
    @NotNull
    public String preProcessRawHTML(@NotNull String html, @Nullable MessagePartViewExtension.Context context) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        return this.processRawHtml(html, context, false);
    }

    @Override
    @Nullable
    public Object postProcessRawHTML(@NotNull String html, @Nullable MessagePartViewExtension.Context context, @NotNull Continuation<? super String> $completion) {
        return this.processRawHtml(html, context, true);
    }

    @TestOnly
    @NotNull
    public final String testProcessRawHtml(@NotNull String html, @NotNull MessagePartViewExtension.Context context) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.processRawHtml(html, context, true);
    }

    /*
     * WARNING - void declaration
     */
    private final String processRawHtml(String html, MessagePartViewExtension.Context context, boolean isComputeIconAvailable) {
        String string;
        boolean isChanged;
        int n;
        Document document;
        block23: {
            Iterable $this$count$iv;
            List detects;
            LatexIconProvider iconProvider;
            block22: {
                if (!Registry.Companion.is("llm.chat.latex.rendering")) {
                    return html;
                }
                if (AppMode.isRemoteDevHost()) {
                    return html;
                }
                if (context == null) {
                    return html;
                }
                iconProvider = LatexIconProvider.Companion.getInstance(context);
                Document document2 = Jsoup.parse((String)html);
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"parse(...)");
                document = document2;
                detects = new ArrayList();
                Elements elements = document.select("*");
                Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
                $this$count$iv = (Iterable)elements;
                boolean $i$f$count = false;
                if (!($this$count$iv instanceof Collection) || !((Collection)$this$count$iv).isEmpty()) break block22;
                n = 0;
                break block23;
            }
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean bl;
                block26: {
                    block30: {
                        void $this$filterIsInstanceTo$iv$iv;
                        void $this$filterIsInstance$iv;
                        Object newNode;
                        Iterable $this$forEach$iv;
                        List<LatexDetectionUtils.LatexDetectionResult> detectionResult;
                        Collection collection;
                        block34: {
                            Object element$iv22;
                            boolean $i$f$forEach;
                            org.jsoup.nodes.Element element;
                            block31: {
                                org.jsoup.nodes.Element newNode2;
                                String text2;
                                block33: {
                                    block32: {
                                        block29: {
                                            block28: {
                                                block27: {
                                                    boolean bl2;
                                                    block21: {
                                                        Object element$iv3;
                                                        Iterator $this$mapTo$iv$iv;
                                                        block25: {
                                                            block24: {
                                                                boolean bl3;
                                                                block20: {
                                                                    element = (org.jsoup.nodes.Element)element$iv;
                                                                    boolean bl4 = false;
                                                                    if (!element.tag().isBlock()) break block24;
                                                                    Elements elements = element.children();
                                                                    Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"children(...)");
                                                                    Iterable $this$map$iv = (Iterable)elements;
                                                                    boolean $i$f$map = false;
                                                                    Iterable iterable = $this$map$iv;
                                                                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                                    boolean $i$f$mapTo = false;
                                                                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                                                                    while (iterator.hasNext()) {
                                                                        void it;
                                                                        Object item$iv$iv = iterator.next();
                                                                        org.jsoup.nodes.Element element2 = (org.jsoup.nodes.Element)item$iv$iv;
                                                                        collection = destination$iv$iv;
                                                                        boolean bl5 = false;
                                                                        collection.add(it.tag());
                                                                    }
                                                                    Iterable $this$all$iv = (List)destination$iv$iv;
                                                                    boolean $i$f$all = false;
                                                                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                                                        bl3 = true;
                                                                    } else {
                                                                        $this$mapTo$iv$iv = $this$all$iv.iterator();
                                                                        while ($this$mapTo$iv$iv.hasNext()) {
                                                                            element$iv3 = $this$mapTo$iv$iv.next();
                                                                            Tag it = (Tag)element$iv3;
                                                                            boolean bl6 = false;
                                                                            if (it.isInline()) continue;
                                                                            bl3 = false;
                                                                            break block20;
                                                                        }
                                                                        bl3 = true;
                                                                    }
                                                                }
                                                                if (bl3) break block25;
                                                            }
                                                            bl = false;
                                                            break block26;
                                                        }
                                                        Elements elements = element.children();
                                                        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"children(...)");
                                                        Iterable $this$any$iv = (Iterable)elements;
                                                        boolean $i$f$any = false;
                                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                            bl2 = false;
                                                        } else {
                                                            $this$mapTo$iv$iv = $this$any$iv.iterator();
                                                            while ($this$mapTo$iv$iv.hasNext()) {
                                                                element$iv3 = $this$mapTo$iv$iv.next();
                                                                org.jsoup.nodes.Element it = (org.jsoup.nodes.Element)element$iv3;
                                                                boolean bl7 = false;
                                                                if (!it.hasAttr("latex_text")) continue;
                                                                bl2 = true;
                                                                break block21;
                                                            }
                                                            bl2 = false;
                                                        }
                                                    }
                                                    if (!bl2) break block27;
                                                    bl = false;
                                                    break block26;
                                                }
                                                if (!element.hasAttr("latex_text")) break block28;
                                                bl = false;
                                                break block26;
                                            }
                                            if (element.hasText()) break block29;
                                            bl = false;
                                            break block26;
                                        }
                                        Intrinsics.checkNotNullExpressionValue((Object)element.text(), (String)"text(...)");
                                        detectionResult = LatexDetectionUtils.INSTANCE.heuristicDetectLatexInText(text2, detects);
                                        if (!(!((Collection)detectionResult).isEmpty())) break block30;
                                        if (detectionResult.size() != 1) break block31;
                                        if (!(detectionResult.get(0) instanceof LatexDetectionUtils.LatexDetectionResult.SimpleText)) break block32;
                                        bl = false;
                                        break block26;
                                    }
                                    boolean isReadyToSwap = this.requestIconFromText(text2, iconProvider, isComputeIconAvailable);
                                    if (isReadyToSwap) break block33;
                                    bl = false;
                                    break block26;
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)element.text(text2).tagName("latex_unknown_tag"), (String)"tagName(...)");
                                element.replaceWith((Node)newNode2);
                                newNode2.attr("latex_text", text2);
                                List list = newNode2.childNodes();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"childNodes(...)");
                                $this$forEach$iv = list;
                                $i$f$forEach = false;
                                for (Object element$iv4 : $this$forEach$iv) {
                                    Node child = (Node)element$iv4;
                                    boolean bl8 = false;
                                    child.remove();
                                }
                                break block34;
                            }
                            org.jsoup.nodes.Element element3 = element.clone();
                            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"clone(...)");
                            newNode = element3;
                            List list = newNode.childNodes();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"childNodes(...)");
                            Iterable $this$forEach$iv2 = list;
                            boolean $i$f$forEach2 = false;
                            for (Object element$iv22 : $this$forEach$iv2) {
                                Node child = (Node)element$iv22;
                                boolean bl9 = false;
                                child.remove();
                            }
                            boolean isReadyToSwap = false;
                            isReadyToSwap = true;
                            $this$forEach$iv = detectionResult;
                            $i$f$forEach = false;
                            element$iv22 = $this$forEach$iv.iterator();
                            while (element$iv22.hasNext()) {
                                org.jsoup.nodes.Element element4;
                                Object element$iv4;
                                element$iv4 = element$iv22.next();
                                LatexDetectionUtils.LatexDetectionResult range = (LatexDetectionUtils.LatexDetectionResult)element$iv4;
                                boolean bl10 = false;
                                LatexDetectionUtils.LatexDetectionResult latexDetectionResult = range;
                                if (latexDetectionResult instanceof LatexDetectionUtils.LatexDetectionResult.Latex) {
                                    boolean isCurrentReadyToSwap = this.requestIconFromText(range.getText(), iconProvider, isComputeIconAvailable);
                                    isReadyToSwap = isReadyToSwap && isCurrentReadyToSwap;
                                    element4 = newNode.appendChild((Node)new org.jsoup.nodes.Element("latex_unknown_tag").attr("latex_text", range.getText()));
                                    continue;
                                }
                                if (latexDetectionResult instanceof LatexDetectionUtils.LatexDetectionResult.SimpleText) {
                                    TextNode element5 = new TextNode(range.getText());
                                    element4 = newNode.appendChild((Node)element5);
                                    continue;
                                }
                                throw new NoWhenBranchMatchedException();
                            }
                            if (isReadyToSwap) {
                                element.replaceWith((Node)newNode);
                            }
                        }
                        newNode = detectionResult;
                        collection = detects;
                        boolean $i$f$filterIsInstance = false;
                        $this$forEach$iv = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof LatexDetectionUtils.LatexDetectionResult.Latex)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        collection.addAll((List)destination$iv$iv);
                        bl = true;
                        break block26;
                    }
                    bl = false;
                }
                if (!bl || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        boolean bl = isChanged = n > 0;
        if (isChanged) {
            String string2 = document.html();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"html(...)");
        } else {
            string = html;
        }
        return string;
    }

    @NotNull
    public final String trimLatexFormula(@NotNull String $this$trimLatexFormula) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$trimLatexFormula, (String)"<this>");
        String spacesTrimmed = ((Object)StringsKt.trim((CharSequence)$this$trimLatexFormula)).toString();
        if (StringsKt.startsWith$default((String)spacesTrimmed, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)spacesTrimmed, (String)"]", (boolean)false, (int)2, null)) {
            String string2 = spacesTrimmed.substring(1, spacesTrimmed.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = spacesTrimmed;
        }
        String bracketsTrimmed = string;
        return ((Object)StringsKt.trim((CharSequence)bracketsTrimmed)).toString();
    }

    private final boolean requestIconFromText(String text2, LatexIconProvider iconProvider, boolean isComputeIconAvailable) {
        boolean bl;
        if (isComputeIconAvailable) {
            TeXFormula teXFormula;
            if (iconProvider.get(text2) != null) {
                return true;
            }
            try {
                teXFormula = new TeXFormula(this.trimLatexFormula(text2));
            }
            catch (ParseException e) {
                LatexMessagePartViewExtensionKt.access$getLOG$p().warn("An impossible condition happened. The formula that we recognized as valid formula before turned out not to be the Latex formula", (Throwable)e);
                return false;
            }
            TeXFormula formula = teXFormula;
            iconProvider.computeIfAbsent(text2, (Function1<? super String, ? extends TeXIcon>)((Function1)arg_0 -> LatexMessagePartViewExtension.requestIconFromText$lambda$8(formula, arg_0)));
            bl = true;
        } else {
            bl = iconProvider.get(text2) != null;
        }
        return bl;
    }

    private final int endExclusive(IntRange $this$endExclusive) {
        return $this$endExclusive.getLast() + 1;
    }

    private static final View getExtension$lambda$0(MessagePartViewExtension.Context $context, Element element, View view) {
        View view2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if ($context != null && element.getAttributes().getAttribute("latex_text") != null) {
            LatexView latexView;
            Object object = element.getAttributes().getAttribute("latex_text");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String text2 = (String)object;
            LatexIconProvider iconProvider = LatexIconProvider.Companion.getInstance($context);
            TeXIcon icon = iconProvider.get(text2);
            if (icon == null) {
                LatexMessagePartViewExtensionKt.access$getLOG$p().warn("An impossible condition happened. Icon was not found in the icon storage for Latex");
                latexView = null;
            } else {
                latexView = new LatexView(element, icon);
            }
            view2 = latexView;
        } else {
            view2 = null;
        }
        return view2;
    }

    private static final TeXIcon requestIconFromText$lambda$8(TeXFormula $formula, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TeXIcon teXIcon = $formula.createTeXIcon(0, UISettings.Companion.getInstance().getFontSize());
        Intrinsics.checkNotNullExpressionValue((Object)teXIcon, (String)"createTeXIcon(...)");
        return teXIcon;
    }
}

