/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.services;

import com.intellij.ml.llm.context.RetrievalSession;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.CurrentFileChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.CustomSystemPromptAttachment;
import com.intellij.ml.llm.core.chat.attachments.TargetElementCodeChatAttachment;
import com.intellij.ml.llm.core.chat.context.ContextItemRenderer;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u000e\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/core/chat/services/AIRequesterUtils;", "", "<init>", "()V", "formatMessageContent", "Lcom/intellij/ml/llm/privacy/PSString;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "message", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "formatAttachments", "visibleAttachments", "", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "getAttachmentsPS", "numTargetElementCodeChatAttachments", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIRequesterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIRequesterUtils.kt\ncom/intellij/ml/llm/core/chat/services/AIRequesterUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n774#2:63\n865#2,2:64\n808#2,11:66\n808#2,11:77\n*S KotlinDebug\n*F\n+ 1 AIRequesterUtils.kt\ncom/intellij/ml/llm/core/chat/services/AIRequesterUtils\n*L\n16#1:63\n16#1:64,2\n28#1:66,11\n29#1:77,11\n*E\n"})
public final class AIRequesterUtils {
    @NotNull
    public static final AIRequesterUtils INSTANCE = new AIRequesterUtils();

    private AIRequesterUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PSString formatMessageContent(@NotNull ChatSession chatSession2, @NotNull ChatMessage message) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)chatSession2, (String)"chatSession");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterable iterable = message.getAttachments();
        ChatSession chatSession3 = chatSession2;
        AIRequesterUtils aIRequesterUtils = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatAttachment it = (ChatAttachment)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof CustomSystemPromptAttachment))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        PSString formattedAttachments = aIRequesterUtils.formatAttachments(chatSession3, list);
        PSString resultingText = message.getFormattedText();
        if (formattedAttachments != null) {
            resultingText = resultingText.plus(formattedAttachments);
        }
        return resultingText;
    }

    /*
     * WARNING - void declaration
     */
    private final PSString formatAttachments(ChatSession chatSession2, List<? extends ChatAttachment> visibleAttachments) {
        PSString pSString;
        PSString pSString2;
        PSString pSString3;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        if (visibleAttachments.isEmpty()) {
            return null;
        }
        Iterable $this$filterIsInstance$iv = visibleAttachments;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof TargetElementCodeChatAttachment)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List targetElementAttachments = (List)destination$iv$iv;
        Iterable $this$filterIsInstance$iv2 = visibleAttachments;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CurrentFileChatAttachment)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List currentFileAttachments = (List)destination$iv$iv2;
        List relatedItemsAttachments = CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)visibleAttachments, (Iterable)targetElementAttachments), (Iterable)currentFileAttachments);
        PSString it = this.getAttachmentsPS(targetElementAttachments, chatSession2);
        boolean bl = false;
        if (((CharSequence)it).length() > 0) {
            Object element$iv$iv;
            element$iv$iv = new PSStringConvertible[]{it};
            pSString3 = ConstantsKt.getPrivacyConst((String)"\nSelected code or element under caret in the editor:\n%s\n").format((PSStringConvertible[])element$iv$iv);
        } else {
            pSString3 = ConstantsKt.getEMPTY();
        }
        PSString targetElementAttachmentsPart = pSString3;
        PSString it2 = this.getAttachmentsPS(currentFileAttachments, chatSession2);
        boolean bl2 = false;
        if (((CharSequence)it2).length() > 0) {
            Object element$iv$iv;
            element$iv$iv = new PSStringConvertible[]{it2};
            pSString2 = ConstantsKt.getPrivacyConst((String)"\nInformation about open file in the editor:\n%s\n").format(element$iv$iv);
        } else {
            pSString2 = ConstantsKt.getEMPTY();
        }
        PSString currentFileAttachmentsPart = pSString2;
        PSString it3 = this.getAttachmentsPS(relatedItemsAttachments, chatSession2);
        boolean bl3 = false;
        if (((CharSequence)it3).length() > 0) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{it3};
            pSString = ConstantsKt.getPrivacyConst((String)"\nRelated information and code that may be helpful:\n%s\n").format(pSStringConvertibleArray);
        } else {
            pSString = ConstantsKt.getEMPTY();
        }
        PSString relatedItemsAttachmentsPart = pSString;
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{targetElementAttachmentsPart, currentFileAttachmentsPart, relatedItemsAttachmentsPart};
        return ConstantsKt.getPrivacyConst((String)"\n          \n          \n          Don't mention code from attachments unless it's needed\n          %s\n          %s\n          %s").trimIndent().format(pSStringConvertibleArray);
    }

    private final PSString getAttachmentsPS(List<? extends ChatAttachment> numTargetElementCodeChatAttachments, ChatSession chatSession2) {
        PSString targetElementCodeChatAttachmentsPlaceholder = ConstantsKt.getPrivacyConst((String)"");
        for (ChatAttachment chatAttachment : numTargetElementCodeChatAttachments) {
            PSString rendered = ContextItemRenderer.Companion.render((RetrievalSession)chatSession2.getRetrievalSession(), chatAttachment);
            if (rendered == null) continue;
            targetElementCodeChatAttachmentsPlaceholder = targetElementCodeChatAttachmentsPlaceholder.plus(rendered.plus(ConstantsKt.getPrivacyConst((String)"\n")));
        }
        return targetElementCodeChatAttachmentsPlaceholder;
    }
}

