/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.llmInstaller.api.AiToolWindowService;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSessionHost;
import com.intellij.ml.llm.core.chat.session.FocusedChatSessionHost;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.chat.ui.chat.ScrollableChatPanel;
import com.intellij.ml.llm.core.chat.ui.chat.TextPartViewEditorPane;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0011R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/AIAssistantChatUtil;", "", "<init>", "()V", "openChat", "", "project", "Lcom/intellij/openapi/project/Project;", "chat", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "updateFont", "root", "Ljava/awt/Component;", "applyShortcuts", "view", "Ljavax/swing/JComponent;", "getMarkdownLanguageId", "", "language", "Lcom/intellij/lang/Language;", "CPP_LANGUAGES", "", "findLanguage", "languageName", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantChatUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantChatUtil.kt\ncom/intellij/ml/llm/core/chat/ui/AIAssistantChatUtil\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,128:1\n30#2,2:129\n30#2,2:137\n40#3,3:131\n1869#4,2:134\n24#5:136\n*S KotlinDebug\n*F\n+ 1 AIAssistantChatUtil.kt\ncom/intellij/ml/llm/core/chat/ui/AIAssistantChatUtil\n*L\n35#1:129,2\n39#1:137,2\n37#1:131,3\n49#1:134,2\n75#1:136\n*E\n"})
public final class AIAssistantChatUtil {
    @NotNull
    public static final AIAssistantChatUtil INSTANCE = new AIAssistantChatUtil();
    @NotNull
    private static final List<String> CPP_LANGUAGES;

    private AIAssistantChatUtil() {
    }

    @RequiresEdt
    public final void openChat(@NotNull Project project, @NotNull ChatSession chat) {
        block2: {
            ToolWindow toolWindow;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
            ThreadingAssertions.assertEventDispatchThread();
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ChatSessionHost> serviceClass$iv = ChatSessionHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((ChatSessionHost)object).persist(chat);
            $i$f$service = false;
            serviceClass$iv = AiToolWindowService.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ToolWindow toolWindow2 = toolWindow = ((AiToolWindowService)object2).getToolWindow(project);
            if (toolWindow2 == null) break block2;
            toolWindow2.activate(() -> AIAssistantChatUtil.openChat$lambda$0(project, chat));
        }
    }

    @RequiresEdt
    public final void updateFont(@NotNull Component root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ThreadingAssertions.assertEventDispatchThread();
        int fontSize = AIAssistantUIUtil.INSTANCE.getToolwindowScaledFontSize();
        JBIterable jBIterable = UIUtil.uiTraverser((Component)root).filter(JComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JComponent it = (JComponent)element$iv;
            boolean bl = false;
            if (it.getClientProperty("AIAssistant.DoNotUpdateFont") != null) continue;
            if (it instanceof TextPartViewEditorPane) {
                ((TextPartViewEditorPane)((Object)it)).patchCSSOnStateChanged();
            } else {
                EditorEx ex = (EditorEx)it.getClientProperty("EditorEx");
                if (ex != null) {
                    ex.setFontSize(fontSize);
                } else {
                    it.setFont(it.getFont().deriveFont((float)fontSize));
                }
            }
            if (!(it instanceof ScrollableChatPanel)) continue;
            ((ScrollableChatPanel)it).updateScrollUnitHeight$intellij_ml_llm_chat();
        }
    }

    public final void applyShortcuts(@NotNull JComponent view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ActionManager actionManager = ActionManager.getInstance();
        AnAction newChatAction = actionManager.getAction("AIAssistant.ToolWindow.NewChatActionAlt");
        if (newChatAction == null) {
            AIAssistantChatUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AIAssistantChatUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Couldn't find ToolWindow.NewChatActionAlt to register shortcuts");
            return;
        }
        newChatAction.registerCustomShortcutSet(newChatAction.getShortcutSet(), view);
    }

    @NotNull
    public final String getMarkdownLanguageId(@NotNull Language language) {
        String displayLanguage;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String string = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return switch (displayLanguage = string3) {
            case "c#" -> "csharp";
            case "c/c++" -> "c++";
            case "f#" -> "fsharp";
            case "Shell Script" -> "bash";
            case "http request" -> "http_request";
            case "razor" -> "cshtml";
            default -> displayLanguage;
        };
    }

    @NotNull
    public final Language findLanguage(@NotNull String languageName) {
        Language language;
        String languageCandidateNames;
        Intrinsics.checkNotNullParameter((Object)languageName, (String)"languageName");
        if (CPP_LANGUAGES.contains(languageName)) {
            Language language2 = Language.findLanguageByID((String)"C++");
            if (language2 == null && (language2 = LanguageUtil.findRegisteredLanguage((String)"C/C++")) == null) {
                Language language3 = Language.ANY;
                language2 = language3;
                Intrinsics.checkNotNullExpressionValue((Object)language3, (String)"ANY");
            }
            return language2;
        }
        switch (languageName) {
            case "csharp": {
                String string = "c#";
                break;
            }
            case "fsharp": {
                String string = "f#";
                break;
            }
            case "bash": {
                String string = "Shell Script";
                break;
            }
            case "http_request": {
                String string = "http request";
                break;
            }
            case "cshtml": {
                String string = "razor";
                break;
            }
            case "go": {
                String string = "golang";
                break;
            }
            default: {
                String string = languageCandidateNames = languageName;
            }
        }
        if ((language = LanguageUtil.findRegisteredLanguage((String)languageCandidateNames)) == null) {
            Language language4 = Language.ANY;
            language = language4;
            Intrinsics.checkNotNullExpressionValue((Object)language4, (String)"ANY");
        }
        return language;
    }

    private static final void openChat$lambda$0(Project $project, ChatSession $chat) {
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<FocusedChatSessionHost> serviceClass$iv = FocusedChatSessionHost.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((FocusedChatSessionHost)object).focusChatSession($chat);
    }

    static {
        Object[] objectArray = new String[]{"c", "C", "cpp", "CPP", "c++", "C++", "c/c++", "C/C++"};
        CPP_LANGUAGES = CollectionsKt.listOf((Object[])objectArray);
    }
}

