/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.lang.Language;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.CodeAtCaretChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.CurrentFileContextAttachmentKt;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ProjectFileContextEntity;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010(\u001a\u0004\u0018\u00010)H\u0096@\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001dH\u0016J\n\u0010.\u001a\u0004\u0018\u00010/H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u00060"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/CodeAtCaretContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ProjectFileContextEntity;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "attachmentName", "Lcom/intellij/ml/llm/privacy/PSString;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "hint", "getHint", "tooltipText", "getTooltipText", "()Ljava/lang/String;", "popupPresentationText", "getPopupPresentationText", "isVisible", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "id", "getId", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "text", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.ml.llm.chat"})
public final class CodeAtCaretContextAttachment
extends ContextAttachmentBase
implements ProjectFileContextEntity {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final PSString attachmentName;
    @NotNull
    private final AtomicProperty<String> name;
    @Nullable
    private final AtomicProperty<String> hint;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final ObservableProperty<Boolean> isVisible;
    @NotNull
    private final String id;
    @NotNull
    private final ContextEntitySource attachedBy;

    public CodeAtCaretContextAttachment(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.project = project;
        this.editor = editor;
        this.attachmentName = ConstantsKt.getPrivacyConst((String)"Code around the caret in the current file:");
        this.name = new AtomicProperty((Object)this.attachmentName.unwrap());
        this.tooltipText = "";
        this.popupPresentationText = "";
        this.isVisible = (ObservableProperty)new AtomicProperty((Object)false);
        this.id = "CODE_AT_CARET";
        this.attachedBy = ContextAttachmentSource.CodeAtCaretRetriever.INSTANCE;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @Nullable
    public AtomicProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @Override
    @NotNull
    public ObservableProperty<Boolean> isVisible() {
        return this.isVisible;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @Override
    @NotNull
    public PSString getText() {
        return (PSString)ActionsKt.runReadAction(() -> CodeAtCaretContextAttachment._get_text_$lambda$0(this));
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        VirtualFile virtualFile2 = this.editor.getVirtualFile();
        FileType fileType = virtualFile2 != null ? virtualFile2.getFileType() : null;
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        Object language = languageFileType != null ? languageFileType.getLanguage() : null;
        Language language2 = language;
        if (language2 == null || (language2 = ExtensionsKtKt.getPrivacySafe((Language)language2)) == null || (language2 = language2.getDisplayName()) == null || (language2 = language2.lowercase()) == null) {
            language2 = ConstantsKt.getEMPTY();
        }
        return new CodeAtCaretChatAttachment(this.attachmentName, PSStringOperatorsKt.wrapCodeIntoMarkdownSnippet((PSString)language2, (PSString)this.getText()), this.getAttachedBy(), (Language)language);
    }

    @Override
    public void performAction(boolean isInMessage) {
    }

    @Override
    @Nullable
    public VirtualFile virtualFile() {
        return this.editor.getVirtualFile();
    }

    private static final PSString _get_text_$lambda$0(CodeAtCaretContextAttachment this$0) {
        Document document = this$0.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int caretOffset = this$0.editor.getCaretModel().getCurrentCaret().getOffset();
        int caretLineNumber = document2.getLineNumber(caretOffset);
        int relativeCaretOffset = caretOffset - document2.getLineStartOffset(caretLineNumber);
        List lines = CollectionsKt.toMutableList((Collection)ExtensionsKtKt.privacySafe((Document)document2, (Project)this$0.getProject()).getText().lines());
        PSString caretLine = (PSString)lines.get(caretLineNumber);
        lines.remove(caretLineNumber);
        lines.add(caretLineNumber, caretLine.substring(0, relativeCaretOffset).plus(CurrentFileContextAttachmentKt.getCARET_MARKER()).plus(caretLine.substring(relativeCaretOffset)));
        return PSStringKt.joinToString$default((Iterable)lines.subList(RangesKt.coerceAtLeast((int)(caretLineNumber - 10), (int)0), RangesKt.coerceAtMost((int)(caretLineNumber + 10), (int)lines.size())), (PrivacySafe)((PrivacySafe)ConstantsKt.getNL()), null, null, (int)0, null, (int)30, null);
    }
}

