/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.DirectoryChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.DirectoryAttachmentFileCounts;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.DirectoryAttachmentTreeNode;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.DirectoryContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.DirectoryTextGenerator;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.DirectoryTreeManager;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.FileContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.UtilKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.rag.ContextPrivacyFilterChecker;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002BB\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0015\b\u0002\u0010\u000b\u001a\u000f\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u0004\u0018\u00010\nJ\u0010\u00104\u001a\u0004\u0018\u000105H\u0096@\u00a2\u0006\u0002\u0010$J\u0010\u00106\u001a\u00020\"2\u0006\u00107\u001a\u00020\u0018H\u0016J\b\u00108\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0016\u00102\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00101\u00a8\u00069"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "passedTree", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryAttachmentTreeNode;", "hint", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/context/ContextEntitySource;Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryAttachmentTreeNode;Lcom/intellij/openapi/observable/properties/ObservableProperty;)V", "getDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getPassedTree", "()Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryAttachmentTreeNode;", "FILES_COUNT_THRESHOLD", "", "treeManagerInitialized", "", "treeManager", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryTreeManager;", "getTreeManager", "()Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryTreeManager;", "treeManager$delegate", "Lkotlin/Lazy;", "textGenerator", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryTextGenerator;", "dispose", "", "getTree", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTreeIfReady", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "icon", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "Ljavax/swing/Icon;", "getIcon", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "tooltipText", "getTooltipText", "()Ljava/lang/String;", "tooltipDescriptionText", "getTooltipDescriptionText", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "performAction", "isInMessage", "toString", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nDirectoryContextAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryContextAttachment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,584:1\n1#2:585\n3829#3:586\n4344#3,2:587\n774#4:589\n865#4,2:590\n1563#4:592\n1634#4,3:593\n*S KotlinDebug\n*F\n+ 1 DirectoryContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/DirectoryContextAttachment\n*L\n94#1:586\n94#1:587,2\n95#1:589\n95#1:590,2\n96#1:592\n96#1:593,3\n*E\n"})
public class DirectoryContextAttachment
extends FileContextAttachment
implements Disposable {
    @NotNull
    private final VirtualFile directory;
    @Nullable
    private final DirectoryAttachmentTreeNode passedTree;
    private final int FILES_COUNT_THRESHOLD;
    private boolean treeManagerInitialized;
    @NotNull
    private final Lazy treeManager$delegate;
    @NotNull
    private final DirectoryTextGenerator textGenerator;
    @NotNull
    private final AtomicProperty<Icon> icon;

    public DirectoryContextAttachment(@NotNull Project project, @NotNull VirtualFile directory, @NotNull ContextEntitySource attachedBy, @Nullable DirectoryAttachmentTreeNode passedTree, @Nullable ObservableProperty<String> hint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
        super(project, directory, attachedBy, hint);
        this.directory = directory;
        this.passedTree = passedTree;
        this.FILES_COUNT_THRESHOLD = 500;
        this.treeManager$delegate = LazyKt.lazy(() -> DirectoryContextAttachment.treeManager_delegate$lambda$0(this, project));
        this.textGenerator = new DirectoryTextGenerator(project);
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("VirtualFile must be a directory");
        }
        this.icon = new AtomicProperty((Object)AllIcons.Nodes.Folder);
    }

    public /* synthetic */ DirectoryContextAttachment(Project project, VirtualFile virtualFile2, ContextEntitySource contextEntitySource, DirectoryAttachmentTreeNode directoryAttachmentTreeNode, ObservableProperty observableProperty, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            directoryAttachmentTreeNode = null;
        }
        if ((n & 0x10) != 0) {
            observableProperty = null;
        }
        this(project, virtualFile2, contextEntitySource, directoryAttachmentTreeNode, (ObservableProperty<String>)observableProperty);
    }

    @NotNull
    protected final VirtualFile getDirectory() {
        return this.directory;
    }

    @Nullable
    protected final DirectoryAttachmentTreeNode getPassedTree() {
        return this.passedTree;
    }

    private final DirectoryTreeManager getTreeManager() {
        Lazy lazy = this.treeManager$delegate;
        return (DirectoryTreeManager)lazy.getValue();
    }

    public void dispose() {
        if (this.treeManagerInitialized) {
            Disposer.dispose((Disposable)this.getTreeManager());
        }
    }

    @Nullable
    public final Object getTree(@NotNull Continuation<? super DirectoryAttachmentTreeNode> $completion) {
        return this.getTreeManager().getTree($completion);
    }

    @Nullable
    public final DirectoryAttachmentTreeNode getTreeIfReady() {
        return Registry.Companion.is("llm.chat.folder.attachments.enabled") ? this.getTreeManager().getTreeIfReady() : null;
    }

    @Override
    @NotNull
    public PSString getText() {
        return Registry.Companion.is("llm.chat.folder.attachments.enabled") ? (PSString)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PSString>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ DirectoryContextAttachment this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DirectoryContextAttachment.access$getTreeManager(this.this$0).getTree((Continuation<? super DirectoryAttachmentTreeNode>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        tree = (DirectoryAttachmentTreeNode)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)tree);
                        this.label = 2;
                        v1 = DirectoryContextAttachment.access$getTextGenerator$p(this.this$0).generateDirectoryText(tree, (Continuation<? super PSString>)((Continuation)this));
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        tree = (DirectoryAttachmentTreeNode)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super PSString> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })) : (PSString)ActionsKt.runReadAction(() -> DirectoryContextAttachment._get_text_$lambda$4(this));
    }

    @Override
    @NotNull
    public AtomicProperty<Icon> getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        CharSequence charSequence;
        CharSequence charSequence2 = UtilKt.toProjectRelativePath(this.getProject(), this.virtualFile());
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "~";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @Override
    @Nullable
    public String getTooltipDescriptionText() {
        DirectoryAttachmentTreeNode directoryAttachmentTreeNode = this.getTreeManager().getTreeIfReady();
        if (directoryAttachmentTreeNode == null) {
            return null;
        }
        DirectoryAttachmentTreeNode tree = directoryAttachmentTreeNode;
        DirectoryAttachmentFileCounts counts = tree.getFileCounts();
        if (tree.getThresholdReached()) {
            Object[] objectArray = new Object[]{this.FILES_COUNT_THRESHOLD};
            return LLMBundle.message((String)"context.attachment.folder.tooltip.description.exceeds.threshold", (Object[])objectArray);
        }
        if (counts.getCount() == 0 && counts.getExcludedCount() == 0) {
            return null;
        }
        if (counts.getExcludedCount() == 0) {
            Object[] objectArray = new Object[]{counts.getCount()};
            return LLMBundle.message((String)"context.attachment.folder.tooltip.description.files.only", (Object[])objectArray);
        }
        Object[] objectArray = new Object[]{counts.getCount(), counts.getExcludedCount()};
        return LLMBundle.message((String)"context.attachment.folder.tooltip.description.files.and.aiignored", (Object[])objectArray);
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return DirectoryContextAttachment.createChatAttachment$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object createChatAttachment$suspendImpl(DirectoryContextAttachment $this, Continuation<? super ChatAttachment> $completion) {
        if (!($completion instanceof createChatAttachment.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ DirectoryContextAttachment this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DirectoryContextAttachment.createChatAttachment$suspendImpl(this.this$0, (Continuation<? super ChatAttachment>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!$this.directory.isValid()) {
                    return null;
                }
                var7_5 = null;
                var6_6 = $this.getAttachedBy();
                var5_7 = $this.getText();
                var4_8 = ExtensionsKtKt.getPrivacySafe((VirtualFile)$this.directory).getName();
                var3_9 = $this.directory;
                var2_10 = $this.getProject();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = var2_10;
                $continuation.L$2 = var3_9;
                $continuation.L$3 = var4_8;
                $continuation.L$4 = var5_7;
                $continuation.L$5 = var6_6;
                $continuation.label = 1;
                v0 = $this.getTreeManager().getTree((Continuation<? super DirectoryAttachmentTreeNode>)$continuation);
                if (v0 == var20_4) {
                    return var20_4;
                }
                ** GOTO lbl41
            }
            case 1: {
                var7_5 = null;
                var6_6 = (ContextEntitySource)$continuation.L$5;
                var5_7 = (PSString)$continuation.L$4;
                var4_8 = (PSString)$continuation.L$3;
                var3_9 = (VirtualFile)$continuation.L$2;
                var2_10 = (Project)$continuation.L$1;
                $this = (DirectoryContextAttachment)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl41:
                // 2 sources

                var8_11 = v0;
                var11_12 = null;
                var12_13 = 32;
                var13_14 = (DirectoryAttachmentTreeNode)var8_11;
                var14_15 = var7_5;
                var15_16 = var6_6;
                var16_17 = var5_7;
                var17_18 = var4_8;
                var18_19 = var3_9;
                var19_20 = var2_10;
                return new DirectoryChatAttachment(var19_20, var18_19, var17_18, var16_17, var15_16, var14_15, var13_14, var12_13, var11_12);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void performAction(boolean isInMessage) {
        block2: {
            VirtualFile virtualFile2 = this.virtualFile();
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile directory = virtualFile2;
            if (!directory.isValid()) break block2;
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.getProject()).getToolWindow("Project");
            if (toolWindow != null) {
                toolWindow.activate(() -> DirectoryContextAttachment.performAction$lambda$6(this, directory));
            }
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "DirectoryContextAttachment(directory=" + this.getFile().getName() + ", attachedBy=" + this.getAttachedBy() + ", id='" + this.getId() + "')";
    }

    private static final DirectoryTreeManager treeManager_delegate$lambda$0(DirectoryContextAttachment this$0, Project $project) {
        this$0.treeManagerInitialized = true;
        return new DirectoryTreeManager(this$0.directory, $project, this$0.FILES_COUNT_THRESHOLD, this$0.passedTree);
    }

    /*
     * WARNING - void declaration
     */
    private static final PSString _get_text_$lambda$4(DirectoryContextAttachment this$0) {
        void $this$mapTo$iv$iv;
        VirtualFile it;
        Object $this$filterTo$iv$iv;
        ContextPrivacyFilterChecker privacyChecker = ContextPrivacyFilterChecker.Companion.getInstance(this$0.getProject());
        VirtualFile[] virtualFileArray = this$0.directory.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        Object $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it2 = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!it2.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(privacyChecker, it, null){
                int label;
                final /* synthetic */ ContextPrivacyFilterChecker $privacyChecker;
                final /* synthetic */ VirtualFile $it;
                {
                    this.$privacyChecker = $privacyChecker;
                    this.$it = $it;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            VirtualFile virtualFile2 = this.$it;
                            Intrinsics.checkNotNull((Object)virtualFile2);
                            this.label = 1;
                            Object object2 = this.$privacyChecker.passesPrivacyFilters(virtualFile2, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }))).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(ExtensionsKtKt.getPrivacySafe((VirtualFile)it).getName());
        }
        PSString fileListContent2 = PSStringKt.joinToString$default((Iterable)((List)destination$iv$iv), (PrivacySafe)((PrivacySafe)ConstantsKt.getNL()), null, null, (int)0, null, (int)30, null);
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((VirtualFile)this$0.directory).getPath(), fileListContent2};
        return ConstantsKt.getPrivacyConst((String)"\n      Directory: %s\n      \n      Contents:\n      %s\n      ").format(pSStringConvertibleArray).trimIndent();
    }

    private static final void performAction$lambda$6(DirectoryContextAttachment this$0, VirtualFile $directory) {
        ProjectView.getInstance((Project)this$0.getProject()).select(null, $directory, true);
    }

    public static final /* synthetic */ DirectoryTreeManager access$getTreeManager(DirectoryContextAttachment $this) {
        return $this.getTreeManager();
    }

    public static final /* synthetic */ DirectoryTextGenerator access$getTextGenerator$p(DirectoryContextAttachment $this) {
        return $this.textGenerator;
    }
}

