/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.SummarizedWebSearchAnswerContextChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010)\u001a\u00020*H\u0096@\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0019\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u0014\u0010\u0018\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000fR\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006/"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/SummarizedWebSearchAnswerContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "project", "Lcom/intellij/openapi/project/Project;", "answer", "Lcom/intellij/ml/llm/privacy/PSString;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/privacy/PSString;)V", "id", "", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "hint", "getHint", "text", "Lcom/intellij/openapi/util/NlsSafe;", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "tooltipText", "getTooltipText", "popupPresentationText", "getPopupPresentationText", "isVisible", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "icon", "Ljavax/swing/Icon;", "getIcon", "attachedBy", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource$WebSearchRetriever;", "getAttachedBy", "()Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource$WebSearchRetriever;", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "intellij.ml.llm.chat"})
public final class SummarizedWebSearchAnswerContextAttachment
extends ContextAttachmentBase {
    @NotNull
    private final Project project;
    @NotNull
    private final PSString answer;
    @NotNull
    private final AtomicProperty<String> name;
    @NotNull
    private final AtomicProperty<String> hint;
    @NotNull
    private final AtomicProperty<Icon> icon;
    @NotNull
    private final ContextAttachmentSource.WebSearchRetriever attachedBy;
    @NotNull
    private final ContextEntityPrivacy privacy;

    public SummarizedWebSearchAnswerContextAttachment(@NotNull Project project, @NotNull PSString answer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)answer, (String)"answer");
        this.project = project;
        this.answer = answer;
        this.name = new AtomicProperty((Object)this.answer.unwrap());
        this.hint = new AtomicProperty((Object)"Summarized Answer");
        this.icon = new AtomicProperty((Object)MLLlmIcons.WebSearch.WebSearchOn);
        this.attachedBy = ContextAttachmentSource.WebSearchRetriever.INSTANCE;
        this.privacy = (ContextEntityPrivacy)ContextEntityPrivacy.Unrelated.INSTANCE;
    }

    @NotNull
    public String getId() {
        return "ANSWER";
    }

    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @NotNull
    public AtomicProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.answer;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return (String)this.answer.unwrap();
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return (String)this.answer.unwrap();
    }

    @Override
    @NotNull
    public ObservableProperty<Boolean> isVisible() {
        return (ObservableProperty)new AtomicProperty((Object)false);
    }

    @NotNull
    public AtomicProperty<Icon> getIcon() {
        return this.icon;
    }

    @NotNull
    public ContextAttachmentSource.WebSearchRetriever getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return this.privacy;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new SummarizedWebSearchAnswerContextChatAttachment(this.answer);
    }

    @Override
    public void performAction(boolean isInMessage) {
        LightVirtualFile file = new LightVirtualFile("Answer", this.answer.unwrap());
        FileEditorManager.getInstance((Project)this.project).openFile((VirtualFile)file, true);
    }
}

