/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.WebSearchChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantExternalLinksKt;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.WebSearchContextAttachmentKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u00100\u001a\u000201H\u0096@\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u0016\u0010\"\u001a\u0004\u0018\u00010#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000fR\u0014\u0010(\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001bR\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001f\u00a8\u00067"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/WebSearchContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "url", "Lcom/intellij/ml/llm/privacy/PSString;", "title", "content", "siteName", "publishedDate", "faviconIcon", "Ljavax/swing/Icon;", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Ljavax/swing/Icon;Lcom/intellij/ml/llm/context/ContextEntitySource;)V", "getUrl", "()Lcom/intellij/ml/llm/privacy/PSString;", "getTitle", "getContent", "getSiteName", "getPublishedDate", "getFaviconIcon", "()Ljavax/swing/Icon;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "id", "", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "tooltipText", "getTooltipText", "hint", "", "getHint", "()Ljava/lang/Void;", "text", "getText", "popupPresentationText", "getPopupPresentationText", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "icon", "getIcon", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "intellij.ml.llm.chat"})
public final class WebSearchContextAttachment
extends ContextAttachmentBase {
    @NotNull
    private final PSString url;
    @NotNull
    private final PSString title;
    @NotNull
    private final PSString content;
    @NotNull
    private final PSString siteName;
    @Nullable
    private final PSString publishedDate;
    @Nullable
    private final Icon faviconIcon;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    private final String id;
    @NotNull
    private final AtomicProperty<String> name;
    @NotNull
    private final String tooltipText;
    @Nullable
    private final Void hint;
    @NotNull
    private final PSString text;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final ContextEntityPrivacy privacy;
    @NotNull
    private final AtomicProperty<Icon> icon;

    public WebSearchContextAttachment(@NotNull PSString url, @NotNull PSString title2, @NotNull PSString content2, @NotNull PSString siteName, @Nullable PSString publishedDate, @Nullable Icon faviconIcon, @NotNull ContextEntitySource attachedBy) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)siteName, (String)"siteName");
        Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
        this.url = url;
        this.title = title2;
        this.content = content2;
        this.siteName = siteName;
        this.publishedDate = publishedDate;
        this.faviconIcon = faviconIcon;
        this.attachedBy = attachedBy;
        this.id = (String)this.url.unwrap();
        this.name = new AtomicProperty((Object)this.title.unwrap());
        this.tooltipText = "Web page content: " + this.title.unwrap();
        this.text = this.title;
        this.popupPresentationText = (String)this.title.unwrap();
        this.privacy = (ContextEntityPrivacy)ContextEntityPrivacy.Unrelated.INSTANCE;
        Icon icon = this.faviconIcon;
        if (icon == null) {
            Icon icon2 = AllIcons.General.Web;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Web");
        }
        this.icon = new AtomicProperty((Object)icon);
    }

    public /* synthetic */ WebSearchContextAttachment(PSString pSString, PSString pSString2, PSString pSString3, PSString pSString4, PSString pSString5, Icon icon, ContextEntitySource contextEntitySource, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            pSString5 = null;
        }
        if ((n & 0x20) != 0) {
            icon = null;
        }
        if ((n & 0x40) != 0) {
            contextEntitySource = ContextAttachmentSource.WebSearchRetriever.INSTANCE;
        }
        this(pSString, pSString2, pSString3, pSString4, pSString5, icon, contextEntitySource);
    }

    @NotNull
    public final PSString getUrl() {
        return this.url;
    }

    @NotNull
    public final PSString getTitle() {
        return this.title;
    }

    @NotNull
    public final PSString getContent() {
        return this.content;
    }

    @NotNull
    public final PSString getSiteName() {
        return this.siteName;
    }

    @Nullable
    public final PSString getPublishedDate() {
        return this.publishedDate;
    }

    @Nullable
    public final Icon getFaviconIcon() {
        return this.faviconIcon;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @Nullable
    public Void getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.text;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return this.privacy;
    }

    @NotNull
    public AtomicProperty<Icon> getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new WebSearchChatAttachment(this.url, this.title, this.content, this.faviconIcon, this.publishedDate, this.siteName, ChatAttachment.Kind.Visible, this.getAttachedBy());
    }

    @Override
    public void performAction(boolean isInMessage) {
        try {
            Project project = ProjectManager.getInstance().getDefaultProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getDefaultProject(...)");
            AIAssistantExternalLinksKt.openAiGeneratedLink(project, (String)this.url.unwrap());
        }
        catch (Exception ex) {
            WebSearchContextAttachmentKt.access$getLOGGER$p().error("Failed to open attached web page: " + this.url.unwrap(), (Throwable)ex);
        }
    }
}

