/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.chat;

import ai.grazie.model.task.id.TaskName;
import com.intellij.DynamicBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.chat.context.ChatContextItem;
import com.intellij.ml.llm.core.chat.session.ChatCreationContext;
import com.intellij.ml.llm.core.chat.session.ChatCreationContextWithSelection;
import com.intellij.ml.llm.core.chat.session.ChatOrigin;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.ChatIntentionTaskParameters;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.ExplainCodeTaskCallBuilder;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.PrivacySafeTaskCall;
import com.intellij.ml.llm.grazie.tasks.intentions.ExplainCodeTask;
import com.intellij.ml.llm.intentions.PsiElementLanguageNameProvider;
import com.intellij.ml.llm.intentions.chat.AbstractChatIntention;
import com.intellij.ml.llm.intentions.chat.ChatIntentionTarget;
import com.intellij.ml.llm.intentions.chat.ExplainCodeChatIntentionKt;
import com.intellij.ml.llm.intentions.chat.InjectedCodeTarget;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0015J\b\u0010\u001e\u001a\u00020\u0005H\u0016J0\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\u00122\b\u0010#\u001a\u0004\u0018\u00010$H\u0094@\u00a2\u0006\u0002\u0010%J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010*\u001a\u00020+H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006,"}, d2={"Lcom/intellij/ml/llm/intentions/chat/ExplainCodeChatIntention;", "Lcom/intellij/ml/llm/intentions/chat/AbstractChatIntention;", "<init>", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "getText", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "computeTitle", "file", "getPrompt", "Lcom/intellij/ml/llm/intentions/chat/AbstractChatIntention$Prompt;", "intentionTarget", "Lcom/intellij/ml/llm/intentions/chat/ChatIntentionTarget;", "getContextItems", "", "Lcom/intellij/ml/llm/core/chat/context/ChatContextItem;", "elementToExplain", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "getChatCreationContext", "Lcom/intellij/ml/llm/core/chat/session/ChatCreationContext;", "extraItems", "sourceFile", "selectionRange", "Lcom/intellij/openapi/editor/RangeMarker;", "(Ljava/util/List;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/RangeMarker;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createTask", "Lcom/intellij/ml/llm/grazie/adapters/tasksFacade/PrivacySafeTaskCall;", "parameters", "Lcom/intellij/ml/llm/grazie/adapters/tasksFacade/ChatIntentionTaskParameters;", "getTaskName", "Lai/grazie/model/task/id/TaskName;", "intellij.ml.llm.chat"})
public class ExplainCodeChatIntention
extends AbstractChatIntention {
    @NotNull
    private String title = "";

    public ExplainCodeChatIntention() {
        super(null, 1, null);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.title = string;
    }

    @NotNull
    public String getText() {
        return this.title;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || psiFile == null || !AIAssistantUIUtil.INSTANCE.hasAvailableLlmProfileId(LLMPromptsKt.getChatPromptId((ChatSourceAction)ChatSourceAction.EXPLAIN_CODE_INTENTION))) {
            return false;
        }
        this.title = this.computeTitle(project, psiFile);
        return super.isAvailable(project, editor, psiFile);
    }

    private final String computeTitle(Project project, PsiFile file) {
        if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(file)) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)file.getLanguage().getDisplayName(), (String)"getDisplayName(...)");
            return LLMBundle.message((String)"intentions.chat.explain.fragment.name", (Object[])objectArray);
        }
        return LLMBundle.message((String)"intentions.chat.explain.code.name", (Object[])new Object[0]);
    }

    @Override
    @Deprecated(message="Use Task API instead", replaceWith=@ReplaceWith(expression="createTask(builder, intentionTarget)", imports={}))
    @Nullable
    public AbstractChatIntention.Prompt getPrompt(@NotNull Project project, @Nullable Editor editor, @NotNull ChatIntentionTarget intentionTarget) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)intentionTarget, (String)"intentionTarget");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(intentionTarget.getSelectedElements());
        if (psiElement == null) {
            psiElement = (PsiElement)intentionTarget.getFile();
        }
        PsiElement element = psiElement;
        PSString lang = PsiElementLanguageNameProvider.Companion.getLanguageNameForElement(element);
        PSString kind = intentionTarget instanceof InjectedCodeTarget ? ConstantsKt.getPrivacyConst((String)"expression") : ConstantsKt.getPrivacyConst((String)"code");
        PSString[] pSStringArray = new PSString[]{lang, kind};
        PSString displayPrompt = PSStringOperatorsKt.getMessagePrivacySafe((DynamicBundle)((DynamicBundle)LLMBundle.INSTANCE), (String)"intentions.chat.explain.code.prompt.message", (PSString[])pSStringArray).plus(AbstractChatIntention.Companion.getSELECTION_CODE_PROMPT_PART());
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{lang, kind, AbstractChatIntention.Companion.getSELECTION_CODE_PROMPT_PART()};
        PSString internalPrompt = ConstantsKt.getPrivacyConst((String)"Explain the following %s %s:%s").format(pSStringConvertibleArray);
        return new AbstractChatIntention.Prompt(displayPrompt, internalPrompt);
    }

    @Override
    @Deprecated(message="Use Task API instead", replaceWith=@ReplaceWith(expression="createTask(builder, intentionTarget)", imports={}))
    @NotNull
    protected List<ChatContextItem> getContextItems(@Nullable PsiElement elementToExplain) {
        if (elementToExplain instanceof PsiFile && InjectedLanguageManager.getInstance((Project)((PsiFile)elementToExplain).getProject()).isInjectedFragment((PsiFile)elementToExplain)) {
            return CollectionsKt.listOf((Object)ExplainCodeChatIntentionKt.getEXPLAIN_CHAT_INTENTION_CONTEXT_ITEM());
        }
        return super.getContextItems(elementToExplain);
    }

    @NotNull
    public String getFamilyName() {
        return LLMBundle.message((String)"intention.category.small.on.selected.code", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    protected Object getChatCreationContext(@NotNull List<ChatContextItem> extraItems, @Nullable PsiFile sourceFile, @Nullable RangeMarker selectionRange, @NotNull Continuation<? super ChatCreationContext> $completion) {
        return ExplainCodeChatIntention.getChatCreationContext$suspendImpl(this, extraItems, sourceFile, selectionRange, $completion);
    }

    static /* synthetic */ Object getChatCreationContext$suspendImpl(ExplainCodeChatIntention $this, List<ChatContextItem> extraItems, PsiFile sourceFile, RangeMarker selectionRange, Continuation<? super ChatCreationContext> $completion) {
        return new ChatCreationContextWithSelection(ChatOrigin.CustomIntention.INSTANCE, ChatSourceAction.EXPLAIN_CODE_INTENTION, sourceFile, extraItems, null, selectionRange, 16, null);
    }

    @Override
    @Nullable
    protected PrivacySafeTaskCall createTask(@NotNull ChatIntentionTaskParameters parameters, @NotNull ChatIntentionTarget intentionTarget) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)intentionTarget, (String)"intentionTarget");
        boolean isCodeFragment = intentionTarget instanceof InjectedCodeTarget;
        return new ExplainCodeTaskCallBuilder(parameters, isCodeFragment).build();
    }

    @Override
    @NotNull
    protected TaskName getTaskName() {
        return ExplainCodeTask.INSTANCE.getName();
    }
}

