/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.vfs.provider;

import ai.grazie.code.files.model.FileMetadata;
import ai.grazie.code.files.model.FileSystemProvider;
import ai.grazie.code.files.vfs.VirtualPath;
import ai.grazie.code.files.vfs.VirtualSink;
import ai.grazie.code.files.vfs.VirtualSource;
import ai.grazie.code.files.vfs.memory.ExtensionsKt;
import ai.grazie.code.files.vfs.memory.VirtualEntry;
import ai.grazie.code.files.vfs.memory.VirtualFile;
import ai.grazie.code.files.vfs.memory.VirtualFileSystem;
import ai.grazie.code.files.vfs.memory.VirtualFolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0017J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\fJ \u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0097@\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\fJ&\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0096@\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\fJ\u001e\u0010'\u001a\u00020(2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010*J\u001e\u0010+\u001a\u00020!2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010-J\u001e\u0010.\u001a\u00020!2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010/\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0018J\u001e\u00100\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u00101R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lai/grazie/code/files/vfs/provider/VfsFileSystemProvider;", "Lai/grazie/code/files/model/FileSystemProvider$ReadWrite;", "Lai/grazie/code/files/vfs/VirtualPath;", "fs", "Lai/grazie/code/files/vfs/memory/VirtualFileSystem;", "<init>", "(Lai/grazie/code/files/vfs/memory/VirtualFileSystem;)V", "toPathString", "", "path", "toAbsolutePathString", "name", "(Lai/grazie/code/files/vfs/VirtualPath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extension", "fromAbsoluteString", "fromRelativeString", "base", "metadata", "Lai/grazie/code/files/model/FileMetadata;", "list", "", "parent", "relative", "root", "(Lai/grazie/code/files/vfs/VirtualPath;Lai/grazie/code/files/vfs/VirtualPath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "relativize", "exists", "", "read", "", "size", "", "create", "", "type", "Lai/grazie/code/files/model/FileMetadata$FileType;", "(Lai/grazie/code/files/vfs/VirtualPath;Ljava/lang/String;Lai/grazie/code/files/model/FileMetadata$FileType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "source", "Lkotlinx/io/Source;", "sink", "Lkotlinx/io/Sink;", "append", "(Lai/grazie/code/files/vfs/VirtualPath;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "write", "content", "(Lai/grazie/code/files/vfs/VirtualPath;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "move", "target", "delete", "(Lai/grazie/code/files/vfs/VirtualPath;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "code-files-vfs"})
@SourceDebugExtension(value={"SMAP\nVfsFileSystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsFileSystemProvider.kt\nai/grazie/code/files/vfs/provider/VfsFileSystemProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1563#2:108\n1634#2,3:109\n*S KotlinDebug\n*F\n+ 1 VfsFileSystemProvider.kt\nai/grazie/code/files/vfs/provider/VfsFileSystemProvider\n*L\n53#1:108\n53#1:109,3\n*E\n"})
public final class VfsFileSystemProvider
implements FileSystemProvider.ReadWrite<VirtualPath> {
    @NotNull
    private final VirtualFileSystem fs;

    public VfsFileSystemProvider(@NotNull VirtualFileSystem fs) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        this.fs = fs;
    }

    @Override
    @Deprecated(message="Use toAbsolutePathString instead", replaceWith=@ReplaceWith(expression="toAbsolutePathString(path)", imports={}))
    @NotNull
    public String toPathString(@NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.toString();
    }

    @Override
    @NotNull
    public String toAbsolutePathString(@NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.toString();
    }

    @Override
    @Nullable
    public Object name(@NotNull VirtualPath path, @NotNull Continuation<? super String> $completion) {
        return path.getName();
    }

    @Override
    @Nullable
    public Object extension(@NotNull VirtualPath path, @NotNull Continuation<? super String> $completion) {
        return path.getExtension();
    }

    @Override
    @NotNull
    public VirtualPath fromAbsoluteString(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return VirtualPath.Companion.of(path);
    }

    @Override
    @NotNull
    public VirtualPath fromRelativeString(@NotNull VirtualPath base, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return base.resolve(path);
    }

    @Override
    @Nullable
    public Object metadata(@NotNull VirtualPath path, @NotNull Continuation<? super FileMetadata> $completion) {
        VirtualFile file = this.fs.getFile(path);
        VirtualFolder folder = this.fs.getFolder(path);
        return file != null ? new FileMetadata(FileMetadata.FileType.File, path.isHidden(), FileMetadata.FileContent.Text) : (folder != null ? new FileMetadata(FileMetadata.FileType.Directory, path.isHidden(), FileMetadata.FileContent.Inapplicable) : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object list(@NotNull VirtualPath path, @NotNull Continuation<? super List<VirtualPath>> $completion) {
        void $this$mapTo$iv$iv;
        VirtualFolder virtualFolder = this.fs.getFolder(path);
        if (virtualFolder == null) {
            throw new IllegalStateException(("Directory not found: " + path).toString());
        }
        VirtualFolder folder = virtualFolder;
        Iterable $this$map$iv = folder.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualEntry virtualEntry = (VirtualEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Object parent(@NotNull VirtualPath path, @NotNull Continuation<? super VirtualPath> $completion) {
        return path.getParent();
    }

    @Override
    @Deprecated(message="Use relativize instead", replaceWith=@ReplaceWith(expression="relativize(root, path)", imports={}))
    @Nullable
    public Object relative(@NotNull VirtualPath root, @NotNull VirtualPath path, @NotNull Continuation<? super String> $completion) {
        return this.relativize(root, path, $completion);
    }

    @Override
    @Nullable
    public Object relativize(@NotNull VirtualPath root, @NotNull VirtualPath path, @NotNull Continuation<? super String> $completion) {
        return path.isChildOf(root) ? StringsKt.removePrefix((String)StringsKt.removePrefix((String)path.toString(), (CharSequence)root.toString()), (CharSequence)"/") : null;
    }

    @Override
    @Nullable
    public Object exists(@NotNull VirtualPath path, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((this.fs.getFile(path) != null || this.fs.getFolder(path) != null ? 1 : 0) != 0);
    }

    @Override
    @Nullable
    public Object read(@NotNull VirtualPath path, @NotNull Continuation<? super byte[]> $completion) {
        Object object;
        block3: {
            block2: {
                object = this.fs.getFile(path);
                if (object == null) break block2;
                byte[] byArray = object.getContent();
                object = byArray;
                if (byArray != null) break block3;
            }
            object = new byte[0];
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Object size(@NotNull VirtualPath path, @NotNull Continuation<? super Long> $completion) {
        long l;
        Object object = this.fs.getFile(path);
        if (object != null) {
            byte[] byArray = object.getContent();
            object = byArray;
            if (byArray != null) {
                l = ((Object)object).length;
                return Boxing.boxLong((long)l);
            }
        }
        l = 0L;
        return Boxing.boxLong((long)l);
    }

    @Override
    @Nullable
    public Object create(@NotNull VirtualPath parent2, @NotNull String name2, @NotNull FileMetadata.FileType type, @NotNull Continuation<? super Unit> $completion) {
        VirtualPath path = parent2.resolve(name2);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                VirtualEntry virtualEntry = VirtualFileSystem.createFile$default(this.fs, path, null, 2, null);
                break;
            }
            case 2: {
                VirtualEntry virtualEntry = this.fs.createFolders(path);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object source(@NotNull VirtualPath path, @NotNull Continuation<? super Source> $completion) {
        return CoreKt.buffered((RawSource)new VirtualSource(this.fs, path));
    }

    @Override
    @Nullable
    public Object sink(@NotNull VirtualPath path, boolean append, @NotNull Continuation<? super Sink> $completion) {
        return CoreKt.buffered((RawSink)new VirtualSink(this.fs, path, append));
    }

    @Override
    @Nullable
    public Object write(@NotNull VirtualPath path, @NotNull byte[] content2, @NotNull Continuation<? super Unit> $completion) {
        ExtensionsKt.writeFile(this.fs, path, content2);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object move(@NotNull VirtualPath source2, @NotNull VirtualPath target, @NotNull Continuation<? super Unit> $completion) {
        this.fs.move(source2, target);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object delete(@NotNull VirtualPath parent2, @NotNull String name2, @NotNull Continuation<? super Unit> $completion) {
        this.fs.delete(parent2.resolve(name2));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileMetadata.FileType.values().length];
            try {
                nArray[FileMetadata.FileType.File.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileMetadata.FileType.Directory.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

