/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\f\u0010\t\u001a\u00020\n*\u00020\u0005H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/FileUtil;", "", "<init>", "()V", "createFileCreatingDirsIfMissing", "Lcom/intellij/openapi/vfs/VirtualFile;", "baseDir", "path", "Ljava/nio/file/Path;", "isEmpty", "", "ej-core"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();

    private FileUtil() {
    }

    @RequiresWriteLock
    @Nullable
    public final VirtualFile createFileCreatingDirsIfMissing(@NotNull VirtualFile baseDir, @NotNull Path path) {
        VirtualFile startDir;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean isAbsolutePath = path.isAbsolute();
        Path parentDir = path.getParent();
        String fileName = ((Object)path.getFileName()).toString();
        boolean bl = isAbsolutePath;
        if (bl) {
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Path path2 = parentDir;
            Intrinsics.checkNotNull((Object)path2);
            virtualFile = virtualFileManager.findFileByNioPath(path2);
            if (virtualFile == null) {
                virtualFile = VfsUtil.createDirectoryIfMissing((String)((Object)parentDir).toString());
            }
        } else if (!bl) {
            Path parentPath = path.getParent();
            virtualFile = parentPath != null ? VfsUtil.createDirectoryIfMissing((VirtualFile)baseDir, (String)((Object)parentPath).toString()) : baseDir;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        VirtualFile virtualFile2 = startDir = virtualFile;
        return virtualFile2 != null ? virtualFile2.createChildData((Object)this, fileName) : null;
    }

    @RequiresReadLock
    public final boolean isEmpty(@NotNull VirtualFile $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return ((CharSequence)VirtualFileUtil.readText((VirtualFile)$this$isEmpty)).length() == 0;
    }
}

