/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import com.intellij.ml.llm.matterhorn.AgentAction;
import com.intellij.ml.llm.matterhorn.Argument;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.FileWithLine;
import com.intellij.ml.llm.matterhorn.Result;
import com.intellij.ml.llm.matterhorn.StepMetadataKt;
import com.intellij.ml.llm.matterhorn.StepType;
import com.intellij.ml.llm.matterhorn.actions.ActionRequest;
import com.intellij.ml.llm.matterhorn.actions.ActionUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.AgentUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.OpenFileAgentAction;
import com.intellij.ml.llm.matterhorn.actions.OpenFileAgentActionKt;
import com.intellij.ml.llm.matterhorn.llm.ArgumentType;
import com.intellij.ml.llm.matterhorn.llm.ParameterValue;
import com.intellij.ml.llm.matterhorn.relevance.extractors.ElementProvider;
import com.intellij.ml.llm.matterhorn.run.ExecutionPath;
import com.intellij.ml.llm.matterhorn.run.LocalPath;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J(\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0082@\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/OpenFileAgentAction;", "Lcom/intellij/ml/llm/matterhorn/AgentAction;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "arguments", "", "Lcom/intellij/ml/llm/matterhorn/Argument;", "getArguments", "()Ljava/util/List;", "docstring", "getDocstring", "execute", "request", "Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "(Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFileImports", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Lcom/intellij/ml/llm/matterhorn/run/ExecutionPath;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/matterhorn/run/ExecutionPath;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "ej-core"})
@SourceDebugExtension(value={"SMAP\nOpenFileAgentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenFileAgentAction.kt\ncom/intellij/ml/llm/matterhorn/actions/OpenFileAgentAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class OpenFileAgentAction
implements AgentAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<Argument> arguments;
    @NotNull
    private final String docstring;
    @NotNull
    public static final String PATH_ARGUMENT = "path";
    @NotNull
    public static final String LINE_NUMBER_ARGUMENT = "line_number";

    public OpenFileAgentAction() {
        this.name = "open";
        Object[] objectArray = new Argument[]{new Argument(PATH_ARGUMENT, ArgumentType.STRING, "the full path to the file to open", false, false, 24, null), new Argument(LINE_NUMBER_ARGUMENT, ArgumentType.INTEGER, "the line number where the view window will start. If this parameter is omitted, the view window will start from the first line.", true, false, 16, null)};
        this.arguments = CollectionsKt.listOf((Object[])objectArray);
        this.docstring = ((Object)StringsKt.trim((CharSequence)"Open 100 lines of the specified file in the editor, starting from the specified line number.\nSince files are often larger than the visible window, specifying the line number helps you view a specific section of the code.\nInformation from [Tag: RelevantCode], as well as the commands `get_file_structure` and `search_project` can help identify the relevant lines.")).toString();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public String getDocstring() {
        return this.docstring;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object execute(@NotNull ActionRequest var1_1, @NotNull ExecutionAgentContext var2_2, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ OpenFileAgentAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.label = 1;
                v0 = this.getInputParams((ActionRequest)request, (Continuation<? super Map<String, ParameterValue>>)$continuation);
                if (v0 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                context = (ExecutionAgentContext)$continuation.L$1;
                this = (OpenFileAgentAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                params = (Map)v0;
                v1 = ActionUtilsKt.tryGetNonEmptyStringValue((ParameterValue)params.get("path"));
                if (v1 == null) {
                    return "ERROR: path is missing or invalid";
                }
                pathStr = v1;
                lineNumberStr = (ParameterValue)params.get("line_number");
                if (lineNumberStr != null) {
                    v2 = ActionUtilsKt.tryGetIntValue(lineNumberStr);
                    if (v2 == null) {
                        return "ERROR: Can't parse line number: \"" + lineNumberStr + "\"";
                    }
                    v3 = Boxing.boxInt((int)v2);
                } else {
                    v3 = null;
                }
                lineNumber = v3;
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = lineNumber;
                $continuation.label = 2;
                v4 = AgentUtilsKt.smartLocateFile$default(pathStr, context, false, (Continuation)$continuation, 4, null);
                if (v4 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl52
            }
            case 2: {
                lineNumber = (Integer)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                this = (OpenFileAgentAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl52:
                // 2 sources

                if ((res = (Result)v4) instanceof Result.Err) {
                    StepMetadataKt.emitMetadata("Open file", StepType.Info, context);
                    return ((Result.Err)res).getMessage();
                }
                Intrinsics.checkNotNull((Object)res, (String)"null cannot be cast to non-null type com.intellij.ml.llm.matterhorn.Result.Ok<com.intellij.openapi.vfs.VirtualFile>");
                (Result.Ok)res;
                StepMetadataKt.emitMetadata("Open " + ((VirtualFile)((Result.Ok)res).getValue()).getName(), StepType.Info, context);
                if (!VfsUtilCore.isAncestor((VirtualFile)context.getProjectDir(), (VirtualFile)((VirtualFile)((Result.Ok)res).getValue()), (boolean)false)) {
                    return "ERROR: Target file is outside of the project directory";
                }
                v5 = lineNumber;
                line = v5 != null ? v5 : 1;
                context.setCurrentScreenPosition(new FileWithLine((VirtualFile)((Result.Ok)res).getValue(), line));
                if (!VfsUtilCore.isAncestor((VirtualFile)context.getProjectDir(), (VirtualFile)((VirtualFile)((Result.Ok)res).getValue()), (boolean)false)) {
                    return "ERROR: Target file is outside of the project directory";
                }
                vFile = (VirtualFile)((Result.Ok)res).getValue();
                v6 = context.getExecutionEnvironment().getPathConverter();
                v7 = vFile.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"toNioPath(...)");
                filePath = v6.convertLocalPathToExecutionPath(new LocalPath(v7));
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = res;
                $continuation.L$3 = vFile;
                $continuation.L$4 = filePath;
                $continuation.I$0 = line;
                $continuation.label = 3;
                v8 = OpenFileAgentActionKt.oncePerSessionShowFileToAgent(context, vFile, filePath, lineNumber == null, (Continuation<? super String>)$continuation);
                if (v8 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl91
            }
            case 3: {
                line = $continuation.I$0;
                filePath = (ExecutionPath)$continuation.L$4;
                vFile = (VirtualFile)$continuation.L$3;
                res = (Result)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                this = (OpenFileAgentAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl91:
                // 2 sources

                if ((var12_15 = (String)v8) != null) {
                    it = var12_15;
                    $i$a$-let-OpenFileAgentAction$execute$2 = false;
                    return it;
                }
                v9 = seenImports = context.getSessionHistory().hasViewedFile(filePath) != false || context.getSessionHistory().hasViewedImport(filePath) != false;
                if (!seenImports) ** GOTO lbl99
                v10 = "";
                ** GOTO lbl118
lbl99:
                // 1 sources

                context.getSessionHistory().markViewedImport(filePath);
                $continuation.L$0 = context;
                $continuation.L$1 = res;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.I$0 = line;
                $continuation.label = 4;
                v11 = this.getFileImports(vFile, filePath, context, (Continuation<? super String>)$continuation);
                if (v11 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl117
            }
            case 4: {
                line = $continuation.I$0;
                res = (Result)$continuation.L$1;
                context = (ExecutionAgentContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v11 = $result;
lbl117:
                // 2 sources

                v10 = v12 = (String)v11;
lbl118:
                // 2 sources

                if (v10 == null) {
                    v12 = "";
                }
                var16_20 = importsButOnlyOnce = v12;
                $continuation.L$0 = var16_20;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 5;
                v13 = AgentUtilsKt.printScreen$default(context.getProject(), (VirtualFile)((Result.Ok)res).getValue(), Math.max(line - 10, 1), 120, context.getExecutionEnvironment().getPathConverter(), null, (Continuation)$continuation, 32, null);
                if (v13 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl135
            }
            case 5: {
                var16_20 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v13 = $result;
lbl135:
                // 2 sources

                return var16_20 + v13;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object getFileImports(VirtualFile vFile, ExecutionPath path, ExecutionAgentContext context2, Continuation<? super String> $completion) {
        return CoroutinesKt.readAction(() -> OpenFileAgentAction.getFileImports$lambda$2(context2, vFile, path), $completion);
    }

    @Override
    @NotNull
    public String getCustomSignature() {
        return AgentAction.DefaultImpls.getCustomSignature(this);
    }

    @Override
    @Nullable
    public Object getInputParams(@NotNull ActionRequest $this$getInputParams, @NotNull Continuation<? super Map<String, ParameterValue>> $completion) {
        return AgentAction.DefaultImpls.getInputParams(this, $this$getInputParams, $completion);
    }

    @Override
    @Nullable
    public Object reviewActionRequest(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        return AgentAction.DefaultImpls.reviewActionRequest(this, request2, context2, $completion);
    }

    private static final String getFileImports$lambda$2(ExecutionAgentContext $context, VirtualFile $vFile, ExecutionPath $path) {
        String string;
        PsiFile psiFile = PsiManager.getInstance((Project)$context.getProject()).findFile($vFile);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        String it = string = ElementProvider.Companion.getImportStatements(psiFile2);
        boolean bl = false;
        String string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
        if (string2 == null) {
            return null;
        }
        String imports = string2;
        Document document = FileDocumentManager.getInstance().getDocument($vFile);
        int documentLineCount = document != null ? document.getLineCount() : 0;
        return "[File: " + $path.safePathForBash() + " (" + documentLineCount + " lines total)]\n##### Imports\n" + imports + "\n\n";
    }

    public static final /* synthetic */ Object access$getFileImports(OpenFileAgentAction $this, VirtualFile vFile, ExecutionPath path, ExecutionAgentContext context2, Continuation $completion) {
        return $this.getFileImports(vFile, path, context2, (Continuation<? super String>)$completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/OpenFileAgentAction$Companion;", "", "<init>", "()V", "PATH_ARGUMENT", "", "LINE_NUMBER_ARGUMENT", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

