/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.helpers;

import com.intellij.ml.llm.matterhorn.helpers.PathHelpers;
import io.ktor.http.ContentType;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/matterhorn/helpers/ContentTypeHelpers;", "", "<init>", "()V", "getContentTypeByPath", "Lio/ktor/http/ContentType;", "pathString", "", "path", "Ljava/nio/file/Path;", "core"})
@SourceDebugExtension(value={"SMAP\nContentTypeHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentTypeHelpers.kt\ncom/intellij/ml/llm/matterhorn/helpers/ContentTypeHelpers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,15:1\n1#2:16\n*E\n"})
public final class ContentTypeHelpers {
    @NotNull
    public static final ContentTypeHelpers INSTANCE = new ContentTypeHelpers();

    private ContentTypeHelpers() {
    }

    @Nullable
    public final ContentType getContentTypeByPath(@NotNull String pathString) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        Path path = PathHelpers.INSTANCE.tryGetPathWithSameExtension(pathString);
        if (path != null) {
            Path it = path;
            boolean bl = false;
            contentType = INSTANCE.getContentTypeByPath(it);
        } else {
            contentType = null;
        }
        return contentType;
    }

    @Nullable
    public final ContentType getContentTypeByPath(@NotNull Path path) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = Files.probeContentType(path);
        if (string != null) {
            String it = string;
            boolean bl = false;
            contentType = ContentType.Companion.parse(it);
        } else {
            contentType = null;
        }
        return contentType;
    }
}

