/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.helpers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u001a1\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"truncateLongOutput", "", "commandOutput", "maxLines", "", "maxLineLength", "saveLines", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/String;", "core"})
public final class OutputHelperKt {
    @NotNull
    public static final String truncateLongOutput(@NotNull String commandOutput, @Nullable Integer maxLines, @Nullable Integer maxLineLength, @Nullable Integer saveLines) {
        String res2;
        Intrinsics.checkNotNullParameter((Object)commandOutput, (String)"commandOutput");
        List lines = StringsKt.lines((CharSequence)commandOutput);
        if (maxLines != null && lines.size() > maxLines) {
            Integer n = saveLines;
            int linesToTake = Math.min(lines.size() / 2, n != null ? n : 10);
            int omittedLinesCount = lines.size() - linesToTake * 2;
            if (omittedLinesCount < 2) {
                v1 = commandOutput;
            } else {
                String fistSavedLines = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)lines, (int)linesToTake), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                String lastSavedLines = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)lines, (int)linesToTake), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                v1 = fistSavedLines + "\n(" + omittedLinesCount + " lines omitted)\n" + lastSavedLines;
            }
        } else {
            v1 = res2 = commandOutput;
        }
        if (maxLineLength != null) {
            lines = StringsKt.lines((CharSequence)res2);
            res2 = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> OutputHelperKt.truncateLongOutput$lambda$0(maxLineLength, arg_0), (int)30, null);
        }
        return res2;
    }

    private static final CharSequence truncateLongOutput$lambda$0(Integer $maxLineLength, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return (CharSequence)(line.length() > $maxLineLength ? StringsKt.substring((String)line, (IntRange)RangesKt.until((int)0, (int)$maxLineLength)) + " ..." : line);
    }
}

