/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.relevance.extractors;

import com.intellij.ml.llm.matterhorn.AssistantTrajectoryElement;
import com.intellij.ml.llm.matterhorn.ExecutionContext;
import com.intellij.ml.llm.matterhorn.TrajectoryElementAgent;
import com.intellij.ml.llm.matterhorn.UserTrajectoryElement;
import com.intellij.ml.llm.matterhorn.actions.AgentUtilsKt;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatElement;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessage;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageKind;
import com.intellij.ml.llm.matterhorn.relevance.RelevantSymbolsExtractorParameters;
import com.intellij.ml.llm.matterhorn.relevance.extractors.ExtractorUtilsKt;
import com.intellij.ml.llm.matterhorn.relevance.extractors.FormatHierarchyParams;
import com.intellij.ml.llm.matterhorn.relevance.extractors.PsiTrie;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a8\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bH\u0007\u001a\u001e\u0010\u0000\u001a\u00020\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004\u001a,\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u001a\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004\u001aB\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f0\u00032\b\b\u0002\u0010\u0016\u001a\u00020\u00102\b\b\u0002\u0010\u0017\u001a\u00020\u0010\u001a2\u0010\u0018\u001a\u00020\t2\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f0\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u001a\u001a\u00020\t\u001a\n\u0010\u001b\u001a\u00020\t*\u00020\t\u001a\u0016\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t\u001a\u0018\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t\u001a\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$\u001aP\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\b\b\u0002\u0010,\u001a\u00020-H\u0086@\u00a2\u0006\u0002\u0010.\u001a\u0014\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0003\u001a\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u00105\u001a\u00020\t\"\u000e\u0010/\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"formatHierarchy", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "format", "Lcom/intellij/ml/llm/matterhorn/relevance/extractors/FormatHierarchyParams;", "consumer", "Lkotlin/Function2;", "", "getElementRange", "document", "Lcom/intellij/openapi/editor/Document;", "element", "getLineRange", "Lkotlin/Pair;", "", "startOffset", "endOffset", "getImportRange", "combineImportRanges", "ranges", "maxDist", "maxStartLine", "printImportStatements", "importRanges", "separator", "removeLineRange", "getTextByXMLTag", "content", "tag", "getTextByXMLTagNoTrim", "getTrajectoryElementAgent", "Lcom/intellij/ml/llm/matterhorn/TrajectoryElementAgent;", "agentType", "agentParameters", "Lcom/intellij/ml/llm/matterhorn/relevance/RelevantSymbolsExtractorParameters;", "logTrajectories", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionContext;", "systemMessage", "prompt", "rawResponse", "response", "execTime", "", "(Lcom/intellij/ml/llm/matterhorn/ExecutionContext;Ljava/lang/String;Lcom/intellij/ml/llm/matterhorn/relevance/RelevantSymbolsExtractorParameters;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "responseSeparator", "combineMultipleResponse", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChatMessage;", "optionsToRank", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChatElement;", "splitMultipleResponse", "combineResponse", "ej-core"})
@SourceDebugExtension(value={"SMAP\nExtractorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractorUtils.kt\ncom/intellij/ml/llm/matterhorn/relevance/extractors/ExtractorUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,183:1\n1485#2:184\n1510#2,3:185\n1513#2,3:195\n1863#2,2:201\n1863#2,2:203\n1053#2:206\n381#3,7:188\n126#4:198\n153#4,2:199\n155#4:205\n113#5:207\n*S KotlinDebug\n*F\n+ 1 ExtractorUtils.kt\ncom/intellij/ml/llm/matterhorn/relevance/extractors/ExtractorUtilsKt\n*L\n71#1:184\n71#1:185,3\n71#1:195,3\n73#1:201,2\n78#1:203,2\n113#1:206\n71#1:188,7\n71#1:198\n71#1:199,2\n71#1:205\n153#1:207\n*E\n"})
public final class ExtractorUtilsKt {
    @NotNull
    private static final String responseSeparator = "#!#!#!#";

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    public static final void formatHierarchy(@NotNull List<? extends PsiElement> elements, @NotNull FormatHierarchyParams format2, @NotNull Function2<? super PsiElement, ? super String, Unit> consumer) {
        void $this$mapTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterable $this$groupBy$iv = elements;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            PsiFile key$iv$iv = it.getContainingFile();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            PsiFile file = (PsiFile)entry.getKey();
            List elements2 = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)file);
            PsiTrie trie = new PsiTrie(file);
            Iterable $this$forEach$iv = elements2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl3 = false;
                trie.add(it);
            }
            List linesCollected = new ArrayList();
            trie.build(format2, (Function2<? super PsiElement, ? super String, Unit>)((Function2)(arg_0, arg_1) -> ExtractorUtilsKt.formatHierarchy$lambda$4$lambda$2(linesCollected, arg_0, arg_1)));
            if (linesCollected.isEmpty()) {
                consumer.invoke((Object)file, (Object)"");
            } else {
                Iterable $this$forEach$iv2 = linesCollected;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Pair it = (Pair)element$iv;
                    boolean bl4 = false;
                    consumer.invoke(it.getFirst(), it.getSecond());
                }
            }
            object.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @RequiresReadLock
    @NotNull
    public static final String formatHierarchy(@NotNull List<? extends PsiElement> elements, @NotNull FormatHierarchyParams format2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        StringBuilder builder = new StringBuilder();
        ExtractorUtilsKt.formatHierarchy(elements, format2, (Function2<? super PsiElement, ? super String, Unit>)((Function2)(arg_0, arg_1) -> ExtractorUtilsKt.formatHierarchy$lambda$5(builder, arg_0, arg_1)));
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String getElementRange(@NotNull Document document, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TextRange classTextRange = element.getTextRange();
        Pair<Integer, Integer> pair = ExtractorUtilsKt.getLineRange(document, classTextRange.getStartOffset(), classTextRange.getEndOffset());
        int classStartLine = ((Number)pair.component1()).intValue();
        int classEndLine = ((Number)pair.component2()).intValue();
        return "(" + classStartLine + "-" + classEndLine + ")";
    }

    private static final Pair<Integer, Integer> getLineRange(Document document, int startOffset, int endOffset) {
        int startLine = document.getLineNumber(startOffset) + 1;
        int endLine = document.getLineNumber(endOffset) + 1;
        return new Pair((Object)startLine, (Object)endLine);
    }

    @NotNull
    public static final Pair<Integer, Integer> getImportRange(@NotNull Document document, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TextRange importTextRange = element.getTextRange();
        return ExtractorUtilsKt.getLineRange(document, importTextRange.getStartOffset(), importTextRange.getEndOffset());
    }

    @Nullable
    public static final Pair<Integer, Integer> combineImportRanges(@NotNull List<Pair<Integer, Integer>> ranges, int maxDist, int maxStartLine) {
        Pair nextRange;
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        if (ranges.isEmpty()) {
            return null;
        }
        Iterable $this$sortedBy$iv = CollectionsKt.distinct((Iterable)ranges);
        boolean $i$f$sortedBy = false;
        List sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        if (((Number)((Pair)sortedRanges.get(0)).getFirst()).intValue() > maxStartLine) {
            return null;
        }
        Pair currentRange = (Pair)sortedRanges.get(0);
        int n = sortedRanges.size();
        for (int i = 1; i < n && ((Number)(nextRange = (Pair)sortedRanges.get(i)).getFirst()).intValue() - ((Number)currentRange.getSecond()).intValue() <= maxDist; ++i) {
            currentRange = new Pair(currentRange.getFirst(), (Object)Math.max(((Number)currentRange.getSecond()).intValue(), ((Number)nextRange.getSecond()).intValue()));
        }
        return currentRange;
    }

    public static /* synthetic */ Pair combineImportRanges$default(List list, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 15;
        }
        if ((n3 & 4) != 0) {
            n2 = 100;
        }
        return ExtractorUtilsKt.combineImportRanges(list, n, n2);
    }

    @NotNull
    public static final String printImportStatements(@NotNull List<Pair<Integer, Integer>> importRanges, @NotNull Document document, @NotNull String separator) {
        Intrinsics.checkNotNullParameter(importRanges, (String)"importRanges");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Pair importRange = ExtractorUtilsKt.combineImportRanges$default(importRanges, 0, 0, 6, null);
        if (importRange == null) {
            return "";
        }
        return AgentUtilsKt.printScreenPart(((Number)importRange.getFirst()).intValue(), separator, ((Number)importRange.getSecond()).intValue() + 1, document);
    }

    public static /* synthetic */ String printImportStatements$default(List list, Document document, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = ":";
        }
        return ExtractorUtilsKt.printImportStatements(list, document, string);
    }

    @NotNull
    public static final String removeLineRange(@NotNull String $this$removeLineRange) {
        Intrinsics.checkNotNullParameter((Object)$this$removeLineRange, (String)"<this>");
        Regex pattern = new Regex("\\(\\d+-\\d+\\)$");
        CharSequence charSequence = $this$removeLineRange;
        String string = "";
        return ((Object)StringsKt.trim((CharSequence)pattern.replace(charSequence, string))).toString();
    }

    @NotNull
    public static final String getTextByXMLTag(@NotNull String content, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Regex regex = new Regex("<" + tag + ">(.*?)</" + tag + ">", RegexOption.DOT_MATCHES_ALL);
        Object object = Regex.find$default((Regex)regex, (CharSequence)content, (int)0, (int)2, null);
        if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public static final String getTextByXMLTagNoTrim(@NotNull String content, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Regex regex = new Regex("<" + tag + ">(.*?)</" + tag + ">", RegexOption.DOT_MATCHES_ALL);
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)content, (int)0, (int)2, null);
        return matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
    }

    @NotNull
    public static final TrajectoryElementAgent getTrajectoryElementAgent(@NotNull String agentType, @NotNull RelevantSymbolsExtractorParameters agentParameters) {
        Intrinsics.checkNotNullParameter((Object)agentType, (String)"agentType");
        Intrinsics.checkNotNullParameter((Object)agentParameters, (String)"agentParameters");
        Json json = JsonKt.Json$default(null, ExtractorUtilsKt::getTrajectoryElementAgent$lambda$7, (int)1, null);
        String modelName = agentParameters.getModelParameters().getModel().toString();
        StringFormat $this$encodeToString$iv = (StringFormat)json;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String agentParametersStr = $this$encodeToString$iv.encodeToString((SerializationStrategy)RelevantSymbolsExtractorParameters.Companion.serializer(), (Object)agentParameters);
        return new TrajectoryElementAgent(agentType, "0.1", modelName, agentParametersStr);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object logTrajectories(@NotNull ExecutionContext var0, @NotNull String var1_1, @NotNull RelevantSymbolsExtractorParameters var2_2, @NotNull String var3_3, @NotNull String var4_4, @NotNull String var5_5, @NotNull String var6_6, long var7_7, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof logTrajectories.1)) ** GOTO lbl-1000
        var13_9 = $completion;
        if ((var13_9.label & -2147483648) != 0) {
            var13_9.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                long J$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ExtractorUtilsKt.logTrajectories(null, null, null, null, null, null, null, 0L, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_11 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                curTrajectoryElementAgent = ExtractorUtilsKt.getTrajectoryElementAgent(agentType, agentParameters);
                if (((CharSequence)systemMessage).length() > 0) {
                    $continuation.L$0 = context;
                    $continuation.L$1 = agentType;
                    $continuation.L$2 = agentParameters;
                    $continuation.L$3 = prompt;
                    $continuation.L$4 = rawResponse;
                    $continuation.L$5 = response;
                    $continuation.L$6 = curTrajectoryElementAgent;
                    $continuation.J$0 = execTime;
                    $continuation.label = 1;
                    v0 = context.logTrajectoryElement(new UserTrajectoryElement(curTrajectoryElementAgent, (String)systemMessage, "system", false, 8, null), (Continuation<? super Unit>)$continuation);
                    if (v0 == var14_11) {
                        return var14_11;
                    }
                }
                ** GOTO lbl38
            }
            case 1: {
                execTime = $continuation.J$0;
                curTrajectoryElementAgent = (TrajectoryElementAgent)$continuation.L$6;
                response = (String)$continuation.L$5;
                rawResponse = (String)$continuation.L$4;
                prompt = (String)$continuation.L$3;
                agentParameters = (RelevantSymbolsExtractorParameters)$continuation.L$2;
                agentType = (String)$continuation.L$1;
                context = (ExecutionContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                if (((CharSequence)prompt).length() > 0) {
                    $continuation.L$0 = context;
                    $continuation.L$1 = agentType;
                    $continuation.L$2 = agentParameters;
                    $continuation.L$3 = rawResponse;
                    $continuation.L$4 = response;
                    $continuation.L$5 = curTrajectoryElementAgent;
                    $continuation.L$6 = null;
                    $continuation.J$0 = execTime;
                    $continuation.label = 2;
                    v1 = context.logTrajectoryElement(new UserTrajectoryElement(curTrajectoryElementAgent, prompt, null, false, 12, null), (Continuation<? super Unit>)$continuation);
                    if (v1 == var14_11) {
                        return var14_11;
                    }
                }
                ** GOTO lbl62
            }
            case 2: {
                execTime = $continuation.J$0;
                curTrajectoryElementAgent = (TrajectoryElementAgent)$continuation.L$5;
                response = (String)$continuation.L$4;
                rawResponse = (String)$continuation.L$3;
                agentParameters = (RelevantSymbolsExtractorParameters)$continuation.L$2;
                agentType = (String)$continuation.L$1;
                context = (ExecutionContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl62:
                // 2 sources

                if (((CharSequence)rawResponse).length() > 0) {
                    curTrajectoryElementAgentRaw = ExtractorUtilsKt.getTrajectoryElementAgent(agentType + "_RAW", agentParameters);
                    $continuation.L$0 = context;
                    $continuation.L$1 = response;
                    $continuation.L$2 = curTrajectoryElementAgent;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.L$5 = null;
                    $continuation.L$6 = null;
                    $continuation.J$0 = execTime;
                    $continuation.label = 3;
                    v2 = context.logTrajectoryElement(new UserTrajectoryElement(curTrajectoryElementAgentRaw, rawResponse, null, false, 12, null), (Continuation<? super Unit>)$continuation);
                    if (v2 == var14_11) {
                        return var14_11;
                    }
                }
                ** GOTO lbl84
            }
            case 3: {
                execTime = $continuation.J$0;
                curTrajectoryElementAgent = (TrajectoryElementAgent)$continuation.L$2;
                response = (String)$continuation.L$1;
                context = (ExecutionContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl84:
                // 2 sources

                execTimeStr = execTime >= 0L ? "\n\nEXECUTION_TIME: " + execTime + " ms" : "";
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.L$6 = null;
                $continuation.label = 4;
                v3 = context.logTrajectoryElement(new AssistantTrajectoryElement(curTrajectoryElementAgent, response + (String)execTimeStr, "", "", null, null, null, 64, null), (Continuation<? super Unit>)$continuation);
                if (v3 == var14_11) {
                    return var14_11;
                }
                ** GOTO lbl100
            }
            case 4: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl100:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object logTrajectories$default(ExecutionContext executionContext, String string, RelevantSymbolsExtractorParameters relevantSymbolsExtractorParameters, String string2, String string3, String string4, String string5, long l, Continuation continuation, int n, Object object) {
        if ((n & 0x80) != 0) {
            l = -1L;
        }
        return ExtractorUtilsKt.logTrajectories(executionContext, string, relevantSymbolsExtractorParameters, string2, string3, string4, string5, l, (Continuation<? super Unit>)continuation);
    }

    @NotNull
    public static final MatterhornChatMessage combineMultipleResponse(@NotNull List<? extends MatterhornChatElement> optionsToRank) {
        Intrinsics.checkNotNullParameter(optionsToRank, (String)"optionsToRank");
        return new MatterhornChatMessage(CollectionsKt.joinToString$default((Iterable)optionsToRank, (CharSequence)responseSeparator, null, null, (int)0, null, ExtractorUtilsKt::combineMultipleResponse$lambda$8, (int)30, null), MatterhornChatMessageKind.Assistant, null, 4, null);
    }

    @NotNull
    public static final List<String> splitMultipleResponse(@NotNull String combineResponse) {
        Intrinsics.checkNotNullParameter((Object)combineResponse, (String)"combineResponse");
        String[] stringArray = new String[]{responseSeparator};
        return StringsKt.split$default((CharSequence)combineResponse, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    private static final Unit formatHierarchy$lambda$4$lambda$2(List $linesCollected, PsiElement element, String text) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $linesCollected.add(TuplesKt.to((Object)element, (Object)text));
        return Unit.INSTANCE;
    }

    private static final Unit formatHierarchy$lambda$5(StringBuilder $builder, PsiElement element, String text) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        StringBuilder stringBuilder = $builder;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(AgentUtilsKt.relativePath(psiFile, project) + ":: " + text);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        return Unit.INSTANCE;
    }

    private static final Unit getTrajectoryElementAgent$lambda$7(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setEncodeDefaults(true);
        return Unit.INSTANCE;
    }

    private static final CharSequence combineMultipleResponse$lambda$8(MatterhornChatElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContent();
    }
}

