/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.utils;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J\u001e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils;", "", "<init>", "()V", "countTags", "", "", "Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;", "text", "tagsToCount", "", "fixTagPair", "Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$FixTagsResult;", "tagName", "tagInfo", "tagsToProcess", "getEditTags", "updateMainTagsState", "Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$MainTagsState;", "mainTags", "fixSubTags", "innerContent", "fixXMLTags", "TagInfo", "MainTagsState", "FixTagsResult", "core"})
@SourceDebugExtension(value={"SMAP\nTagParsingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TagParsingUtils.kt\ncom/intellij/ml/llm/matterhorn/utils/TagParsingUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,220:1\n1279#2,2:221\n1293#2,4:223\n774#2:235\n865#2,2:236\n1#3:227\n535#4:228\n520#4,6:229\n14#5:238\n14#5:239\n14#5:240\n14#5:241\n14#5:242\n*S KotlinDebug\n*F\n+ 1 TagParsingUtils.kt\ncom/intellij/ml/llm/matterhorn/utils/TagParsingUtils\n*L\n35#1:221,2\n35#1:223,4\n139#1:235\n139#1:236,2\n117#1:228\n117#1:229,6\n145#1:238\n154#1:239\n166#1:240\n176#1:241\n213#1:242\n*E\n"})
public final class TagParsingUtils {
    @NotNull
    public static final TagParsingUtils INSTANCE = new TagParsingUtils();

    private TagParsingUtils() {
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, TagInfo> countTags(String text, List<String> tagsToCount) {
        Iterable $this$associateWith$iv = tagsToCount;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void tag;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            TagInfo tagInfo = new TagInfo(tag.length(), null, null, 6, null);
            int pos = 0;
            while (pos < text.length()) {
                Integer n;
                int openPos = StringsKt.indexOf$default((CharSequence)text, (String)("<" + (String)tag + ">"), (int)pos, (boolean)false, (int)4, null);
                int closePos = StringsKt.indexOf$default((CharSequence)text, (String)("</" + (String)tag + ">"), (int)pos, (boolean)false, (int)4, null);
                if (openPos == -1 && closePos == -1) break;
                if (openPos != -1 && (closePos == -1 || openPos < closePos)) {
                    n = openPos;
                    ((Collection)tagInfo.getOpenIndices()).add(n);
                    pos = openPos + 1;
                    continue;
                }
                n = closePos;
                ((Collection)tagInfo.getCloseIndices()).add(n);
                pos = closePos + 1;
            }
            TagInfo tagInfo2 = tagInfo;
            map.put(t, tagInfo2);
        }
        return result$iv;
    }

    private final FixTagsResult fixTagPair(String text, String tagName, TagInfo tagInfo, List<String> tagsToProcess) {
        FixTagsResult fixTagsResult;
        int tagLength = tagInfo.component1();
        List<Integer> openIndices = tagInfo.component2();
        List<Integer> closeIndices = tagInfo.component3();
        if (tagInfo.getOpenCount() == 2 && tagInfo.getCloseCount() == 0) {
            String string = text;
            int n = ((Number)openIndices.get(1)).intValue();
            int n2 = ((Number)openIndices.get(1)).intValue() + tagLength + 2;
            CharSequence charSequence = "</" + tagName + ">";
            FixTagsResult fixTagsResult2 = new FixTagsResult(((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n2, (CharSequence)charSequence)).toString(), true);
            fixTagsResult = fixTagsResult2;
        } else if (tagInfo.getOpenCount() == 0 && tagInfo.getCloseCount() == 2) {
            String string = text;
            int n = ((Number)closeIndices.get(0)).intValue();
            int n3 = ((Number)closeIndices.get(0)).intValue() + tagLength + 3;
            CharSequence charSequence = "<" + tagName + ">";
            FixTagsResult fixTagsResult3 = new FixTagsResult(((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n3, (CharSequence)charSequence)).toString(), true);
            fixTagsResult = fixTagsResult3;
        } else if (tagInfo.getOpenCount() == 1 && tagInfo.getCloseCount() == 0) {
            int n;
            Object nextTag;
            int tagIndex = tagsToProcess.indexOf(tagName);
            if (tagIndex < CollectionsKt.getLastIndex(tagsToProcess)) {
                nextTag = "<" + tagsToProcess.get(tagIndex + 1) + ">";
                Integer n4 = StringsKt.indexOf$default((CharSequence)text, (String)nextTag, (int)(((Number)openIndices.get(0)).intValue() + 1), (boolean)false, (int)4, null);
                int it = ((Number)n4).intValue();
                boolean bl = false;
                Integer n5 = it != -1 ? n4 : null;
                n = n5 != null ? n5.intValue() : text.length();
            } else {
                n = text.length();
            }
            int nextTagPos = n;
            nextTag = text;
            CharSequence charSequence = "</" + tagName + ">\n";
            FixTagsResult fixTagsResult4 = new FixTagsResult(((Object)StringsKt.replaceRange((CharSequence)((CharSequence)nextTag), (int)nextTagPos, (int)nextTagPos, (CharSequence)charSequence)).toString(), true);
            fixTagsResult = fixTagsResult4;
        } else if (tagInfo.getOpenCount() == 0 && tagInfo.getCloseCount() == 1) {
            int n;
            int tagIndex = tagsToProcess.indexOf(tagName);
            if (tagIndex > 0) {
                String prevTag = "</" + tagsToProcess.get(tagIndex - 1) + ">";
                Integer n6 = StringsKt.lastIndexOf$default((CharSequence)text, (String)prevTag, (int)((Number)closeIndices.get(0)).intValue(), (boolean)false, (int)4, null);
                int it = ((Number)n6).intValue();
                boolean bl = false;
                Integer n7 = it != -1 ? n6 : null;
                n = n7 != null ? n7 + prevTag.length() : 0;
            } else {
                n = 0;
            }
            int prevTagEndPos = n;
            String string = text;
            CharSequence charSequence = "\n<" + tagName + ">";
            FixTagsResult fixTagsResult5 = new FixTagsResult(((Object)StringsKt.replaceRange((CharSequence)string, (int)prevTagEndPos, (int)prevTagEndPos, (CharSequence)charSequence)).toString(), true);
            fixTagsResult = fixTagsResult5;
        } else {
            fixTagsResult = new FixTagsResult(text, false);
        }
        return fixTagsResult;
    }

    private final List<String> getEditTags(String text) {
        Regex editTagPattern = new Regex("</?EDIT(\\d{0,2})>");
        return CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)editTagPattern, (CharSequence)text, (int)0, (int)2, null), TagParsingUtils::getEditTags$lambda$3))));
    }

    private final MainTagsState updateMainTagsState(String text, List<String> mainTags) {
        Map<String, TagInfo> tagInfos = this.countTags(text, mainTags);
        return new MainTagsState(tagInfos, tagInfos.get("THOUGHT"), tagInfos.get("COMMAND"));
    }

    /*
     * WARNING - void declaration
     */
    private final FixTagsResult fixSubTags(String innerContent, List<String> tagsToProcess) {
        void $this$filterTo$iv$iv;
        Map<String, TagInfo> tagInfos;
        Map<String, TagInfo> $this$filter$iv = tagInfos = this.countTags(innerContent, tagsToProcess);
        boolean $i$f$filter = false;
        Map<String, TagInfo> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((TagInfo)it.getValue()).getOpenCount() != ((TagInfo)it.getValue()).getCloseCount())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map tagsToFix = destination$iv$iv;
        if (tagsToFix.isEmpty() || tagsToFix.size() > 1) {
            return new FixTagsResult(innerContent, false);
        }
        Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)tagsToFix.entrySet());
        String tagName = (String)entry.getKey();
        TagInfo tagInfo = (TagInfo)entry.getValue();
        return this.fixTagPair(innerContent, tagName, tagInfo, tagsToProcess);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String fixXMLTags(@NotNull String text) {
        FixTagsResult result;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object[] objectArray = new String[]{"THOUGHT", "COMMAND"};
        List mainTags = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new String[]{"PREVIOUS_STEP", "PLAN", "NEXT_STEP"};
        List thoughtSubTags = CollectionsKt.listOf((Object[])objectArray2);
        Object[] objectArray3 = new String[]{"FILE_PATH", "SEARCH", "REPLACE"};
        List editSubTags = CollectionsKt.listOf((Object[])objectArray3);
        Object newText = text;
        MainTagsState state = this.updateMainTagsState((String)newText, mainTags);
        if (state.getCommandInfo() != null && state.getCommandInfo().getOpenCount() > 0) {
            Iterable iterable;
            int firstCommandPos = ((Number)CollectionsKt.first(state.getCommandInfo().getOpenIndices())).intValue();
            Collection collection = CollectionsKt.drop((Iterable)state.getCommandInfo().getOpenIndices(), (int)1);
            Object object = state.getThoughtInfo();
            if (object != null && (object = ((TagInfo)object).getOpenIndices()) != null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable2 = (Iterable)object;
                Collection collection2 = collection;
                boolean $i$f$filter = false;
                Iterator<String> iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    int it = ((Number)element$iv$iv).intValue();
                    boolean bl = false;
                    if (!(it > firstCommandPos)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = collection2;
                iterable = (List)destination$iv$iv;
            } else {
                iterable = CollectionsKt.emptyList();
            }
            Integer secondCommandPos = (Integer)CollectionsKt.minOrNull((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)iterable));
            if (secondCommandPos != null) {
                int n = secondCommandPos;
                String string = ((String)newText).substring(0, n);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                newText = ((Object)StringsKt.trim((CharSequence)string)).toString();
                state = this.updateMainTagsState((String)newText, mainTags);
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TagParsingUtils.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("TAGS FIXED: removed second commands");
            }
        }
        if (state.getThoughtInfo() != null && state.getThoughtInfo().getOpenCount() == 2 && state.getThoughtInfo().getCloseCount() == 0 && (result = this.fixTagPair((String)newText, "THOUGHT", state.getThoughtInfo(), mainTags)).getChanged()) {
            newText = result.getContent();
            state = this.updateMainTagsState((String)newText, mainTags);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TagParsingUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("TAGS FIXED: closing THOUGHT_TAG");
        }
        if (state.getCommandInfo() != null && state.getCommandInfo().getOpenCount() > 0 && state.getCommandInfo().getCloseCount() == 0) {
            boolean commandCloseBad = StringsKt.endsWith$default((String)((Object)StringsKt.trimEnd((CharSequence)((CharSequence)newText))).toString(), (String)"</COMMAND", (boolean)false, (int)2, null);
            newText = commandCloseBad ? ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)newText))).toString() + ">" : (String)newText + "\n</COMMAND>";
            state = this.updateMainTagsState((String)newText, mainTags);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TagParsingUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("TAGS FIXED: closing COMMAND_TAG");
        }
        if (state.getThoughtInfo() != null && state.getThoughtInfo().getOpenCount() > 0 && state.getThoughtInfo().getCloseCount() > 0) {
            int thoughtStartContent = ((Number)CollectionsKt.first(state.getThoughtInfo().getOpenIndices())).intValue() + 7 + 2;
            int thoughtEndContent = ((Number)CollectionsKt.first(state.getThoughtInfo().getCloseIndices())).intValue();
            String string = ((String)newText).substring(thoughtStartContent, thoughtEndContent);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            FixTagsResult fixResult = this.fixSubTags(string, thoughtSubTags);
            if (fixResult.getChanged()) {
                Object object = newText;
                CharSequence charSequence = fixResult.getContent();
                newText = ((Object)StringsKt.replaceRange((CharSequence)((CharSequence)object), (int)thoughtStartContent, (int)thoughtEndContent, (CharSequence)charSequence)).toString();
                state = this.updateMainTagsState((String)newText, mainTags);
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TagParsingUtils.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("TAGS FIXED: THOUGHT SUB_TAGs");
            }
        }
        boolean commandContentChanged = false;
        if (state.getCommandInfo() != null && state.getCommandInfo().getOpenCount() > 0 && state.getCommandInfo().getCloseCount() > 0) {
            int commandStartContent = ((Number)CollectionsKt.first(state.getCommandInfo().getOpenIndices())).intValue() + 7 + 2;
            int commandEndContent = ((Number)CollectionsKt.first(state.getCommandInfo().getCloseIndices())).intValue();
            String string = ((String)newText).substring(commandStartContent, commandEndContent);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String commandContent = string;
            List<String> editTags = this.getEditTags(commandContent);
            if (!((Collection)editTags).isEmpty()) {
                FixTagsResult fixResult = this.fixSubTags(commandContent, editTags);
                if (fixResult.getChanged()) {
                    commandContent = fixResult.getContent();
                    commandContentChanged = true;
                }
                Map<String, TagInfo> editTagsInfos = this.countTags(commandContent, editTags);
                for (String editTag : editTags) {
                    String editContent;
                    TagInfo tagInfo;
                    if (editTagsInfos.get(editTag) == null || tagInfo.getOpenCount() <= 0 || tagInfo.getCloseCount() <= 0) continue;
                    int editStartContent = ((Number)CollectionsKt.first(tagInfo.getOpenIndices())).intValue() + editTag.length() + 2;
                    int editEndContent = ((Number)CollectionsKt.first(tagInfo.getCloseIndices())).intValue();
                    Intrinsics.checkNotNullExpressionValue((Object)commandContent.substring(editStartContent, editEndContent), (String)"substring(...)");
                    FixTagsResult fixResult2 = this.fixSubTags(editContent, editSubTags);
                    if (!fixResult2.getChanged()) continue;
                    String string2 = commandContent;
                    CharSequence charSequence = fixResult2.getContent();
                    commandContent = ((Object)StringsKt.replaceRange((CharSequence)string2, (int)editStartContent, (int)editEndContent, (CharSequence)charSequence)).toString();
                    editTagsInfos = this.countTags(commandContent, editTags);
                    commandContentChanged = true;
                }
            }
            if (commandContentChanged) {
                newText = ((Object)StringsKt.replaceRange((CharSequence)((CharSequence)newText), (int)commandStartContent, (int)commandEndContent, (CharSequence)commandContent)).toString();
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TagParsingUtils.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("TAGS FIXED: EDIT");
            }
        }
        return newText;
    }

    private static final String getEditTags$lambda$3(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        return "EDIT" + matchResult.getGroupValues().get(1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$FixTagsResult;", "", "content", "", "changed", "", "<init>", "(Ljava/lang/String;Z)V", "getContent", "()Ljava/lang/String;", "getChanged", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "core"})
    private static final class FixTagsResult {
        @NotNull
        private final String content;
        private final boolean changed;

        public FixTagsResult(@NotNull String content, boolean changed) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.changed = changed;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        public final boolean getChanged() {
            return this.changed;
        }

        @NotNull
        public final String component1() {
            return this.content;
        }

        public final boolean component2() {
            return this.changed;
        }

        @NotNull
        public final FixTagsResult copy(@NotNull String content, boolean changed) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new FixTagsResult(content, changed);
        }

        public static /* synthetic */ FixTagsResult copy$default(FixTagsResult fixTagsResult, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = fixTagsResult.content;
            }
            if ((n & 2) != 0) {
                bl = fixTagsResult.changed;
            }
            return fixTagsResult.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "FixTagsResult(content=" + this.content + ", changed=" + this.changed + ")";
        }

        public int hashCode() {
            int result = this.content.hashCode();
            result = result * 31 + Boolean.hashCode(this.changed);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FixTagsResult)) {
                return false;
            }
            FixTagsResult fixTagsResult = (FixTagsResult)other;
            if (!Intrinsics.areEqual((Object)this.content, (Object)fixTagsResult.content)) {
                return false;
            }
            return this.changed == fixTagsResult.changed;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J7\u0010\u0012\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$MainTagsState;", "", "tagInfos", "", "", "Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;", "thoughtInfo", "commandInfo", "<init>", "(Ljava/util/Map;Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;)V", "getTagInfos", "()Ljava/util/Map;", "getThoughtInfo", "()Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;", "getCommandInfo", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class MainTagsState {
        @NotNull
        private final Map<String, TagInfo> tagInfos;
        @Nullable
        private final TagInfo thoughtInfo;
        @Nullable
        private final TagInfo commandInfo;

        public MainTagsState(@NotNull Map<String, TagInfo> tagInfos, @Nullable TagInfo thoughtInfo, @Nullable TagInfo commandInfo) {
            Intrinsics.checkNotNullParameter(tagInfos, (String)"tagInfos");
            this.tagInfos = tagInfos;
            this.thoughtInfo = thoughtInfo;
            this.commandInfo = commandInfo;
        }

        @NotNull
        public final Map<String, TagInfo> getTagInfos() {
            return this.tagInfos;
        }

        @Nullable
        public final TagInfo getThoughtInfo() {
            return this.thoughtInfo;
        }

        @Nullable
        public final TagInfo getCommandInfo() {
            return this.commandInfo;
        }

        @NotNull
        public final Map<String, TagInfo> component1() {
            return this.tagInfos;
        }

        @Nullable
        public final TagInfo component2() {
            return this.thoughtInfo;
        }

        @Nullable
        public final TagInfo component3() {
            return this.commandInfo;
        }

        @NotNull
        public final MainTagsState copy(@NotNull Map<String, TagInfo> tagInfos, @Nullable TagInfo thoughtInfo, @Nullable TagInfo commandInfo) {
            Intrinsics.checkNotNullParameter(tagInfos, (String)"tagInfos");
            return new MainTagsState(tagInfos, thoughtInfo, commandInfo);
        }

        public static /* synthetic */ MainTagsState copy$default(MainTagsState mainTagsState, Map map, TagInfo tagInfo, TagInfo tagInfo2, int n, Object object) {
            if ((n & 1) != 0) {
                map = mainTagsState.tagInfos;
            }
            if ((n & 2) != 0) {
                tagInfo = mainTagsState.thoughtInfo;
            }
            if ((n & 4) != 0) {
                tagInfo2 = mainTagsState.commandInfo;
            }
            return mainTagsState.copy(map, tagInfo, tagInfo2);
        }

        @NotNull
        public String toString() {
            return "MainTagsState(tagInfos=" + this.tagInfos + ", thoughtInfo=" + this.thoughtInfo + ", commandInfo=" + this.commandInfo + ")";
        }

        public int hashCode() {
            int result = ((Object)this.tagInfos).hashCode();
            result = result * 31 + (this.thoughtInfo == null ? 0 : this.thoughtInfo.hashCode());
            result = result * 31 + (this.commandInfo == null ? 0 : this.commandInfo.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MainTagsState)) {
                return false;
            }
            MainTagsState mainTagsState = (MainTagsState)other;
            if (!Intrinsics.areEqual(this.tagInfos, mainTagsState.tagInfos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.thoughtInfo, (Object)mainTagsState.thoughtInfo)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.commandInfo, (Object)mainTagsState.commandInfo);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/matterhorn/utils/TagParsingUtils$TagInfo;", "", "tagLength", "", "openIndices", "", "closeIndices", "<init>", "(ILjava/util/List;Ljava/util/List;)V", "getTagLength", "()I", "getOpenIndices", "()Ljava/util/List;", "getCloseIndices", "openCount", "getOpenCount", "closeCount", "getCloseCount", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    private static final class TagInfo {
        private final int tagLength;
        @NotNull
        private final List<Integer> openIndices;
        @NotNull
        private final List<Integer> closeIndices;

        public TagInfo(int tagLength, @NotNull List<Integer> openIndices, @NotNull List<Integer> closeIndices) {
            Intrinsics.checkNotNullParameter(openIndices, (String)"openIndices");
            Intrinsics.checkNotNullParameter(closeIndices, (String)"closeIndices");
            this.tagLength = tagLength;
            this.openIndices = openIndices;
            this.closeIndices = closeIndices;
        }

        public /* synthetic */ TagInfo(int n, List list, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                list = new ArrayList();
            }
            if ((n2 & 4) != 0) {
                list2 = new ArrayList();
            }
            this(n, list, list2);
        }

        public final int getTagLength() {
            return this.tagLength;
        }

        @NotNull
        public final List<Integer> getOpenIndices() {
            return this.openIndices;
        }

        @NotNull
        public final List<Integer> getCloseIndices() {
            return this.closeIndices;
        }

        public final int getOpenCount() {
            return this.openIndices.size();
        }

        public final int getCloseCount() {
            return this.closeIndices.size();
        }

        public final int component1() {
            return this.tagLength;
        }

        @NotNull
        public final List<Integer> component2() {
            return this.openIndices;
        }

        @NotNull
        public final List<Integer> component3() {
            return this.closeIndices;
        }

        @NotNull
        public final TagInfo copy(int tagLength, @NotNull List<Integer> openIndices, @NotNull List<Integer> closeIndices) {
            Intrinsics.checkNotNullParameter(openIndices, (String)"openIndices");
            Intrinsics.checkNotNullParameter(closeIndices, (String)"closeIndices");
            return new TagInfo(tagLength, openIndices, closeIndices);
        }

        public static /* synthetic */ TagInfo copy$default(TagInfo tagInfo, int n, List list, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = tagInfo.tagLength;
            }
            if ((n2 & 2) != 0) {
                list = tagInfo.openIndices;
            }
            if ((n2 & 4) != 0) {
                list2 = tagInfo.closeIndices;
            }
            return tagInfo.copy(n, list, list2);
        }

        @NotNull
        public String toString() {
            return "TagInfo(tagLength=" + this.tagLength + ", openIndices=" + this.openIndices + ", closeIndices=" + this.closeIndices + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.tagLength);
            result = result * 31 + ((Object)this.openIndices).hashCode();
            result = result * 31 + ((Object)this.closeIndices).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TagInfo)) {
                return false;
            }
            TagInfo tagInfo = (TagInfo)other;
            if (this.tagLength != tagInfo.tagLength) {
                return false;
            }
            if (!Intrinsics.areEqual(this.openIndices, tagInfo.openIndices)) {
                return false;
            }
            return Intrinsics.areEqual(this.closeIndices, tagInfo.closeIndices);
        }
    }
}

